/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.VamsasArchive;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.objects.core.ApplicationData;
import uk.ac.vamsas.objects.core.Instance;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;
import uk.ac.vamsas.test.simpleclient.CommandProcessor;

public class ArchiveWriter {
    static Log log = LogFactory.getLog((Class)ArchiveWriter.class);
    private static CommandProcessor cproc;

    private static void mergeVecs(Object[] destvec, Object[] svec1, Object[] svec2) {
        int i;
        for (i = 0; i < svec1.length; ++i) {
            destvec[i] = svec1[i];
        }
        for (int j = 0; j < svec2.length; ++j) {
            destvec[i] = svec2[j];
            ++i;
        }
    }

    public static Hashtable hashOfAppDatas(Hashtable ht, Instance[] appdatas) {
        if (ht == null) {
            ht = new Hashtable();
        }
        int j = appdatas.length;
        for (int i = 0; i < j; ++i) {
            if (ht.containsKey(appdatas[i].getUrn())) continue;
            Hashtable<Instance, String> aphash = new Hashtable<Instance, String>();
            ht.put(appdatas[i].getUrn(), aphash);
            aphash.put(appdatas[i], appdatas[i].getDataReference());
        }
        return ht;
    }

    public static void addAppDataEntry(VamsasArchive darc, VamsasDocument dest, VamsasArchiveReader sarc, ApplicationData entry) {
        ApplicationData newo = new ApplicationData();
        int j = dest.getApplicationDataCount();
        for (int i = 0; i < j; ++i) {
            ApplicationData o = dest.getApplicationData()[i];
            boolean v = true;
        }
    }

    public static boolean mergeDocs(VamsasArchive darc, VamsasDocument dest, VamsasArchiveReader sarc, VamsasDocument source) {
        log.debug((Object)"mergeDocs entered.");
        Object[] newr = new VAMSAS[dest.getVAMSASCount() + source.getVAMSASCount()];
        ArchiveWriter.mergeVecs(newr, dest.getVAMSAS(), source.getVAMSAS());
        dest.setVAMSAS((VAMSAS[])newr);
        if (source.getApplicationDataCount() > 0) {
            ApplicationData[] newdat = new ApplicationData[source.getApplicationDataCount() + dest.getApplicationDataCount()];
            ApplicationData[] sappd = source.getApplicationData();
            for (int i = 0; i < sappd.length; ++i) {
                ArchiveWriter.addAppDataEntry(darc, dest, sarc, sappd[i]);
            }
        }
        return true;
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            log.fatal((Object)"Usage : <archive to create> [(commands)]");
            return;
        }
        File newarch = new File(argv[0]);
        int argpos = 0;
        try {
            VamsasArchive varc = new VamsasArchive(newarch, true);
            VamsasDocument docroot = new VamsasDocument();
            docroot.setProvenance(ProvenanceStuff.newProvenance("ArchiveWriter", "user", "Created new Vamsas Document"));
            while (++argpos < argv.length) {
                File archive = new File(argv[argpos]);
                if (archive.exists()) {
                    InputStream istream;
                    VamsasArchiveReader vdoc = new VamsasArchiveReader(archive);
                    if (vdoc.isValid()) {
                        istream = vdoc.getVamsasDocumentStream();
                        if (istream != null) {
                            VamsasDocument cdocroot = VamsasDocument.unmarshal(new InputStreamReader(istream));
                            if (cdocroot == null) continue;
                            ArchiveWriter.mergeDocs(varc, docroot, vdoc, cdocroot);
                            continue;
                        }
                        log.warn((Object)("Unexpectedly null document stream from existing document " + archive));
                        continue;
                    }
                    istream = vdoc.getVamsasXmlStream();
                    if (istream == null) continue;
                    VAMSAS root = VAMSAS.unmarshal(new InputStreamReader(istream));
                    docroot.getProvenance().addEntry(ProvenanceStuff.newProvenanceEntry("ArchiveWriter", "user", "added vamsas.xml from " + argv[argpos - 1]));
                    docroot.addVAMSAS(root);
                    continue;
                }
                PrintWriter docwriter = varc.getDocumentOutputStream();
            }
        }
        catch (Exception e) {
            log.error((Object)("Whilst manipulating " + argv[0]), (Throwable)e);
        }
    }

    static {
        cproc.addCommand("new", 0, "no args");
        cproc.addCommand("add", 1, "Need another vamsas document archive filename as argument.");
        cproc.addCommand("repair", 0, "no args");
        cproc.addCommand("list", 0, "no args");
        cproc.addCommand("monitor", 0, "no args");
    }
}

