/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.helpers;

import jalview.ws2.actions.api.JobI;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.JobStatus;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class TaskEventSupport<T> {
    private TaskI<T> source;
    private List<TaskEventListener<T>> listeners = new CopyOnWriteArrayList<TaskEventListener<T>>();

    public TaskEventSupport(TaskI<T> source) {
        this.source = source;
    }

    public TaskEventSupport(TaskI<T> source, TaskEventListener<T> handler) {
        this(source);
        this.addListener(handler);
    }

    public void addListener(TaskEventListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TaskEventListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void fireTaskStarted(List<? extends JobI> subJobs) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.taskStarted(this.source, subJobs);
        }
    }

    public void fireTaskStatusChanged(JobStatus status) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.taskStatusChanged(this.source, status);
        }
    }

    public void fireTaskCompleted(T result) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.taskCompleted(this.source, result);
        }
    }

    public void fireTaskException(Exception e) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.taskException(this.source, e);
        }
    }

    public void fireSubJobStatusChanged(JobI job, JobStatus status) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.subJobStatusChanged(this.source, job, status);
        }
    }

    public void fireSubJobLogChanged(JobI job, String log) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.subJobLogChanged(this.source, job, log);
        }
    }

    public void fireSubJobErrorLogChanged(JobI job, String log) {
        for (TaskEventListener<T> listener : this.listeners) {
            listener.subJobErrorLogChanged(this.source, job, log);
        }
    }
}

