/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.slivka;

import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.ws.params.ArgumentI;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.WebServiceClientI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.dundee.compbio.slivkaclient.Job;
import uk.ac.dundee.compbio.slivkaclient.Parameter;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.RequestValues;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaWSClient
implements WebServiceClientI {
    final SlivkaService service;
    final SlivkaClient client;
    static final Pattern mediaTypePattern = Pattern.compile("(?:text|application)\\/(?:x-)?([\\w-]+)");
    protected static final EnumMap<Job.Status, JobStatus> statusMap = new EnumMap(Job.Status.class);

    SlivkaWSClient(SlivkaClient client, SlivkaService service) {
        this.service = service;
        this.client = client;
    }

    @Override
    public String getUrl() {
        return this.client.getUrl().toString();
    }

    @Override
    public String getClientName() {
        return "slivka";
    }

    @Override
    public WebServiceJobHandle submit(List<SequenceI> sequences, List<ArgumentI> args, Credentials credentials) throws IOException {
        RequestValues request = new RequestValues();
        for (Parameter param : this.service.getParameters()) {
            if (!(param instanceof Parameter.FileParameter)) continue;
            Parameter.FileParameter fileParam = (Parameter.FileParameter)param;
            FileFormatI format = null;
            Matcher match = mediaTypePattern.matcher(fileParam.getMediaType());
            if (match.find()) {
                String fmt = match.group(1);
                if (fmt.equalsIgnoreCase("pfam")) {
                    format = FileFormat.Pfam;
                } else if (fmt.equalsIgnoreCase("stockholm")) {
                    format = FileFormat.Stockholm;
                } else if (fmt.equalsIgnoreCase("clustal")) {
                    format = FileFormat.Clustal;
                } else if (fmt.equalsIgnoreCase("fasta")) {
                    format = FileFormat.Fasta;
                }
            }
            if (format == null) {
                Console.warn(String.format("Unknown input format %s, assuming fasta.", fileParam.getMediaType()));
                format = FileFormat.Fasta;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(format.getWriter(null).print(sequences.toArray(new SequenceI[0]), false).getBytes());
            request.addFile(param.getId(), (InputStream)stream);
        }
        if (args != null) {
            for (ArgumentI arg : args) {
                String paramId = arg.getName().split("\\$", 2)[0];
                Parameter param = this.service.getParameter(paramId);
                if (param instanceof Parameter.FlagParameter) {
                    if (arg.getValue() != null && !arg.getValue().isEmpty()) {
                        request.addData(paramId, (Object)true);
                        continue;
                    }
                    request.addData(paramId, (Object)false);
                    continue;
                }
                if (param instanceof Parameter.FileParameter) {
                    request.addFile(paramId, new File(arg.getValue()));
                    continue;
                }
                request.addData(paramId, (Object)arg.getValue());
            }
        }
        String jobId = this.client.submitJob(this.service, request);
        return this.createJobHandle(jobId);
    }

    protected WebServiceJobHandle createJobHandle(String jobId) {
        return new WebServiceJobHandle(this.getClientName(), this.service.getName(), this.client.getUrl().toString(), jobId);
    }

    @Override
    public JobStatus getStatus(WebServiceJobHandle job) throws IOException {
        return statusMap.getOrDefault(this.client.fetchJobStatus(job.getJobId()), JobStatus.UNKNOWN);
    }

    @Override
    public String getLog(WebServiceJobHandle job) throws IOException {
        for (RemoteFile f : this.client.fetchFilesList(job.getJobId())) {
            if (!f.getLabel().equals("log")) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.client.writeFileTo(f, (OutputStream)stream);
            return stream.toString("UTF-8");
        }
        return "";
    }

    @Override
    public String getErrorLog(WebServiceJobHandle job) throws IOException {
        for (RemoteFile f : this.client.fetchFilesList(job.getJobId())) {
            if (!f.getLabel().equals("error-log")) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.client.writeFileTo(f, (OutputStream)stream);
            return stream.toString("UTF-8");
        }
        return "";
    }

    @Override
    public void cancel(WebServiceJobHandle job) throws IOException, UnsupportedOperationException {
        Console.warn("slivka client does not support job cancellation");
    }

    static {
        statusMap.put(Job.Status.PENDING, JobStatus.SUBMITTED);
        statusMap.put(Job.Status.REJECTED, JobStatus.INVALID);
        statusMap.put(Job.Status.ACCEPTED, JobStatus.SUBMITTED);
        statusMap.put(Job.Status.QUEUED, JobStatus.QUEUED);
        statusMap.put(Job.Status.RUNNING, JobStatus.RUNNING);
        statusMap.put(Job.Status.COMPLETED, JobStatus.COMPLETED);
        statusMap.put(Job.Status.INTERRUPTED, JobStatus.CANCELLED);
        statusMap.put(Job.Status.DELETED, JobStatus.CANCELLED);
        statusMap.put(Job.Status.FAILED, JobStatus.FAILED);
        statusMap.put(Job.Status.ERROR, JobStatus.SERVER_ERROR);
        statusMap.put(Job.Status.UNKNOWN, JobStatus.UNKNOWN);
    }
}

