/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.secstructpred;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentI;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseAction;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.secstructpred.SecStructPredMsaTask;
import jalview.ws2.actions.secstructpred.SecStructPredPDBSearchTask;
import jalview.ws2.api.Credentials;
import jalview.ws2.client.api.SecStructPredWebServiceClientI;
import java.util.List;
import java.util.Objects;

public class SecStructPredAction
extends BaseAction<AlignmentI> {
    protected final SecStructPredWebServiceClientI client;
    protected boolean msaMode;

    public static Builder newBuilder(SecStructPredWebServiceClientI client) {
        return new Builder(client);
    }

    public SecStructPredAction(Builder builder) {
        super(builder);
        this.client = builder.client;
        this.msaMode = builder.msaMode;
    }

    public BaseTask<?, AlignmentI> createTask(AlignViewportI viewport, List<ArgumentI> args, Credentials credentials) {
        if (this.msaMode) {
            return new SecStructPredMsaTask(this.client, args, credentials, viewport);
        }
        return new SecStructPredPDBSearchTask(this.client, args, credentials, viewport);
    }

    @Override
    public boolean isActive(AlignmentViewport viewport) {
        return false;
    }

    public static class Builder
    extends BaseAction.Builder<SecStructPredAction> {
        protected SecStructPredWebServiceClientI client;
        protected boolean msaMode;

        private Builder(SecStructPredWebServiceClientI client) {
            Objects.requireNonNull(client);
            this.client = client;
        }

        public void msaMode(boolean msa) {
            this.msaMode = msa;
        }

        public SecStructPredAction build() {
            return new SecStructPredAction(this);
        }
    }
}

