/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.StructureSelectionManagerProvider;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.bin.argparser.Arg;
import jalview.bin.groovy.JalviewObject;
import jalview.bin.groovy.JalviewObjectI;
import jalview.datamodel.Alignment;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.BlogReader;
import jalview.gui.Console;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.FeatureSettings;
import jalview.gui.Help;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.ImageExporter;
import jalview.gui.JalviewChangeSupport;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.PCAPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.Preferences;
import jalview.gui.QuitHandler;
import jalview.gui.SequenceFetcher;
import jalview.gui.SplashScreen;
import jalview.gui.SplitFrame;
import jalview.gui.StructureViewerBase;
import jalview.gui.TreePanel;
import jalview.gui.UserQuestionnaireCheck;
import jalview.gui.VamsasApplication;
import jalview.gui.WsParamSetManager;
import jalview.io.AppletFormatAdapter;
import jalview.io.BackupFiles;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.NewickFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.jbgui.GDesktop;
import jalview.jbgui.GSplitFrame;
import jalview.jbgui.GStructureViewer;
import jalview.project.Jalview2XML;
import jalview.structure.StructureSelectionManager;
import jalview.urls.IdOrgSettings;
import jalview.util.ArgParserUtils;
import jalview.util.BrowserLauncher;
import jalview.util.ChannelProperties;
import jalview.util.FileUtils;
import jalview.util.ImageMaker;
import jalview.util.LaunchUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.UrlConstants;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.jws1.Discoverer;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.params.ParamManager;
import jalview.ws.utils.UrlDownloadClient;
import jalview.ws2.client.ebi.JobDispatcherWSDiscoverer;
import jalview.ws2.client.jpred4.JPred4WSDiscoverer;
import jalview.ws2.client.slivka.SlivkaWSDiscoverer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.JTextComponent;
import org.stackoverflowusers.file.WindowsShortcut;

public class Desktop
extends GDesktop
implements DropTargetListener,
ClipboardOwner,
IProgressIndicator,
StructureSelectionManagerProvider,
JalviewObjectI,
ApplicationSingletonProvider.ApplicationSingletonI {
    private static final String CITATION;
    private static final String DEFAULT_AUTHORS = "The Jalview Authors (See AUTHORS file for current list)";
    private static int DEFAULT_MIN_WIDTH;
    private static int DEFAULT_MIN_HEIGHT;
    private static int ALIGN_FRAME_DEFAULT_MIN_WIDTH;
    private static int ALIGN_FRAME_DEFAULT_MIN_HEIGHT;
    private static final String EXPERIMENTAL_FEATURES = "EXPERIMENTAL_FEATURES";
    public static final String CONFIRM_KEYBOARD_QUIT = "CONFIRM_KEYBOARD_QUIT";
    public static HashMap<String, FileWriter> savingFiles;
    private static int DRAG_MODE;
    private JalviewChangeSupport changeSupport = new JalviewChangeSupport();
    public static boolean nosplash;
    private BlogReader jvnews = null;
    private File projectFile;
    private MyDesktopPane desktopPane;
    int openFrameCount = 0;
    final int xOffset = 30;
    final int yOffset = 30;
    public Discoverer discoverer;
    public Object[] jalviewClipboard;
    public boolean internalCopy = false;
    int fileLoadingCount = 0;
    public static final boolean FRAME_MAKE_VISIBLE = true;
    public static final boolean FRAME_NOT_VISIBLE = false;
    public static final boolean FRAME_ALLOW_RESIZE = true;
    public static final boolean FRAME_NOT_RESIZABLE = false;
    public static final boolean FRAME_ALLOW_ANY_SIZE = true;
    public static final boolean FRAME_SET_MIN_SIZE_300 = false;
    Console jconsole = null;
    JPanel progressPanel;
    ArrayList<JPanel> fileLoadingPanels = new ArrayList();
    int totalProgressCount = 0;
    private Hashtable<Long, JPanel> progressBars;
    private Hashtable<Long, IProgressIndicatorHandler> progressBarHandlers;
    private Hashtable<Long, String> progressBarMessages;
    private boolean inBatchMode = false;
    private Runnable serviceChangedDialog = null;
    public static WsParamSetManager wsparamManager;
    ExecutorService dialogExecutor = Executors.newFixedThreadPool(3);
    private volatile boolean dialogPause = true;
    private Semaphore block = new Semaphore(0);
    private static groovy.console.ui.Console groovyConsole;
    private boolean dialogQueueStarted = false;
    public static final String debugScaleMessage = "Desktop graphics transform scale=";
    private static boolean debugScaleMessageDone;
    private static Map<AlignFrame, JInternalFrame> alignFrameModalMap;

    public static void setLiveDragMode(boolean b) {
        int n = DRAG_MODE = b ? 0 : 1;
        if (Desktop.getInstance().desktopPane != null) {
            Desktop.getInstance().desktopPane.setDragMode(DRAG_MODE);
        }
    }

    @Deprecated
    public void addJalviewPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addJalviewPropertyChangeListener(listener);
    }

    @Deprecated
    public void addJalviewPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addJalviewPropertyChangeListener(propertyName, listener);
    }

    @Deprecated
    public void removeJalviewPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removeJalviewPropertyChangeListener(propertyName, listener);
    }

    public static MyDesktopPane getDesktopPane() {
        Desktop desktop = Desktop.getInstance();
        return desktop == null ? null : desktop.desktopPane;
    }

    public static Desktop getInstance() {
        Jalview.getInstance();
        return Jalview.isHeadlessMode() ? null : ApplicationSingletonProvider.getInstance(Desktop.class);
    }

    public static StructureSelectionManager getStructureSelectionManager() {
        return StructureSelectionManager.getStructureSelectionManager(Desktop.getInstance());
    }

    private Desktop() {
        try {
            this.doConfigureStructurePrefs();
            this.setTitle(ChannelProperties.getProperty("app_name") + " " + Cache.getProperty("VERSION"));
            if (Platform.isLinux()) {
                if (LaunchUtils.getJavaVersion() >= 11) {
                    jalview.bin.Console.errPrintln("Linux platform only! You may have the following warning next: \"WARNING: An illegal reflective access operation has occurred\"\nThis is expected and cannot be avoided, sorry about that.");
                }
                String awtAppClassName = "awtAppClassName";
                try {
                    Toolkit xToolkit = Toolkit.getDefaultToolkit();
                    Field[] declaredFields = xToolkit.getClass().getDeclaredFields();
                    Field awtAppClassNameField = null;
                    if (Arrays.stream(declaredFields).anyMatch(f -> f.getName().equals("awtAppClassName"))) {
                        awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                    }
                    String title = ChannelProperties.getProperty("app_name");
                    if (awtAppClassNameField != null) {
                        awtAppClassNameField.setAccessible(true);
                        awtAppClassNameField.set(xToolkit, title);
                    } else {
                        jalview.bin.Console.debug("XToolkit: awtAppClassName not found");
                    }
                }
                catch (Exception e) {
                    jalview.bin.Console.debug("Error setting awtAppClassName");
                    jalview.bin.Console.trace(Cache.getStackTraceString(e));
                }
            }
            this.setIconImages(ChannelProperties.getIconList());
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    QuitHandler.QResponse ret = Desktop.this.desktopQuit(true, true);
                }
            });
            boolean selmemusage = Cache.getDefault("SHOW_MEMUSAGE", false);
            boolean showjconsole = Cache.getArgCacheDefault(Arg.JAVACONSOLE, "SHOW_JAVA_CONSOLE", false);
            this.startDialogQueue();
            if (!Platform.isJS()) {
                this.acquireDialogQueue();
                this.jconsole = new Console(this);
                this.jconsole.setHeader(Cache.getVersionDetailsForConsole());
                this.showConsole(showjconsole);
                this.releaseDialogQueue();
            }
            this.desktopPane = new MyDesktopPane(selmemusage);
            this.showMemusage.setSelected(selmemusage);
            this.desktopPane.setBackground(Color.white);
            this.getContentPane().setLayout(new BorderLayout());
            if (Platform.isJS()) {
                this.getRootPane().putClientProperty("swingjs.overflow.hidden", "false");
            }
            this.getContentPane().add((Component)this.desktopPane, "Center");
            this.desktopPane.setDragMode(DRAG_MODE);
            this.desktopPane.setDesktopManager(new MyDesktopManager(Platform.isJS() ? this.desktopPane.getDesktopManager() : new DefaultDesktopManager()));
            Rectangle dims = this.getLastKnownDimensions("");
            if (dims != null) {
                this.setBounds(dims);
            } else {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int xPos = Math.max(5, (screenSize.width - 900) / 2);
                int yPos = Math.max(5, (screenSize.height - 650) / 2);
                this.setBounds(xPos, yPos, 900, 650);
            }
            if (!Platform.isJS()) {
                this.showNews.setVisible(false);
                this.experimentalFeatures.setSelected(this.showExperimental());
                this.getIdentifiersOrgData();
                if (Jalview.isInteractive()) {
                    this.checkURLLinks();
                    if (!nosplash) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                new SplashScreen(true);
                            }
                        });
                    }
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        jalview.bin.Console.debug("Filechooser init thread started.");
                        String fileFormat = FileLoader.getUseDefaultFileFormat() ? Cache.getProperty("DEFAULT_FILE_FORMAT") : null;
                        JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), fileFormat);
                        jalview.bin.Console.debug("Filechooser init thread finished.");
                    }
                }).start();
                this.changeSupport.addJalviewPropertyChangeListener("services", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        jalview.bin.Console.debug("Firing service changed event for " + evt.getNewValue());
                        Desktop.this.JalviewServicesChanged(evt);
                    }
                });
                this.setDropTarget(new DropTarget(this.desktopPane, this));
                MouseAdapter ma = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        if (evt.isPopupTrigger()) {
                            Desktop.this.showPasteMenu(evt.getX(), evt.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        if (evt.isPopupTrigger()) {
                            Desktop.this.showPasteMenu(evt.getX(), evt.getY());
                        }
                    }
                };
                this.addMouseListener(ma);
                this.desktopPane.addMouseListener(ma);
            }
            jalview.bin.Console.info((Platform.isJS() ? "JALVIEWJS" : "JALVIEW") + ": CREATED DESKTOP");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean showExperimental() {
        String experimental = Cache.getDefault(EXPERIMENTAL_FEATURES, Boolean.FALSE.toString());
        return Boolean.valueOf(experimental);
    }

    public void doConfigureStructurePrefs() {
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(this);
        StructureSelectionManager.doConfigureStructurePrefs(ssm);
    }

    public void checkForNews() {
        final Desktop me = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                jalview.bin.Console.debug("Starting news thread.");
                Desktop.this.jvnews = new BlogReader(me);
                Desktop.this.showNews.setVisible(true);
                jalview.bin.Console.debug("Completed news thread.");
            }
        }).start();
    }

    public void getIdentifiersOrgData() {
        if (Cache.getProperty("NOIDENTIFIERSSERVICE") == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    jalview.bin.Console.debug("Downloading data from identifiers.org");
                    try {
                        UrlDownloadClient.download(IdOrgSettings.getUrl(), IdOrgSettings.getDownloadLocation());
                    }
                    catch (IOException e) {
                        jalview.bin.Console.debug("Exception downloading identifiers.org data" + e.getMessage());
                    }
                }
            }).start();
        }
    }

    @Override
    protected void showNews_actionPerformed(ActionEvent e) {
        this.showNews(this.showNews.isSelected());
    }

    void showNews(boolean visible) {
        jalview.bin.Console.debug((visible ? "Showing" : "Hiding") + " news.");
        this.showNews.setSelected(visible);
        if (visible && !this.jvnews.isVisible()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    Desktop.this.setProgressBar(MessageManager.getString("status.refreshing_news"), now);
                    Desktop.this.jvnews.refreshNews();
                    Desktop.this.setProgressBar(null, now);
                    Desktop.this.jvnews.showNews();
                }
            }).start();
        }
    }

    Rectangle getLastKnownDimensions(String windowName) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String x = Cache.getProperty(windowName + "SCREEN_X");
        String y = Cache.getProperty(windowName + "SCREEN_Y");
        String width = Cache.getProperty(windowName + "SCREEN_WIDTH");
        String height = Cache.getProperty(windowName + "SCREEN_HEIGHT");
        if (x != null && y != null && width != null && height != null) {
            int ix = Integer.parseInt(x);
            int iy = Integer.parseInt(y);
            int iw = Integer.parseInt(width);
            int ih = Integer.parseInt(height);
            if (Cache.getProperty("SCREENGEOMETRY_WIDTH") != null) {
                double sw = 1.0f * (float)screenSize.width / (1.0f * (float)Integer.parseInt(Cache.getProperty("SCREENGEOMETRY_WIDTH")));
                double sh = 1.0f * (float)screenSize.height / (1.0f * (float)Integer.parseInt(Cache.getProperty("SCREENGEOMETRY_HEIGHT")));
                ix = (int)((double)ix * sw);
                iw = (int)((double)iw * sw);
                iy = (int)((double)iy * sh);
                ih = (int)((double)ih * sh);
                if (ix >= screenSize.width) {
                    jalview.bin.Console.debug("Window geometry location recall error: shifting horizontal to within screenbounds.");
                    ix %= screenSize.width;
                }
                if (iy >= screenSize.height) {
                    jalview.bin.Console.debug("Window geometry location recall error: shifting vertical to within screenbounds.");
                    iy %= screenSize.height;
                }
                jalview.bin.Console.debug("Got last known dimensions for " + windowName + ": x:" + ix + " y:" + iy + " width:" + iw + " height:" + ih);
            }
            return new Rectangle(ix, iy, iw, ih);
        }
        return null;
    }

    void showPasteMenu(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(MessageManager.getString("label.paste_new_window"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop.this.paste();
            }
        });
        popup.add(item);
        popup.show(this, x, y);
    }

    public void paste() {
        if (this.jalviewClipboard != null) {
            SequenceI[] newseq = (SequenceI[])this.jalviewClipboard[0];
            SequenceI[] sequences = new SequenceI[newseq.length];
            for (int i = 0; i < newseq.length; ++i) {
                sequences[i] = new Sequence(newseq[i]);
            }
            Alignment alignment = new Alignment(sequences);
            alignment.setDataset((Alignment)this.jalviewClipboard[1]);
            AlignFrame af = new AlignFrame(alignment, 700, 500);
            String newtitle = new String("Copied sequences");
            if (this.jalviewClipboard[2] != null) {
                HiddenColumns hc = (HiddenColumns)this.jalviewClipboard[2];
                af.viewport.setHiddenColumns(hc);
            }
            Desktop.addInternalFrame(af, newtitle, 700, 500);
        } else {
            try {
                Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = c.getContents(this);
                if (contents != null) {
                    String file = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    FileFormatI format = new IdentifyFile().identify(file, DataSourceType.PASTE);
                    new FileLoader().LoadFile(file, DataSourceType.PASTE, format);
                }
            }
            catch (Exception ex) {
                jalview.bin.Console.outPrintln("Unable to paste alignment from system clipboard:\n" + ex);
            }
        }
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, int w, int h) {
        Desktop.addInternalFrame(frame, title, true, w, h, true, false);
    }

    public static synchronized void addInternalFrame(JInternalFrame frame, String title, boolean makeVisible, int w, int h, boolean resizable, boolean ignoreMinSize) {
        frame.setTitle(title);
        if (frame.getWidth() < 1 || frame.getHeight() < 1) {
            frame.setSize(w, h);
        }
        if (Desktop.getInstance() != null && !Jalview.isHeadlessMode()) {
            Desktop.getInstance().addFrame(frame, makeVisible, resizable, ignoreMinSize);
        }
    }

    private void addFrame(final JInternalFrame frame, boolean makeVisible, boolean resizable, boolean ignoreMinSize) {
        boolean hasEmbeddedSize;
        ++this.openFrameCount;
        boolean isEmbedded = Platform.getEmbeddedAttribute(frame, "id") != null;
        boolean bl = hasEmbeddedSize = Platform.getDimIfEmbedded(frame, -1, -1) != null;
        if (!(ignoreMinSize |= hasEmbeddedSize)) {
            if (frame instanceof AlignFrame) {
                frame.setMinimumSize(new Dimension(ALIGN_FRAME_DEFAULT_MIN_WIDTH, ALIGN_FRAME_DEFAULT_MIN_HEIGHT));
            } else {
                frame.setMinimumSize(new Dimension(DEFAULT_MIN_WIDTH, DEFAULT_MIN_HEIGHT));
            }
        }
        frame.setVisible(makeVisible);
        frame.setClosable(true);
        frame.setResizable(resizable);
        frame.setMaximizable(resizable);
        frame.setIconifiable(resizable);
        frame.setOpaque(Platform.isJS());
        if (!isEmbedded && frame.getX() < 1 && frame.getY() < 1) {
            frame.setLocation(30 * this.openFrameCount, 30 * ((this.openFrameCount - 1) % 10) + 30);
        }
        final JMenuItem menuItem = new JMenuItem(frame.getTitle());
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                JInternalFrame itf = Desktop.getDesktopPane().getSelectedFrame();
                if (itf != null) {
                    if (itf instanceof AlignFrame) {
                        Jalview.getInstance().setCurrentAlignFrame((AlignFrame)itf);
                    }
                    itf.requestFocus();
                }
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                PaintRefresher.RemoveComponent(frame);
                if (Desktop.this.openFrameCount > 0) {
                    --Desktop.this.openFrameCount;
                }
                if (menuItem.getActionListeners().length > 0) {
                    menuItem.removeActionListener(menuItem.getActionListeners()[0]);
                }
                Desktop.getInstance().windowMenu.remove(menuItem);
            }
        });
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    frame.setSelected(true);
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
        Desktop.setKeyBindings(frame);
        int tries = 3;
        boolean shown = false;
        IllegalArgumentException last = null;
        do {
            try {
                Desktop.getDesktopPane().add(frame);
                shown = true;
            }
            catch (IllegalArgumentException iaex) {
                last = iaex;
                jalview.bin.Console.info("Squashed IllegalArgument Exception (" + --tries + " left) for " + frame.getTitle(), iaex);
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (!shown && tries > 0);
        if (!shown) {
            jalview.bin.Console.error("Serious Problem whilst showing window " + frame.getTitle(), last);
        }
        Desktop.getInstance().windowMenu.add(menuItem);
        frame.toFront();
        try {
            frame.setSelected(true);
            frame.requestFocus();
        }
        catch (PropertyVetoException iaex) {
        }
        catch (ClassCastException cex) {
            jalview.bin.Console.warn("Squashed a possible GUI implementation error. If you can recreate this, please look at https://issues.jalview.org/browse/JAL-869", cex);
        }
    }

    private static void setKeyBindings(final JInternalFrame frame) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        };
        KeyStroke ctrlWKey = KeyStroke.getKeyStroke(87, 128);
        KeyStroke cmdWKey = KeyStroke.getKeyStroke(87, Platform.SHORTCUT_KEY_MASK);
        InputMap inputMap = frame.getInputMap(2);
        String ctrlW = ctrlWKey.toString();
        inputMap.put(ctrlWKey, ctrlW);
        inputMap.put(cmdWKey, ctrlW);
        ActionMap actionMap = frame.getActionMap();
        actionMap.put(ctrlW, closeAction);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (!this.internalCopy) {
            this.jalviewClipboard = null;
        }
        this.internalCopy = false;
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    public boolean loadDroppedFiles(List<Object> files, List<DataSourceType> protocols, List<Object> failed, List<Exception> failed_exceptions) {
        for (int i = 0; i < files.size(); ++i) {
            Object file = files.get(i);
            try {
                String fileName = file.toString();
                DataSourceType protocol = protocols == null ? DataSourceType.FILE : protocols.get(i);
                FileFormatI format = null;
                format = fileName.endsWith(".jar") ? FileFormat.Jalview : new IdentifyFile().identify(file, protocol);
                if (file instanceof File) {
                    Platform.cacheFileData((File)file);
                }
                new FileLoader().LoadFile(null, file, protocol, format);
                continue;
            }
            catch (Exception x) {
                failed.add(file);
                failed_exceptions.add(x);
                jalview.bin.Console.warn("Unexpected Exception when handling " + file.toString(), x);
            }
        }
        return failed.size() == 0;
    }

    public boolean processAndLoadDroppedFiles(List<Object> files, List<DataSourceType> protocols, List<Object> failed, List<Exception> failed_exceptions) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            filenames.add(files.get(i).toString());
        }
        Map<String, ArgParserUtils.BaseInfo> baseInfoMap = ArgParserUtils.processFilenames(filenames, false, files);
        Object file = null;
        try {
            for (int i = 0; i < files.size(); ++i) {
                file = files.get(i);
                String fileName = file.toString();
                DataSourceType protocol = protocols == null ? DataSourceType.FILE : protocols.get(i);
                FileFormatI format = null;
                format = fileName.toLowerCase(Locale.ROOT).endsWith(".jar") ? FileFormat.Jalview : new IdentifyFile().identify(file, protocol);
                String ext = FileUtils.getExtension(fileName);
                boolean isFeatures = ArgParserUtils.featuresExtensions.contains(ext);
                boolean isAnnotations = ArgParserUtils.annotationsExtensions.contains(ext);
                boolean isTree = ArgParserUtils.treeExtensions.contains(ext);
                if (isFeatures || isAnnotations || isTree) {
                    String base = FileUtils.getBase(fileName);
                    AlignFrame matchingAf = null;
                    AlignFrame[] afs = this.getAlignFrames();
                    boolean dontSkip = false;
                    for (AlignFrame af : afs) {
                        String afFilename = af.fileName;
                        String afTitle = af.getTitle();
                        if (!base.equals(FileUtils.getBase(afFilename)) && !base.equals(FileUtils.getBase(afTitle))) continue;
                        matchingAf = af;
                        break;
                    }
                    if (matchingAf != null) {
                        if (isFeatures) {
                            matchingAf.parseFeaturesFile(fileName, AppletFormatAdapter.checkProtocol(fileName));
                        } else if (isAnnotations) {
                            matchingAf.loadJalviewDataFile(fileName, null, null, null);
                        } else if (isTree) {
                            try {
                                NewickFile nf = new NewickFile(fileName, AppletFormatAdapter.checkProtocol(fileName));
                                matchingAf.getViewport().setCurrentTree(matchingAf.showNewickTree(nf, fileName).getTree());
                            }
                            catch (IOException e) {
                                jalview.bin.Console.warn("Couldn't add potential tree '" + fileName + "'");
                                dontSkip = true;
                            }
                        }
                        if (!dontSkip) continue;
                    }
                }
                if (file instanceof File) {
                    Platform.cacheFileData((File)file);
                }
                AlignFrame af = new FileLoader().LoadFileWaitTillLoaded(fileName, protocol, format);
                if (!baseInfoMap.containsKey(fileName) || baseInfoMap.get(fileName).getAssociatedFilesMap() == null) continue;
                ArgParserUtils.BaseInfo bi = baseInfoMap.get(fileName);
                if (bi.getAssociatedFilesMap().containsKey((Object)Arg.FEATURES)) {
                    String featuresfile = bi.getAssociatedFilesMap().get((Object)Arg.FEATURES);
                    af.parseFeaturesFile(featuresfile, AppletFormatAdapter.checkProtocol(featuresfile));
                }
                if (bi.getAssociatedFilesMap().containsKey((Object)Arg.ANNOTATIONS)) {
                    String annotationsfile = bi.getAssociatedFilesMap().get((Object)Arg.ANNOTATIONS);
                    af.loadJalviewDataFile(annotationsfile, null, null, null);
                }
                if (!bi.getAssociatedFilesMap().containsKey((Object)Arg.TREE)) continue;
                String treefile = bi.getAssociatedFilesMap().get((Object)Arg.TREE);
                try {
                    NewickFile nf = new NewickFile(treefile, AppletFormatAdapter.checkProtocol(treefile));
                    af.getViewport().setCurrentTree(af.showNewickTree(nf, treefile).getTree());
                    continue;
                }
                catch (IOException e) {
                    jalview.bin.Console.warn("Couldn't add potential tree '" + treefile + "'");
                }
            }
        }
        catch (Exception ex) {
            jalview.bin.Console.warn("Unexpected exception whilst handling drop to Desktop.", ex);
            failed.add(file);
            failed_exceptions.add(ex);
            return false;
        }
        return failed.size() == 0;
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        boolean success = true;
        evt.acceptDrop(3);
        Transferable t = evt.getTransferable();
        ArrayList<Object> files = new ArrayList<Object>();
        ArrayList<DataSourceType> protocols = new ArrayList<DataSourceType>();
        try {
            Desktop.transferFromDropTarget(files, protocols, evt, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        try {
            if (files != null) {
                ArrayList<Object> failed = new ArrayList<Object>();
                ArrayList<Exception> failed_exceptions = new ArrayList<Exception>();
                success = !this.showExperimental() ? this.loadDroppedFiles(files, protocols, failed, failed_exceptions) : this.processAndLoadDroppedFiles(files, protocols, failed, failed_exceptions);
            }
        }
        catch (Throwable ex) {
            jalview.bin.Console.warn("Unexpected exception whilst handling drop to Desktop.", ex);
            success = false;
        }
        evt.dropComplete(success);
    }

    @Override
    public void inputLocalFileMenuItem_actionPerformed(AlignViewport viewport) {
        JalviewFileChooser chooser = JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), null, BackupFiles.getEnabled());
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.open_local_file"));
        chooser.setToolTipText(MessageManager.getString("action.open"));
        chooser.setResponseHandler(0, () -> {
            File selectedFile = chooser.getSelectedFile();
            Cache.setProperty("LAST_DIRECTORY", selectedFile.getParent());
            FileFormatI format = chooser.getSelectedFormat();
            if (FileFormats.getInstance().isIdentifiable(format)) {
                try {
                    format = new IdentifyFile().identify(selectedFile, DataSourceType.FILE);
                }
                catch (FileFormatException fileFormatException) {
                    // empty catch block
                }
            }
            new FileLoader().LoadFile(viewport, selectedFile, DataSourceType.FILE, format);
        });
        chooser.showOpenDialog(this);
    }

    @Override
    public void inputURLMenuItem_actionPerformed(AlignViewport viewport) {
        JComponent history;
        JLabel label = new JLabel(MessageManager.getString("label.input_file_url"));
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.add(label);
        String urlBase = "https://www.";
        if (Platform.isJS()) {
            history = new JTextField(urlBase, 35);
        } else {
            JComboBox<String> asCombo = new JComboBox<String>();
            asCombo.setPreferredSize(new Dimension(400, 20));
            asCombo.setEditable(true);
            asCombo.addItem(urlBase);
            String historyItems = Cache.getProperty("RECENT_URL");
            if (historyItems != null) {
                for (String token : historyItems.split("\\t")) {
                    asCombo.addItem(token);
                }
            }
            history = asCombo;
        }
        panel.add(history);
        Object[] options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        Runnable action = () -> {
            String url;
            String string = url = history instanceof JTextField ? ((JTextField)history).getText() : ((JComboBox)history).getEditor().getItem().toString().trim();
            if (url.toLowerCase(Locale.ROOT).endsWith(".jar")) {
                if (viewport != null) {
                    new FileLoader().LoadFile(viewport, url, DataSourceType.URL, FileFormat.Jalview);
                } else {
                    new FileLoader().LoadFile(url, DataSourceType.URL, FileFormat.Jalview);
                }
            } else {
                FileFormatI format = null;
                try {
                    format = new IdentifyFile().identify(url, DataSourceType.URL);
                }
                catch (FileNotFoundException e) {
                    jalview.bin.Console.error("URL '" + url + "' not found", e);
                }
                catch (FileFormatException e) {
                    jalview.bin.Console.error("File at URL '" + url + "' format not recognised", e);
                }
                if (format == null) {
                    String msg = MessageManager.formatMessage("label.couldnt_locate", url);
                    JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), msg, MessageManager.getString("label.url_not_found"), 2);
                    return;
                }
                if (viewport != null) {
                    new FileLoader().LoadFile(viewport, url, DataSourceType.URL, format);
                } else {
                    new FileLoader().LoadFile(url, DataSourceType.URL, format);
                }
            }
        };
        String dialogOption = MessageManager.getString("label.input_alignment_from_url");
        JvOptionPane.newOptionDialog(this.desktopPane).setResponseHandler(0, action).showInternalDialog(panel, dialogOption, 1, -1, null, options, MessageManager.getString("action.ok"));
    }

    @Override
    public void inputTextboxMenuItem_actionPerformed(AlignmentViewPanel viewPanel) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        cap.setForInput(viewPanel);
        Desktop.addInternalFrame(cap, MessageManager.getString("label.cut_paste_alignmen_file"), true, 600, 500, true, false);
    }

    public void desktopQuit() {
        this.desktopQuit(true, false);
    }

    public void quitTheDesktop(boolean dispose, boolean terminateJvm) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Cache.setProperty("SCREENGEOMETRY_WIDTH", "" + screen.width);
        Cache.setProperty("SCREENGEOMETRY_HEIGHT", "" + screen.height);
        this.storeLastKnownDimensions("", new Rectangle(this.getBounds().x, this.getBounds().y, this.getWidth(), this.getHeight()));
        if (this.jconsole != null) {
            this.storeLastKnownDimensions("JAVA_CONSOLE_", this.jconsole.getBounds());
            this.jconsole.stopConsole();
        }
        if (this.jvnews != null) {
            this.storeLastKnownDimensions("JALVIEW_RSS_WINDOW_", this.jvnews.getBounds());
        }
        this.closeAll_actionPerformed(null);
        if (this.dialogExecutor != null) {
            this.dialogExecutor.shutdownNow();
        }
        if (groovyConsole != null) {
            groovyConsole.setDirty(false);
            if ((Window)((Object)groovyConsole.getFrame()) != null && ((Window)((Object)groovyConsole.getFrame())).isVisible()) {
                groovyConsole.exit();
            } else {
                groovyConsole = null;
            }
        }
        if (terminateJvm) {
            jalview.bin.Console.debug("Force Quit selected by user");
            Runtime.getRuntime().halt(0);
        }
        jalview.bin.Console.debug("Quit selected by user");
        if (dispose) {
            Desktop.getInstance().setDefaultCloseOperation(2);
        }
    }

    public QuitHandler.QResponse desktopQuit(boolean ui, boolean disposeFlag) {
        Runnable doDesktopQuit = () -> {
            if (QuitHandler.quitCancelled()) {
                jalview.bin.Console.debug("Quit was cancelled - Desktop aborting quit");
                return;
            }
            this.quitTheDesktop(disposeFlag, QuitHandler.gotQuitResponse() == QuitHandler.QResponse.FORCE_QUIT);
            Desktop.getInstance().quit();
        };
        return QuitHandler.getQuitResponse(ui, doDesktopQuit, doDesktopQuit, QuitHandler.defaultCancelQuit);
    }

    @Override
    public void quit() {
        Jalview.exit("Desktop exiting.", Jalview.ExitCode.OK);
    }

    private void storeLastKnownDimensions(String string, Rectangle jc) {
        jalview.bin.Console.debug("Storing last known dimensions for " + string + ": x:" + jc.x + " y:" + jc.y + " width:" + jc.width + " height:" + jc.height);
        Cache.setProperty(string + "SCREEN_X", "" + jc.x);
        Cache.setProperty(string + "SCREEN_Y", "" + jc.y);
        Cache.setProperty(string + "SCREEN_WIDTH", "" + jc.width);
        Cache.setProperty(string + "SCREEN_HEIGHT", "" + jc.height);
    }

    @Override
    public void aboutMenuItem_actionPerformed(ActionEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                new SplashScreen(false);
            }
        }).start();
    }

    public String getAboutMessage() {
        StringBuilder message = new StringBuilder(1024);
        message.append("<div style=\"font-family: sans-serif;\">").append("<h1><strong>Version: ").append(Cache.getProperty("VERSION")).append("</strong></h1>").append("<strong>Built: <em>").append(Cache.getDefault("BUILD_DATE", "unknown")).append("</em> from ").append(Cache.getBuildDetailsForSplash()).append("</strong>");
        String latestVersion = Cache.getDefault("LATEST_VERSION", "Checking");
        if (!latestVersion.equals("Checking") && !latestVersion.equals(Cache.getProperty("VERSION"))) {
            boolean red = false;
            if (Cache.getProperty("VERSION").toLowerCase(Locale.ROOT).indexOf("automated build") == -1) {
                red = true;
                message.append("<div style=\"color: #FF0000;font-style: bold;\">");
            }
            message.append("<br>!! Version ").append(Cache.getDefault("LATEST_VERSION", "..Checking..")).append(" is available for download from ").append(Cache.getDefault("www.jalview.org", "https://www.jalview.org")).append(" !!");
            if (red) {
                message.append("</div>");
            }
        }
        message.append("<br>Authors:  ");
        message.append(Cache.getDefault("AUTHORFNAMES", DEFAULT_AUTHORS));
        message.append(CITATION);
        message.append("</div>");
        return message.toString();
    }

    @Override
    public void documentationMenuItem_actionPerformed() {
        try {
            if (Platform.isJS()) {
                BrowserLauncher.openURL("https://www.jalview.org/help.html");
            } else {
                Help.showHelpWindow();
            }
        }
        catch (Exception ex) {
            jalview.bin.Console.errPrintln("Error opening help: " + ex.getMessage());
        }
    }

    @Override
    public void closeAll_actionPerformed(ActionEvent e) {
        if (this.desktopPane == null) {
            jalview.bin.Console.trace("Ignoring call to closeAll when no desktopPane present.");
        } else {
            JInternalFrame[] frames = this.desktopPane.getAllFrames();
            for (int i = 0; i < frames.length; ++i) {
                try {
                    frames[i].setClosed(true);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            Jalview.getInstance().setCurrentAlignFrame(null);
            jalview.bin.Console.info("ALL CLOSED");
        }
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(this);
        if (ssm != null) {
            ssm.resetAll();
        }
    }

    public int structureViewersStillRunningCount() {
        int count = 0;
        JInternalFrame[] frames = Desktop.getInstance().getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i] == null || !(frames[i] instanceof JalviewStructureDisplayI) || !((JalviewStructureDisplayI)((Object)frames[i])).stillRunning()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void raiseRelated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(false, false);
    }

    @Override
    public void minimizeAssociated_actionPerformed(ActionEvent e) {
        this.reorderAssociatedWindows(true, false);
    }

    void closeAssociatedWindows() {
        this.reorderAssociatedWindows(false, true);
    }

    @Override
    protected void garbageCollect_actionPerformed(ActionEvent e) {
        jalview.bin.Console.debug("Collecting garbage...");
        System.gc();
        jalview.bin.Console.debug("Finished garbage collection.");
    }

    @Override
    protected void showMemusage_actionPerformed(ActionEvent e) {
        this.desktopPane.showMemoryUsage(this.showMemusage.isSelected());
    }

    @Override
    protected void showConsole_actionPerformed(ActionEvent e) {
        this.showConsole(this.showConsole.isSelected());
    }

    void showConsole(boolean selected) {
        if (this.jconsole != null) {
            this.showConsole.setSelected(selected);
            Cache.setProperty("SHOW_JAVA_CONSOLE", Boolean.valueOf(selected).toString());
            this.jconsole.setVisible(selected);
        }
    }

    void reorderAssociatedWindows(boolean minimize, boolean close) {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        if (frames == null || frames.length < 1) {
            return;
        }
        AlignViewportI source = null;
        AlignViewportI target = null;
        if (frames[0] instanceof AlignFrame) {
            source = ((AlignFrame)frames[0]).getCurrentView();
        } else if (frames[0] instanceof TreePanel) {
            source = ((TreePanel)frames[0]).getViewPort();
        } else if (frames[0] instanceof PCAPanel) {
            source = ((PCAPanel)frames[0]).av;
        } else if (frames[0].getContentPane() instanceof PairwiseAlignPanel) {
            source = ((PairwiseAlignPanel)frames[0].getContentPane()).av;
        }
        if (source != null) {
            for (int i = 0; i < frames.length; ++i) {
                target = null;
                if (frames[i] == null) continue;
                if (frames[i] instanceof AlignFrame) {
                    target = ((AlignFrame)frames[i]).getCurrentView();
                } else if (frames[i] instanceof TreePanel) {
                    target = ((TreePanel)frames[i]).getViewPort();
                } else if (frames[i] instanceof PCAPanel) {
                    target = ((PCAPanel)frames[i]).av;
                } else if (frames[i].getContentPane() instanceof PairwiseAlignPanel) {
                    target = ((PairwiseAlignPanel)frames[i].getContentPane()).av;
                }
                if (source != target) continue;
                try {
                    if (close) {
                        frames[i].setClosed(true);
                        continue;
                    }
                    frames[i].setIcon(minimize);
                    if (minimize) continue;
                    frames[i].toFront();
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected void preferences_actionPerformed(ActionEvent e) {
        Preferences.openPreferences();
    }

    @Override
    public void saveState_actionPerformed() {
        this.saveState_actionPerformed(false);
    }

    public void saveState_actionPerformed(boolean saveAs) {
        File projectFile = this.getProjectFile();
        boolean autoSave = projectFile != null && !saveAs && BackupFiles.getEnabled();
        boolean approveSave = false;
        if (!autoSave) {
            JalviewFileChooser chooser = new JalviewFileChooser("jvp", "Jalview Project");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(MessageManager.getString("label.save_state"));
            int value = chooser.showSaveDialog(this);
            if (value == 0) {
                projectFile = chooser.getSelectedFile();
                this.setProjectFile(projectFile);
                approveSave = true;
            }
        }
        if (approveSave || autoSave) {
            final Desktop me = this;
            final File chosenFile = projectFile;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.setProgressBar(MessageManager.formatMessage("label.saving_jalview_project", chosenFile.getName()), chosenFile.hashCode());
                    Cache.setProperty("LAST_DIRECTORY", chosenFile.getParent());
                    try {
                        boolean doBackup = BackupFiles.getEnabled();
                        BackupFiles backupfiles = doBackup ? new BackupFiles(chosenFile) : null;
                        new Jalview2XML().saveState(doBackup ? backupfiles.getTempFile() : chosenFile);
                        if (doBackup) {
                            backupfiles.setWriteSuccess(true);
                            backupfiles.rollBackupsAndRenameTempFile();
                        }
                    }
                    catch (OutOfMemoryError oom) {
                        new OOMWarning("Whilst saving current state to " + chosenFile.getName(), oom);
                    }
                    catch (Exception ex) {
                        jalview.bin.Console.error("Problems whilst trying to save to " + chosenFile.getName(), ex);
                        JvOptionPane.showMessageDialog((Component)me, MessageManager.formatMessage("label.error_whilst_saving_current_state_to", chosenFile.getName()), MessageManager.getString("label.couldnt_save_project"), 2);
                    }
                    Desktop.this.setProgressBar(null, chosenFile.hashCode());
                }
            }).start();
        }
    }

    @Override
    public void saveAsState_actionPerformed(ActionEvent e) {
        this.saveState_actionPerformed(true);
    }

    protected void setProjectFile(File choice) {
        this.projectFile = choice;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    @Override
    public void loadState_actionPerformed() {
        String[] suffix = new String[]{"jvp", "jar"};
        String[] desc = new String[]{"Jalview Project", "Jalview Project (old)"};
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"), suffix, desc, "Jalview Project", true, BackupFiles.getEnabled());
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.restore_state"));
        chooser.setResponseHandler(0, () -> {
            final File selectedFile = chooser.getSelectedFile();
            this.setProjectFile(selectedFile);
            final String choice = selectedFile.getAbsolutePath();
            Cache.setProperty("LAST_DIRECTORY", selectedFile.getParent());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        new Jalview2XML().loadJalviewAlign(selectedFile);
                    }
                    catch (OutOfMemoryError oom) {
                        new OOMWarning("Whilst loading project from " + choice, oom);
                    }
                    catch (Exception ex) {
                        jalview.bin.Console.error("Problems whilst loading project from " + choice, ex);
                        JvOptionPane.showMessageDialog((Component)Desktop.getDesktopPane(), MessageManager.formatMessage("label.error_whilst_loading_project_from", choice), MessageManager.getString("label.couldnt_load_project"), 2);
                    }
                }
            }, "Project Loader").start();
        });
        chooser.showOpenDialog(this);
    }

    @Override
    public void inputSequence_actionPerformed(ActionEvent e) {
        new SequenceFetcher(this);
    }

    public void startLoading(Object fileName) {
        if (this.fileLoadingCount == 0) {
            this.fileLoadingPanels.add(this.addProgressPanel(MessageManager.formatMessage("label.loading_file", fileName)));
        }
        ++this.fileLoadingCount;
    }

    private JPanel addProgressPanel(String string) {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel(new GridLayout(1, 1));
            this.totalProgressCount = 0;
            this.getContentPane().add((Component)this.progressPanel, "South");
        }
        JPanel thisprogress = new JPanel(new BorderLayout(10, 5));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        thisprogress.add((Component)new JLabel(string), "West");
        thisprogress.add((Component)progressBar, "Center");
        this.progressPanel.add(thisprogress);
        ((GridLayout)this.progressPanel.getLayout()).setRows(((GridLayout)this.progressPanel.getLayout()).getRows() + 1);
        ++this.totalProgressCount;
        this.validate();
        return thisprogress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgressPanel(JPanel progbar) {
        if (this.progressPanel != null) {
            JPanel jPanel = this.progressPanel;
            synchronized (jPanel) {
                this.progressPanel.remove(progbar);
                GridLayout gl = (GridLayout)this.progressPanel.getLayout();
                gl.setRows(gl.getRows() - 1);
                if (--this.totalProgressCount < 1) {
                    this.getContentPane().remove(this.progressPanel);
                    this.progressPanel = null;
                }
            }
        }
        this.validate();
    }

    public void stopLoading() {
        --this.fileLoadingCount;
        if (this.fileLoadingCount < 1) {
            while (this.fileLoadingPanels.size() > 0) {
                this.removeProgressPanel(this.fileLoadingPanels.remove(0));
            }
            this.fileLoadingPanels.clear();
            this.fileLoadingCount = 0;
        }
        this.validate();
    }

    public static int getViewCount(String alignmentId) {
        AlignmentViewport[] aps = Desktop.getViewports(alignmentId);
        return aps == null ? 0 : aps.length;
    }

    public static AlignmentViewPanel[] getAlignmentPanels(String alignmentId) {
        if (Desktop.getDesktopPane() == null) {
            return null;
        }
        ArrayList<AlignmentViewPanel> aps = new ArrayList<AlignmentViewPanel>();
        AlignFrame[] frames = Desktop.getDesktopAlignFrames();
        if (frames == null) {
            return null;
        }
        for (AlignFrame af : frames) {
            for (AlignmentViewPanel alignmentViewPanel : af.getAlignPanels()) {
                if (alignmentId != null && !alignmentId.equals(alignmentViewPanel.getAlignViewport().getSequenceSetId())) continue;
                aps.add(alignmentViewPanel);
            }
        }
        if (aps.size() == 0) {
            return null;
        }
        AlignmentViewPanel[] vap = aps.toArray(new AlignmentPanel[aps.size()]);
        return vap;
    }

    public static AlignmentViewport[] getViewports(String sequenceSetId) {
        ArrayList<AlignViewport> viewp = new ArrayList<AlignViewport>();
        if (Desktop.getDesktopPane() != null) {
            AlignFrame[] frames;
            for (AlignFrame afr : frames = Desktop.getDesktopAlignFrames()) {
                if (sequenceSetId != null && !afr.getViewport().getSequenceSetId().equals(sequenceSetId)) continue;
                if (afr.alignPanels != null) {
                    for (AlignmentPanel ap : afr.alignPanels) {
                        if (sequenceSetId != null && !sequenceSetId.equals(ap.av.getSequenceSetId())) continue;
                        viewp.add(ap.av);
                    }
                    continue;
                }
                viewp.add(afr.getViewport());
            }
            if (viewp.size() > 0) {
                return viewp.toArray(new AlignmentViewport[viewp.size()]);
            }
        }
        return null;
    }

    public static void explodeViews(AlignFrame af) {
        int size = af.alignPanels.size();
        if (size < 2) {
            return;
        }
        FeatureSettings viewFeatureSettings = af.featureSettings != null && af.featureSettings.isOpen() ? af.featureSettings : null;
        Rectangle fsBounds = af.getFeatureSettingsGeometry();
        for (int i = 0; i < size; ++i) {
            Rectangle geometry;
            AlignmentPanel ap = af.alignPanels.get(i);
            AlignFrame newaf = new AlignFrame(ap);
            if (ap == af.alignPanel) {
                if (viewFeatureSettings != null && viewFeatureSettings.fr.ap == ap) {
                    newaf.featureSettings = viewFeatureSettings;
                }
                newaf.setFeatureSettingsGeometry(fsBounds);
            }
            if ((geometry = ap.av.getExplodedGeometry()) != null) {
                newaf.setBounds(geometry);
            }
            ap.av.setGatherViewsHere(false);
            Desktop.addInternalFrame(newaf, af.getTitle(), 700, 500);
            if (ap != af.alignPanel || newaf.featureSettings == null || !newaf.featureSettings.isOpen() || !af.alignPanel.getAlignViewport().isShowSequenceFeatures()) continue;
            newaf.showFeatureSettingsUI();
        }
        af.featureSettings = null;
        af.alignPanels.clear();
        af.closeMenuItem_actionPerformed(true);
    }

    public void gatherViews(AlignFrame source) {
        source.viewport.setGatherViewsHere(true);
        source.viewport.setExplodedGeometry(source.getBounds());
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        String viewId = source.viewport.getSequenceSetId();
        for (int t = 0; t < frames.length; ++t) {
            if (!(frames[t] instanceof AlignFrame) || frames[t] == source) continue;
            AlignFrame af = (AlignFrame)frames[t];
            boolean gatherThis = false;
            for (int a = 0; a < af.alignPanels.size(); ++a) {
                AlignmentPanel ap = af.alignPanels.get(a);
                if (!viewId.equals(ap.av.getSequenceSetId())) continue;
                gatherThis = true;
                ap.av.setGatherViewsHere(false);
                ap.av.setExplodedGeometry(af.getBounds());
                source.addAlignmentPanel(ap, false);
            }
            if (!gatherThis) continue;
            if (af.featureSettings != null && af.featureSettings.isOpen()) {
                if (source.featureSettings == null) {
                    source.featureSettings = af.featureSettings;
                    source.setFeatureSettingsGeometry(af.getFeatureSettingsGeometry());
                } else {
                    af.featureSettings.close();
                }
            }
            af.alignPanels.clear();
            af.closeMenuItem_actionPerformed(true);
        }
        if (source.featureSettings != null && source.featureSettings.isOpen()) {
            source.showFeatureSettingsUI();
        }
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopPane.getAllFrames();
    }

    public void checkForQuestionnaire(String url) {
        UserQuestionnaireCheck jvq = new UserQuestionnaireCheck(url);
        new Thread(jvq).start();
    }

    public void checkURLLinks() {
        this.addDialogThread(new Runnable(){

            @Override
            public void run() {
                if (Cache.getDefault("CHECKURLLINKS", true)) {
                    List<String> links = Preferences.getInstance().sequenceUrlLinks.getLinksForMenu();
                    ListIterator<String> li = links.listIterator();
                    boolean check = false;
                    ArrayList<JLabel> urls = new ArrayList<JLabel>();
                    while (li.hasNext()) {
                        String link = li.next();
                        if (!link.contains("SEQUENCE_ID") || UrlConstants.isDefaultString(link)) continue;
                        check = true;
                        int barPos = link.indexOf("|");
                        String urlMsg = barPos == -1 ? link : link.substring(0, barPos) + ": " + link.substring(barPos + 1);
                        urls.add(new JLabel(urlMsg));
                    }
                    if (!check) {
                        return;
                    }
                    JPanel msgPanel = new JPanel();
                    msgPanel.setLayout(new BoxLayout(msgPanel, 3));
                    msgPanel.add(Box.createVerticalGlue());
                    JLabel msg = new JLabel(MessageManager.getString("label.SEQUENCE_ID_for_DB_ACCESSION1"));
                    JLabel msg2 = new JLabel(MessageManager.getString("label.SEQUENCE_ID_for_DB_ACCESSION2"));
                    msgPanel.add(msg);
                    for (JLabel url : urls) {
                        msgPanel.add(url);
                    }
                    msgPanel.add(msg2);
                    final JCheckBox jcb = new JCheckBox(MessageManager.getString("label.do_not_display_again"));
                    jcb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            boolean showWarningAgain = !jcb.isSelected();
                            Cache.setProperty("CHECKURLLINKS", Boolean.valueOf(showWarningAgain).toString());
                        }
                    });
                    msgPanel.add(jcb);
                    JvOptionPane.showMessageDialog(Desktop.this.desktopPane, msgPanel, MessageManager.getString("label.SEQUENCE_ID_no_longer_used"), 2);
                }
            }
        });
    }

    @Override
    public AlignFrame[] getAlignFrames() {
        if (Desktop.getDesktopPane() == null) {
            return null;
        }
        JInternalFrame[] frames = Desktop.getDesktopPane().getAllFrames();
        if (frames == null) {
            return null;
        }
        ArrayList<AlignFrame> avp = new ArrayList<AlignFrame>();
        for (int i = frames.length - 1; i > -1; --i) {
            if (frames[i] instanceof AlignFrame) {
                avp.add((AlignFrame)frames[i]);
                continue;
            }
            if (!(frames[i] instanceof SplitFrame)) continue;
            GSplitFrame sf = (GSplitFrame)frames[i];
            if (sf.getTopFrame() instanceof AlignFrame) {
                avp.add((AlignFrame)sf.getTopFrame());
            }
            if (!(sf.getBottomFrame() instanceof AlignFrame)) continue;
            avp.add((AlignFrame)sf.getBottomFrame());
        }
        if (avp.size() == 0) {
            return null;
        }
        AlignFrame[] afs = avp.toArray(new AlignFrame[avp.size()]);
        return afs;
    }

    public static AlignFrame[] getDesktopAlignFrames() {
        if (Jalview.isHeadlessMode()) {
            return Jalview.getInstance().getAlignFrames();
        }
        if (Desktop.getDesktopPane() != null) {
            return Desktop.getInstance().getAlignFrames();
        }
        return null;
    }

    public GStructureViewer[] getJmols() {
        JInternalFrame[] frames = this.desktopPane.getAllFrames();
        if (frames == null) {
            return null;
        }
        ArrayList<GStructureViewer> avp = new ArrayList<GStructureViewer>();
        for (int i = frames.length - 1; i > -1; --i) {
            if (!(frames[i] instanceof AppJmol)) continue;
            GStructureViewer af = (GStructureViewer)frames[i];
            avp.add(af);
        }
        if (avp.size() == 0) {
            return null;
        }
        GStructureViewer[] afs = avp.toArray(new GStructureViewer[avp.size()]);
        return afs;
    }

    @Override
    public void groovyShell_actionPerformed() {
        try {
            this.openGroovyConsole();
        }
        catch (Exception ex) {
            jalview.bin.Console.error("Groovy Console creation failed.", ex);
            JvOptionPane.showInternalMessageDialog((Component)this.desktopPane, MessageManager.getString("label.couldnt_create_groovy_shell"), MessageManager.getString("label.groovy_support_failed"), 0);
        }
    }

    void openGroovyConsole() {
        if (groovyConsole == null) {
            JalviewObject j = new JalviewObject(this);
            groovyConsole = new groovy.console.ui.Console();
            groovyConsole.setVariable("Jalview", (Object)j);
            groovyConsole.setVariable("currentAlFrame", (Object)this.getCurrentAlignFrame());
            groovyConsole.run();
            Window window = (Window)((Object)groovyConsole.getFrame());
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Desktop.this.addQuitHandler();
                    Desktop.this.enableExecuteGroovy(false);
                }
            });
        }
        ((Window)((Object)groovyConsole.getFrame())).setVisible(true);
        this.enableExecuteGroovy(true);
    }

    protected void addQuitHandler() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(81, Platform.SHORTCUT_KEY_MASK), "Quit");
        this.getRootPane().getActionMap().put("Quit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.this.desktopQuit();
            }
        });
    }

    public void enableExecuteGroovy(boolean enabled) {
        this.groovyShell.setEnabled(!enabled);
        AlignFrame[] alignFrames = Desktop.getDesktopAlignFrames();
        if (alignFrames != null) {
            for (AlignFrame af : alignFrames) {
                af.setGroovyEnabled(enabled);
            }
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        if (this.progressBars == null) {
            this.progressBars = new Hashtable();
            this.progressBarHandlers = new Hashtable();
            this.progressBarMessages = new Hashtable();
        }
        if (this.progressBars.get(id) != null) {
            JPanel panel = this.progressBars.remove(id);
            if (this.progressBarHandlers.contains(id)) {
                this.progressBarHandlers.remove(id);
            }
            this.removeProgressPanel(panel);
        } else {
            this.progressBars.put(id, this.addProgressPanel(message));
            if (message != null) {
                this.progressBarMessages.put(id, message);
            } else {
                this.progressBarMessages.remove(id);
            }
        }
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        if (this.progressBars == null) {
            return null;
        }
        if (this.progressBars.get(id) == null) {
            return null;
        }
        for (Component c : this.progressBars.get(id).getComponents()) {
            if (c.getClass() != JProgressBar.class) continue;
            return (JProgressBar)c;
        }
        return null;
    }

    @Override
    public void addProgressBar(long id, String message) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeProgressBar(long id) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void registerHandler(final long id, final IProgressIndicatorHandler handler) {
        if (this.progressBarHandlers == null || !this.progressBars.containsKey(id)) {
            throw new Error(MessageManager.getString("error.call_setprogressbar_before_registering_handler"));
        }
        this.progressBarHandlers.put(id, handler);
        final JPanel progressPanel = this.progressBars.get(id);
        if (handler.canCancel()) {
            JButton cancel = new JButton(MessageManager.getString("action.cancel"));
            final Desktop us = this;
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    handler.cancelActivity(id);
                    us.setProgressBar(MessageManager.formatMessage("label.cancelled_params", ((JLabel)progressPanel.getComponent(0)).getText()), id);
                }
            });
            progressPanel.add((Component)cancel, "East");
        }
    }

    @Override
    public String getMessage(long id) {
        return this.progressBarMessages.get(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        Container progBar = this.progressBars.get(id);
        if (progBar == null || progBar.getComponentCount() == 0) {
            return;
        }
        for (Component component : progBar.getComponents()) {
            if (!component.getClass().equals(JLabel.class)) continue;
            ((JLabel)component).setText(message);
            progBar.revalidate();
        }
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBars != null && this.progressBars.size() > 0;
    }

    public static AlignFrame getAlignFrameFor(AlignViewportI viewport) {
        if (Desktop.getDesktopPane() != null) {
            AlignmentViewPanel[] aps = Desktop.getAlignmentPanels(viewport.getSequenceSetId());
            for (int panel = 0; aps != null && panel < aps.length; ++panel) {
                if (aps[panel] == null || aps[panel].getAlignViewport() != viewport) continue;
                return ((AlignmentPanel)aps[panel]).alignFrame;
            }
        }
        return null;
    }

    public VamsasApplication getVamsasApplication() {
        return null;
    }

    public boolean isInBatchMode() {
        return this.inBatchMode;
    }

    public void setInBatchMode(boolean inBatchMode) {
        this.inBatchMode = inBatchMode;
    }

    public void startServiceDiscovery() {
        this.startServiceDiscovery(false);
    }

    public void startServiceDiscovery(boolean blocking) {
        jalview.bin.Console.debug("Starting service discovery");
        ArrayList<Future<Object>> tasks = new ArrayList<Future<Object>>();
        System.out.println("loading services");
        if (this.discoverer == null) {
            this.discoverer = Discoverer.getInstance();
            this.discoverer.addPropertyChangeListener(this.changeSupport);
        }
        FutureTask<Object> f = new FutureTask<Object>(this.discoverer, null);
        new Thread(f).start();
        tasks.add(f);
        if (Cache.getDefault("SHOW_JWS2_SERVICES", true)) {
            tasks.add(Jws2Discoverer.getInstance().startDiscoverer());
        }
        if (Cache.getDefault("SHOW_SLIVKA_SERVICES", true)) {
            tasks.add(SlivkaWSDiscoverer.getInstance().startDiscoverer());
        }
        if (Cache.getDefault("SHOW_EBI_SERVICES", true)) {
            tasks.add(JobDispatcherWSDiscoverer.getInstance().startDiscoverer());
        }
        if (Cache.getDefault("SHOW_JPRED4_SERVICES", true)) {
            tasks.add(JPred4WSDiscoverer.getInstance().startDiscoverer());
        }
        if (blocking) {
            for (Future future : tasks) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void JalviewServicesChanged(PropertyChangeEvent evt) {
        Jws2Discoverer discoverer;
        String ermsg;
        if ((evt.getNewValue() == null || evt.getNewValue() instanceof Vector) && (ermsg = (discoverer = Jws2Discoverer.getInstance()).getErrorMessages()) != null) {
            if (Cache.getDefault("SHOW_WSDISCOVERY_ERRORS", true)) {
                if (this.serviceChangedDialog == null) {
                    this.serviceChangedDialog = new Runnable(){

                        @Override
                        public void run() {
                            JvOptionPane.showConfirmDialog(Desktop.this.desktopPane, new JLabel("<html><table width=\"450\"><tr><td>" + ermsg + "</td></tr></table><p>It may be that you have invalid JABA URLs<br/>in your web service preferences,<br>or as a command-line argument, or mis-configured HTTP proxy settings.</p><p>Check the <em>Connections</em> and <em>Web services</em> tab<br/>of the Tools->Preferences dialog box to change them.</p></html>"), "Web Service Configuration Problem", -1, 0);
                            Desktop.this.serviceChangedDialog = null;
                        }
                    };
                    this.addDialogThread(this.serviceChangedDialog);
                }
            } else {
                jalview.bin.Console.error("Errors reported by JABA discovery service. Check web services preferences.\n" + ermsg);
            }
        }
    }

    public static void showUrl(String url) {
        if (url != null && !url.trim().equals("")) {
            jalview.bin.Console.info("Opening URL: " + url);
            Desktop.showUrl(url, Desktop.getInstance());
        } else {
            jalview.bin.Console.warn("Ignoring attempt to show an empty URL.");
        }
    }

    public static void showUrl(final String url, final IProgressIndicator progress) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (progress != null) {
                        progress.setProgressBar(MessageManager.formatMessage("status.opening_params", url), this.hashCode());
                    }
                    BrowserLauncher.openURL(url);
                }
                catch (Exception ex) {
                    JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), MessageManager.getString("label.web_browser_not_found_unix"), MessageManager.getString("label.web_browser_not_found"), 2);
                    ex.printStackTrace();
                }
                if (progress != null) {
                    progress.setProgressBar(null, this.hashCode());
                }
            }
        }).start();
    }

    public static ParamManager getUserParameterStore() {
        if (wsparamManager == null) {
            wsparamManager = new WsParamSetManager();
        }
        return wsparamManager;
    }

    public static void hyperlinkUpdate(HyperlinkEvent e) {
        block3: {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String url = null;
                try {
                    url = e.getURL().toString();
                    Desktop.showUrl(url);
                }
                catch (Exception x) {
                    if (url == null) break block3;
                    jalview.bin.Console.error("Couldn't handle string " + url + " as a URL.");
                }
            }
        }
    }

    public void addDialogThread(final Runnable prompter) {
        if (this.dialogExecutor == null) {
            return;
        }
        this.dialogExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (Desktop.this.dialogPause) {
                    Desktop.this.acquireDialogQueue();
                }
                if (Jalview.isHeadlessMode()) {
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(prompter);
                }
                catch (Exception q) {
                    jalview.bin.Console.warn("Unexpected Exception in dialog thread.", q);
                }
            }
        });
    }

    public void startDialogQueue() {
        if (this.dialogQueueStarted) {
            return;
        }
        this.releaseDialogQueue();
        this.dialogQueueStarted = true;
    }

    public void acquireDialogQueue() {
        try {
            this.block.acquire();
            this.dialogPause = true;
        }
        catch (InterruptedException e) {
            jalview.bin.Console.debug("Interruption when acquiring DialogueQueue", e);
        }
    }

    public void releaseDialogQueue() {
        if (!this.dialogPause) {
            return;
        }
        this.block.release();
        this.dialogPause = false;
    }

    @Override
    protected void snapShotWindow_actionPerformed(ActionEvent e) {
        this.invalidate();
        int width = this.getWidth();
        int height = this.getHeight();
        final File of = new File("Jalview_snapshot_" + System.currentTimeMillis() + ".eps");
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                Desktop.this.paintAll(g);
                jalview.bin.Console.info("Successfully written snapshot to file " + of.getAbsolutePath());
            }
        };
        String title = "View of desktop";
        ImageExporter exporter = new ImageExporter(writer, null, ImageMaker.TYPE.EPS, title);
        try {
            exporter.doExport(of, this, width, height, title);
        }
        catch (ImageOutputException ioex) {
            jalview.bin.Console.error("Unexpected error whilst writing Jalview desktop snapshot as EPS", ioex);
        }
    }

    public void explodeViews(SplitFrame sf) {
        AlignFrame oldTopFrame = (AlignFrame)sf.getTopFrame();
        AlignFrame oldBottomFrame = (AlignFrame)sf.getBottomFrame();
        List<? extends AlignmentViewPanel> topPanels = oldTopFrame.getAlignPanels();
        List<? extends AlignmentViewPanel> bottomPanels = oldBottomFrame.getAlignPanels();
        int viewCount = topPanels.size();
        if (viewCount < 2) {
            return;
        }
        for (int i = viewCount - 1; i >= 0; --i) {
            AlignmentPanel topPanel = (AlignmentPanel)topPanels.get(i);
            AlignFrame newTopFrame = new AlignFrame(topPanel);
            newTopFrame.setSize(oldTopFrame.getSize());
            newTopFrame.setVisible(true);
            Rectangle geometry = ((AlignViewport)topPanel.getAlignViewport()).getExplodedGeometry();
            if (geometry != null) {
                newTopFrame.setSize(geometry.getSize());
            }
            AlignmentPanel bottomPanel = (AlignmentPanel)bottomPanels.get(i);
            AlignFrame newBottomFrame = new AlignFrame(bottomPanel);
            newBottomFrame.setSize(oldBottomFrame.getSize());
            newBottomFrame.setVisible(true);
            geometry = ((AlignViewport)bottomPanel.getAlignViewport()).getExplodedGeometry();
            if (geometry != null) {
                newBottomFrame.setSize(geometry.getSize());
            }
            topPanel.av.setGatherViewsHere(false);
            bottomPanel.av.setGatherViewsHere(false);
            SplitFrame splitFrame = new SplitFrame(newTopFrame, newBottomFrame);
            if (geometry != null) {
                splitFrame.setLocation(geometry.getLocation());
            }
            Desktop.addInternalFrame(splitFrame, sf.getTitle(), -1, -1);
        }
        topPanels.clear();
        bottomPanels.clear();
        sf.close();
    }

    public void gatherViews(GSplitFrame source) {
        JInternalFrame[] frames;
        AlignFrame myTopFrame = (AlignFrame)source.getTopFrame();
        AlignFrame myBottomFrame = (AlignFrame)source.getBottomFrame();
        myTopFrame.viewport.setExplodedGeometry(new Rectangle(source.getX(), source.getY(), myTopFrame.getWidth(), myTopFrame.getHeight()));
        myBottomFrame.viewport.setExplodedGeometry(new Rectangle(source.getX(), source.getY(), myBottomFrame.getWidth(), myBottomFrame.getHeight()));
        myTopFrame.viewport.setGatherViewsHere(true);
        myBottomFrame.viewport.setGatherViewsHere(true);
        String topViewId = myTopFrame.viewport.getSequenceSetId();
        String bottomViewId = myBottomFrame.viewport.getSequenceSetId();
        for (JInternalFrame frame : frames = this.desktopPane.getAllFrames()) {
            if (!(frame instanceof SplitFrame) || frame == source) continue;
            SplitFrame sf = (SplitFrame)frame;
            AlignFrame topFrame = (AlignFrame)sf.getTopFrame();
            AlignFrame bottomFrame = (AlignFrame)sf.getBottomFrame();
            boolean gatherThis = false;
            for (int a = 0; a < topFrame.alignPanels.size(); ++a) {
                AlignmentPanel topPanel = topFrame.alignPanels.get(a);
                AlignmentPanel bottomPanel = bottomFrame.alignPanels.get(a);
                if (!topViewId.equals(topPanel.av.getSequenceSetId()) || !bottomViewId.equals(bottomPanel.av.getSequenceSetId())) continue;
                gatherThis = true;
                topPanel.av.setGatherViewsHere(false);
                bottomPanel.av.setGatherViewsHere(false);
                topPanel.av.setExplodedGeometry(new Rectangle(sf.getLocation(), topFrame.getSize()));
                bottomPanel.av.setExplodedGeometry(new Rectangle(sf.getLocation(), bottomFrame.getSize()));
                myTopFrame.addAlignmentPanel(topPanel, false);
                myBottomFrame.addAlignmentPanel(bottomPanel, false);
            }
            if (!gatherThis) continue;
            topFrame.getAlignPanels().clear();
            bottomFrame.getAlignPanels().clear();
            sf.close();
        }
        myTopFrame.setDisplayedView(myTopFrame.alignPanel);
    }

    public static groovy.console.ui.Console getGroovyConsole() {
        return groovyConsole;
    }

    public static void transferFromDropTarget(List<Object> files, List<DataSourceType> protocols, DropTargetDropEvent evt, Transferable t) throws Exception {
        DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        DataFlavor urlFlavour = null;
        try {
            urlFlavour = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException cfe) {
            jalview.bin.Console.debug("Couldn't instantiate the URL dataflavor.", cfe);
        }
        if (urlFlavour != null && t.isDataFlavorSupported(urlFlavour)) {
            try {
                URL url = (URL)t.getTransferData(urlFlavour);
                if (url != null) {
                    protocols.add(DataSourceType.URL);
                    files.add(url.toString());
                    jalview.bin.Console.debug("Drop handled as URL dataflavor " + files.get(files.size() - 1));
                    return;
                }
                if (Platform.isAMacAndNotJS()) {
                    jalview.bin.Console.errPrintln("Please ignore plist error - occurs due to problem with java 8 on OSX");
                }
            }
            catch (Throwable ex) {
                jalview.bin.Console.debug("URL drop handler failed.", ex);
            }
        }
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            jalview.bin.Console.debug("Drop handled as javaFileListFlavor");
            for (File file : (List)t.getTransferData(DataFlavor.javaFileListFlavor)) {
                files.add(file);
                protocols.add(DataSourceType.FILE);
            }
        } else {
            boolean added = false;
            String data = null;
            if (t.isDataFlavorSupported(uriListFlavor)) {
                jalview.bin.Console.debug("Drop handled as uriListFlavor");
                data = (String)t.getTransferData(uriListFlavor);
            }
            if (data == null) {
                jalview.bin.Console.debug("standard URIListFlavor failed. Trying text");
                DataFlavor textDf = new DataFlavor("text/plain;class=java.lang.String");
                if (t.isDataFlavorSupported(textDf)) {
                    data = (String)t.getTransferData(textDf);
                }
                jalview.bin.Console.debug("Plain text drop content returned " + (data == null ? "Null - failed" : data));
            }
            if (data != null) {
                while (protocols.size() < files.size()) {
                    jalview.bin.Console.debug("Adding missing FILE protocol for " + files.get(protocols.size()));
                    protocols.add(DataSourceType.FILE);
                }
                DataFlavor[] st = new StringTokenizer(data, "\r\n");
                while (st.hasMoreTokens()) {
                    added = true;
                    String s = st.nextToken();
                    if (s.startsWith("#")) continue;
                    URI uri = new URI(s);
                    if (uri.getScheme().toLowerCase(Locale.ROOT).startsWith("http")) {
                        protocols.add(DataSourceType.URL);
                        files.add(uri.toString());
                        continue;
                    }
                    File file = new File(uri);
                    protocols.add(DataSourceType.FILE);
                    files.add(file.toString());
                }
            }
            if (jalview.bin.Console.isDebugEnabled() && (data == null || !added)) {
                if (t.getTransferDataFlavors() != null && t.getTransferDataFlavors().length > 0) {
                    jalview.bin.Console.debug("Couldn't resolve drop data. Here are the supported flavors:");
                    for (DataFlavor fl : t.getTransferDataFlavors()) {
                        jalview.bin.Console.debug("Supported transfer dataflavor: " + fl.toString());
                        Object df = t.getTransferData(fl);
                        if (df != null) {
                            jalview.bin.Console.debug("Retrieves: " + df);
                            continue;
                        }
                        jalview.bin.Console.debug("Retrieved nothing");
                    }
                } else {
                    jalview.bin.Console.debug("Couldn't resolve dataflavor for drop: " + t.toString());
                }
            }
        }
        if (Platform.isWindowsAndNotJS()) {
            jalview.bin.Console.debug("Scanning dropped content for Windows Link Files");
            for (int f = 0; f < files.size(); ++f) {
                String source = files.get(f).toString().toLowerCase(Locale.ROOT);
                if (!protocols.get(f).equals((Object)DataSourceType.FILE) || !source.endsWith(".lnk") && !source.endsWith(".url") && !source.endsWith(".site")) continue;
                try {
                    Object obj = files.get(f);
                    File lf = obj instanceof File ? (File)obj : new File((String)obj);
                    jalview.bin.Console.debug("Found potential link file: " + lf);
                    WindowsShortcut wscfile = new WindowsShortcut(lf);
                    String fullname = wscfile.getRealFilename();
                    protocols.set(f, FormatAdapter.checkProtocol(fullname));
                    files.set(f, fullname);
                    jalview.bin.Console.debug("Parsed real filename " + fullname + " to extract protocol: " + (Object)((Object)protocols.get(f)));
                    continue;
                }
                catch (Exception ex) {
                    jalview.bin.Console.error("Couldn't parse " + files.get(f) + " as a link file.", ex);
                }
            }
        }
    }

    @Override
    protected void showExperimental_actionPerformed(boolean selected) {
        Cache.setProperty(EXPERIMENTAL_FEATURES, Boolean.toString(selected));
    }

    public List<StructureViewerBase> getStructureViewers(AlignmentPanel apanel, Class<? extends StructureViewerBase> structureViewerClass) {
        JInternalFrame[] frames;
        ArrayList<StructureViewerBase> result = new ArrayList<StructureViewerBase>();
        for (JInternalFrame frame : frames = this.getAllFrames()) {
            if (!(frame instanceof StructureViewerBase) || structureViewerClass != null && !structureViewerClass.isInstance(frame) || apanel != null && !((StructureViewerBase)frame).isLinkedWith(apanel)) continue;
            result.add((StructureViewerBase)frame);
        }
        return result;
    }

    public static void debugScaleMessage(Graphics g) {
        if (debugScaleMessageDone) {
            return;
        }
        try {
            Graphics2D gg = (Graphics2D)g;
            if (gg != null) {
                AffineTransform t = gg.getTransform();
                double scaleX = t.getScaleX();
                double scaleY = t.getScaleY();
                jalview.bin.Console.debug(debugScaleMessage + scaleX + " (X)");
                jalview.bin.Console.debug(debugScaleMessage + scaleY + " (Y)");
                debugScaleMessageDone = true;
            } else {
                jalview.bin.Console.debug("Desktop graphics null");
            }
        }
        catch (Exception e) {
            jalview.bin.Console.debug(Cache.getStackTraceString(e));
        }
    }

    public static void closeDesktop() {
        if (Desktop.getInstance() != null) {
            final Desktop us = Desktop.getInstance();
            us.quitTheDesktop(false, false);
            if (us != null) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ExecutorService dex = us.dialogExecutor;
                        if (dex != null) {
                            dex.shutdownNow();
                            us.dialogExecutor = null;
                            us.block.drainPermits();
                        }
                        us.dispose();
                    }
                }).start();
            }
        }
    }

    public boolean operationsAreInProgress() {
        JInternalFrame[] frames;
        for (JInternalFrame frame : frames = this.getAllFrames()) {
            if (!(frame instanceof IProgressIndicator) || !((IProgressIndicator)((Object)frame)).operationInProgress()) continue;
            return true;
        }
        return this.operationInProgress();
    }

    protected static void addModal(AlignFrame af, JInternalFrame jif) {
        alignFrameModalMap.put(af, jif);
    }

    protected static void closeModal(AlignFrame af) {
        if (!alignFrameModalMap.containsKey(af)) {
            return;
        }
        JInternalFrame jif = alignFrameModalMap.get(af);
        if (jif != null) {
            try {
                jif.setClosed(true);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }
        alignFrameModalMap.remove(af);
    }

    public void nonBlockingDialog(String title, String message, String button, int type, boolean scrollable, boolean modal) {
        this.nonBlockingDialog(title, message, null, button, type, scrollable, false, modal, -1);
    }

    public void nonBlockingDialog(String title, String message, String boxtext, String button, int type, boolean scrollable, boolean html, boolean modal, int timeout) {
        this.nonBlockingDialog(32, 2, title, message, boxtext, button, type, scrollable, html, modal, timeout);
    }

    public void nonBlockingDialog(int width, int height, String title, String message, String boxtext, String button, int type, boolean scrollable, boolean html, boolean modal, int timeout) {
        if (type < 0) {
            type = 2;
        }
        JLabel jl = new JLabel(message);
        JTextComponent jtc = null;
        if (html) {
            JTextPane jtp = new JTextPane();
            jtp.setContentType("text/html");
            jtp.setEditable(false);
            jtp.setAutoscrolls(true);
            jtp.setText(boxtext);
            jtc = jtp;
        } else {
            JTextArea jta = new JTextArea(height, width);
            jta.setEditable(false);
            jta.setWrapStyleWord(true);
            jta.setAutoscrolls(true);
            jta.setText(boxtext);
            jtc = jta;
        }
        JScrollPane jsp = scrollable ? new JScrollPane(jtc, 20, 30) : null;
        JvOptionPane jvp = JvOptionPane.newOptionDialog(this);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        if (message != null) {
            jl.setAlignmentX(0.0f);
            jp.add(jl);
        }
        if (boxtext != null) {
            if (scrollable) {
                jsp.setAlignmentX(0.0f);
                jp.add(jsp);
            } else {
                jtc.setAlignmentX(0.0f);
                jp.add(jtc);
            }
        }
        jvp.setResponseHandler(0, () -> {});
        jvp.setTimeout(timeout);
        JButton jb = new JButton(button);
        jvp.showDialogOnTopAsync(this, jp, title, 0, type, null, new Object[]{button}, button, modal, new JButton[]{jb}, false);
    }

    @Override
    public AlignFrame getCurrentAlignFrame() {
        return Jalview.getInstance().getCurrentAlignFrame();
    }

    static {
        URL bg_logo_url = ChannelProperties.getImageURL("bg_logo." + String.valueOf(SplashScreen.logoSize));
        URL uod_logo_url = ChannelProperties.getImageURL("uod_banner." + String.valueOf(SplashScreen.logoSize));
        boolean logo = bg_logo_url != null || uod_logo_url != null;
        StringBuilder sb = new StringBuilder();
        sb.append("<br><br>Jalview is free software released under GPLv3.<br><br>Development is managed by The Barton Group, University of Dundee, Scotland, UK.");
        if (logo) {
            sb.append("<br>");
        }
        sb.append((String)(bg_logo_url == null ? "" : "<img alt=\"Barton Group logo\" src=\"" + bg_logo_url.toString() + "\">"));
        sb.append((String)(uod_logo_url == null ? "" : "&nbsp;<img alt=\"University of Dundee shield\" src=\"" + uod_logo_url.toString() + "\">"));
        sb.append("<br><br>For help, see <a href=\"https://www.jalview.org/help/faq\">www.jalview.org/faq</a> and join <a href=\"https://discourse.jalview.org\">discourse.jalview.org</a>");
        sb.append("<br><br>If  you use Jalview, please cite:<br>Waterhouse, A.M., Procter, J.B., Martin, D.M.A, Clamp, M. and Barton, G. J. (2009)<br>Jalview Version 2 - a multiple sequence alignment editor and analysis workbench<br>Bioinformatics <a href=\"https://doi.org/10.1093/bioinformatics/btp033\">doi: 10.1093/bioinformatics/btp033</a>");
        CITATION = sb.toString();
        DEFAULT_MIN_WIDTH = 300;
        DEFAULT_MIN_HEIGHT = 250;
        ALIGN_FRAME_DEFAULT_MIN_WIDTH = 600;
        ALIGN_FRAME_DEFAULT_MIN_HEIGHT = 70;
        savingFiles = new HashMap();
        DRAG_MODE = 1;
        nosplash = false;
        wsparamManager = null;
        debugScaleMessageDone = false;
        alignFrameModalMap = new HashMap<AlignFrame, JInternalFrame>();
    }

    public class MyDesktopPane
    extends JDesktopPane
    implements Runnable {
        private static final float ONE_MB = 1048576.0f;
        boolean showMemoryUsage = false;
        Runtime runtime;
        NumberFormat df;
        float maxMemory;
        float allocatedMemory;
        float freeMemory;
        float totalFreeMemory;
        float percentUsage;

        public MyDesktopPane(boolean showMemoryUsage) {
            this.showMemoryUsage(showMemoryUsage);
        }

        public void showMemoryUsage(boolean showMemory) {
            this.showMemoryUsage = showMemory;
            if (showMemory) {
                Thread worker = new Thread(this);
                worker.start();
            }
            this.repaint();
        }

        public boolean isShowMemoryUsage() {
            return this.showMemoryUsage;
        }

        @Override
        public void run() {
            this.df = NumberFormat.getNumberInstance();
            this.df.setMaximumFractionDigits(2);
            this.runtime = Runtime.getRuntime();
            while (this.showMemoryUsage) {
                try {
                    this.maxMemory = (float)this.runtime.maxMemory() / 1048576.0f;
                    this.allocatedMemory = (float)this.runtime.totalMemory() / 1048576.0f;
                    this.freeMemory = (float)this.runtime.freeMemory() / 1048576.0f;
                    this.totalFreeMemory = this.freeMemory + (this.maxMemory - this.allocatedMemory);
                    this.percentUsage = this.totalFreeMemory / this.maxMemory * 100.0f;
                    this.repaint();
                    Thread.sleep(3000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.showMemoryUsage && g != null && this.df != null) {
                FontMetrics fm;
                if (this.percentUsage < 20.0f) {
                    g.setColor(Color.red);
                }
                if ((fm = g.getFontMetrics()) != null) {
                    g.drawString(MessageManager.formatMessage("label.memory_stats", this.df.format(this.totalFreeMemory), this.df.format(this.maxMemory), this.df.format(this.percentUsage)), 10, this.getHeight() - fm.getHeight());
                }
            }
            Desktop.debugScaleMessage(Desktop.getDesktopPane().getGraphics());
        }
    }

    class MyDesktopManager
    implements DesktopManager {
        private DesktopManager delegate;

        public MyDesktopManager(DesktopManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void activateFrame(JInternalFrame f) {
            try {
                this.delegate.activateFrame(f);
            }
            catch (NullPointerException npe) {
                Point p = Desktop.this.getMousePosition();
                Desktop.this.showPasteMenu(p.x, p.y);
            }
        }

        @Override
        public void beginDraggingFrame(JComponent f) {
            this.delegate.beginDraggingFrame(f);
        }

        @Override
        public void beginResizingFrame(JComponent f, int direction) {
            this.delegate.beginResizingFrame(f, direction);
        }

        @Override
        public void closeFrame(JInternalFrame f) {
            this.delegate.closeFrame(f);
        }

        @Override
        public void deactivateFrame(JInternalFrame f) {
            this.delegate.deactivateFrame(f);
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            this.delegate.deiconifyFrame(f);
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            if (newY < 0) {
                newY = 0;
            }
            this.delegate.dragFrame(f, newX, newY);
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            this.delegate.endDraggingFrame(f);
            Desktop.this.desktopPane.repaint();
        }

        @Override
        public void endResizingFrame(JComponent f) {
            this.delegate.endResizingFrame(f);
            Desktop.this.desktopPane.repaint();
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            this.delegate.iconifyFrame(f);
        }

        @Override
        public void maximizeFrame(JInternalFrame f) {
            this.delegate.maximizeFrame(f);
        }

        @Override
        public void minimizeFrame(JInternalFrame f) {
            this.delegate.minimizeFrame(f);
        }

        @Override
        public void openFrame(JInternalFrame f) {
            this.delegate.openFrame(f);
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            if (newY < 0) {
                newY = 0;
            }
            this.delegate.resizeFrame(f, newX, newY, newWidth, newHeight);
        }

        @Override
        public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            this.delegate.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        }
    }
}

