/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.JVDialog;
import jalview.appletgui.SplitFrame;
import jalview.appletgui.TreePanel;
import jalview.bin.JalviewLite;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FontChooser
extends Panel
implements ItemListener {
    private static final Font VERDANA_11PT = new Font("Verdana", 0, 11);
    private Choice fontSize = new Choice();
    private Choice fontStyle = new Choice();
    private Choice fontName = new Choice();
    private Checkbox scaleAsCdna = new Checkbox();
    private Checkbox fontAsCdna = new Checkbox();
    private Button ok = new Button();
    private Button cancel = new Button();
    private AlignmentPanel ap;
    private TreePanel tp;
    private Font oldFont;
    private Font oldComplementFont;
    private int oldCharWidth = 0;
    private boolean oldScaleProtein = false;
    boolean oldMirrorFont;
    private Font lastSelected = null;
    private int lastSelStyle = 0;
    private int lastSelSize = 0;
    private boolean init = true;
    private Frame frame;
    boolean inSplitFrame = false;

    public FontChooser(TreePanel tp) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tp = tp;
        this.oldFont = tp.getTreeFont();
        this.init();
    }

    public FontChooser(AlignmentPanel ap) {
        this.ap = ap;
        this.oldFont = ap.av.getFont();
        this.oldCharWidth = ap.av.getCharWidth();
        this.oldScaleProtein = ap.av.isScaleProteinAsCdna();
        this.oldMirrorFont = ap.av.isProteinFontAsCdna();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    void init() {
        int i;
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontName.addItem(fonts[i]);
        }
        for (i = 1; i < 31; ++i) {
            this.fontSize.addItem("" + i);
        }
        this.fontStyle.addItem("plain");
        this.fontStyle.addItem("bold");
        this.fontStyle.addItem("italic");
        this.fontName.select(this.oldFont.getName());
        this.fontSize.select("" + this.oldFont.getSize());
        this.fontStyle.select(this.oldFont.getStyle());
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, MessageManager.getString("action.change_font"), 440, 145);
        this.init = false;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.fontName) {
            this.fontName_actionPerformed();
        } else if (source == this.fontSize) {
            this.fontSize_actionPerformed();
        } else if (source == this.fontStyle) {
            this.fontStyle_actionPerformed();
        } else if (source == this.scaleAsCdna) {
            this.scaleAsCdna_actionPerformed();
        } else if (source == this.fontAsCdna) {
            this.mirrorFont_actionPerformed();
        }
    }

    protected void mirrorFont_actionPerformed() {
        boolean selected = this.fontAsCdna.getState();
        this.ap.av.setProteinFontAsCdna(selected);
        this.ap.av.getCodingComplement().setProteinFontAsCdna(selected);
        if (!selected) {
            this.ap.av.getCodingComplement().setFont(this.oldComplementFont, true);
        }
        this.changeFont();
    }

    protected void ok_actionPerformed() {
        this.frame.setVisible(false);
        if (this.ap != null && this.ap.getOverviewPanel() != null) {
            this.ap.getOverviewPanel().updateOverviewImage();
        }
    }

    protected void cancel_actionPerformed() {
        if (this.ap != null) {
            this.ap.av.setScaleProteinAsCdna(this.oldScaleProtein);
            this.ap.av.setProteinFontAsCdna(this.oldMirrorFont);
            if (this.ap.av.getCodingComplement() != null) {
                this.ap.av.getCodingComplement().setScaleProteinAsCdna(this.oldScaleProtein);
                this.ap.av.getCodingComplement().setProteinFontAsCdna(this.oldMirrorFont);
                this.ap.av.getCodingComplement().setFont(this.oldComplementFont, true);
                SplitFrame splitFrame = this.ap.alignFrame.getSplitFrame();
                splitFrame.adjustLayout();
                splitFrame.getComplement((AlignFrame)this.ap.alignFrame).alignPanel.fontChanged();
                splitFrame.repaint();
            }
            this.ap.av.setFont(this.oldFont, true);
            if (this.ap.av.getCharWidth() != this.oldCharWidth) {
                this.ap.av.setCharWidth(this.oldCharWidth);
            }
            this.ap.paintAlignment(true, false);
        } else if (this.tp != null) {
            this.tp.setTreeFont(this.oldFont);
            this.tp.treeCanvas.repaint();
        }
        this.fontName.select(this.oldFont.getName());
        this.fontSize.select("" + this.oldFont.getSize());
        this.fontStyle.select(this.oldFont.getStyle());
        this.frame.setVisible(false);
    }

    void changeFont() {
        if (this.lastSelected == null) {
            this.lastSelected = this.oldFont;
            this.lastSelSize = this.oldFont.getSize();
            this.lastSelStyle = this.oldFont.getStyle();
        }
        Font newFont = new Font(this.fontName.getSelectedItem().toString(), this.fontStyle.getSelectedIndex(), Integer.parseInt(this.fontSize.getSelectedItem().toString()));
        FontMetrics fm = this.getGraphics().getFontMetrics(newFont);
        double mw = fm.getStringBounds("M", this.getGraphics()).getWidth();
        double iw = fm.getStringBounds("I", this.getGraphics()).getWidth();
        if (mw < 1.0 || iw < 1.0) {
            this.fontName.select(this.lastSelected.getName());
            this.fontStyle.select(this.lastSelStyle);
            this.fontSize.select("" + this.lastSelSize);
            JVDialog d = new JVDialog(this.frame, MessageManager.getString("label.invalid_font"), true, 350, 200);
            Panel mp = new Panel();
            d.cancel.setVisible(false);
            mp.setLayout(new FlowLayout());
            mp.add(new Label("Font doesn't have letters defined\nso cannot be used\nwith alignment data."));
            d.setMainPanel(mp);
            d.setVisible(true);
            return;
        }
        if (this.tp != null) {
            this.tp.setTreeFont(newFont);
        } else if (this.ap != null) {
            this.ap.av.setFont(newFont, true);
            this.ap.fontChanged();
            if (this.inSplitFrame) {
                if (this.fontAsCdna.getState()) {
                    this.ap.av.getCodingComplement().setFont(newFont, true);
                }
                SplitFrame splitFrame = this.ap.alignFrame.getSplitFrame();
                splitFrame.adjustLayout();
                splitFrame.getComplement((AlignFrame)this.ap.alignFrame).alignPanel.fontChanged();
                splitFrame.repaint();
            }
        }
        this.lastSelected = newFont;
    }

    protected void fontName_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontSize_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    protected void fontStyle_actionPerformed() {
        if (this.init) {
            return;
        }
        this.changeFont();
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        Label fontLabel = new Label(MessageManager.getString("label.font"));
        fontLabel.setFont(VERDANA_11PT);
        fontLabel.setAlignment(2);
        this.fontSize.setFont(VERDANA_11PT);
        this.fontSize.addItemListener(this);
        this.fontStyle.setFont(VERDANA_11PT);
        this.fontStyle.addItemListener(this);
        Label sizeLabel = new Label(MessageManager.getString("label.size"));
        sizeLabel.setAlignment(2);
        sizeLabel.setFont(VERDANA_11PT);
        Label styleLabel = new Label(MessageManager.getString("label.style"));
        styleLabel.setAlignment(2);
        styleLabel.setFont(VERDANA_11PT);
        this.fontName.setFont(VERDANA_11PT);
        this.fontName.addItemListener(this);
        this.scaleAsCdna.setLabel(MessageManager.getString("label.scale_as_cdna"));
        this.scaleAsCdna.setFont(VERDANA_11PT);
        this.scaleAsCdna.addItemListener(this);
        this.scaleAsCdna.setState(this.ap.av.isScaleProteinAsCdna());
        this.fontAsCdna.setLabel(MessageManager.getString("label.font_as_cdna"));
        this.fontAsCdna.setFont(VERDANA_11PT);
        this.fontAsCdna.addItemListener(this);
        this.fontAsCdna.setState(this.ap.av.isProteinFontAsCdna());
        this.ok.setFont(VERDANA_11PT);
        this.ok.setLabel(MessageManager.getString("action.ok"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.ok_actionPerformed();
            }
        });
        this.cancel.setFont(VERDANA_11PT);
        this.cancel.setLabel(MessageManager.getString("action.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.cancel_actionPerformed();
            }
        });
        Panel fontPanel = new Panel();
        fontPanel.setLayout(new BorderLayout());
        Panel stylePanel = new Panel();
        stylePanel.setLayout(new BorderLayout());
        Panel sizePanel = new Panel();
        sizePanel.setLayout(new BorderLayout());
        Panel scalePanel = new Panel();
        scalePanel.setLayout(new BorderLayout());
        Panel okCancelPanel = new Panel();
        Panel optionsPanel = new Panel();
        fontPanel.setBackground(Color.white);
        stylePanel.setBackground(Color.white);
        sizePanel.setBackground(Color.white);
        okCancelPanel.setBackground(Color.white);
        optionsPanel.setBackground(Color.white);
        fontPanel.add((Component)fontLabel, "West");
        fontPanel.add((Component)this.fontName, "Center");
        stylePanel.add((Component)styleLabel, "West");
        stylePanel.add((Component)this.fontStyle, "Center");
        sizePanel.add((Component)sizeLabel, "West");
        sizePanel.add((Component)this.fontSize, "Center");
        scalePanel.add((Component)this.scaleAsCdna, "North");
        scalePanel.add((Component)this.fontAsCdna, "South");
        okCancelPanel.add((Component)this.ok, null);
        okCancelPanel.add((Component)this.cancel, null);
        optionsPanel.add((Component)fontPanel, null);
        optionsPanel.add((Component)sizePanel, null);
        optionsPanel.add((Component)stylePanel, null);
        this.add((Component)optionsPanel, "North");
        if (this.ap.alignFrame.getSplitFrame() != null) {
            this.inSplitFrame = true;
            this.oldComplementFont = ((AlignViewport)this.ap.av.getCodingComplement()).getFont();
            this.add((Component)scalePanel, "Center");
        }
        this.add((Component)okCancelPanel, "South");
    }

    protected void scaleAsCdna_actionPerformed() {
        this.ap.av.setScaleProteinAsCdna(this.scaleAsCdna.getState());
        this.ap.av.getCodingComplement().setScaleProteinAsCdna(this.scaleAsCdna.getState());
        this.changeFont();
    }
}

