/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AlignmentUtils;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.Tooltip;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.ParseHtmlBodyAndLinks;
import jalview.util.Platform;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collections;

public class AnnotationLabels
extends Panel
implements ActionListener,
MouseListener,
MouseMotionListener {
    Image image;
    private static final int HEIGHT_ADJUSTER_WIDTH = 50;
    private static int HEIGHT_ADJUSTER_HEIGHT = 10;
    boolean active = false;
    AlignmentPanel ap;
    AlignViewport av;
    boolean resizing = false;
    int oldY;
    int mouseX;
    static String ADDNEW = "Add New Row";
    static String EDITNAME = "Edit Label/Description";
    static String HIDE = "Hide This Row";
    static String SHOWALL = "Show All Hidden Rows";
    static String OUTPUT_TEXT = "Show Values In Textbox";
    static String COPYCONS_SEQ = "Copy Consensus Sequence";
    int scrollOffset = 0;
    int selectedRow = -1;
    Tooltip tooltip;
    private boolean hasHiddenRows;
    boolean resizePanel = false;
    MouseEvent dragEvent = null;
    private boolean dragCancelled = false;

    public AnnotationLabels(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public AnnotationLabels(AlignViewport av) {
        this.av = av;
    }

    public void setScrollOffset(int y, boolean repaint) {
        this.scrollOffset = y;
        if (repaint) {
            this.repaint();
        }
    }

    int getSelectedRow(int y) {
        int row = -2;
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return row;
        }
        int height = 0;
        for (int i = 0; i < aa.length; ++i) {
            row = -1;
            if (!aa[i].visible || y >= (height += aa[i].height)) continue;
            row = i;
            break;
        }
        return row;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (evt.getActionCommand().equals(ADDNEW)) {
            AlignmentAnnotation newAnnotation = new AlignmentAnnotation("", null, new Annotation[this.ap.av.getAlignment().getWidth()]);
            if (!this.editLabelDescription(newAnnotation)) {
                return;
            }
            this.ap.av.getAlignment().addAnnotation(newAnnotation);
            this.ap.av.getAlignment().setAnnotationIndex(newAnnotation, 0);
        } else if (evt.getActionCommand().equals(EDITNAME)) {
            this.editLabelDescription(aa[this.selectedRow]);
        } else if (evt.getActionCommand().equals(HIDE)) {
            aa[this.selectedRow].visible = false;
        } else if (evt.getActionCommand().equals(SHOWALL)) {
            for (int i = 0; i < aa.length; ++i) {
                aa[i].visible = aa[i].annotations != null;
            }
        } else if (evt.getActionCommand().equals(OUTPUT_TEXT)) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this.ap.alignFrame);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, this.ap.alignFrame.getTitle() + " - " + aa[this.selectedRow].label, 500, 100);
            cap.setText(aa[this.selectedRow].toString());
        } else if (evt.getActionCommand().equals(COPYCONS_SEQ)) {
            SequenceI cons;
            SequenceGroup group = aa[this.selectedRow].groupRef;
            SequenceI sequenceI = cons = group == null ? this.av.getConsensusSeq() : group.getConsensusSeq();
            if (cons != null) {
                this.copy_annotseqtoclipboard(cons);
            }
        }
        this.refresh();
    }

    protected void refresh() {
        this.ap.updateAnnotation();
        this.ap.annotationPanel.adjustPanelHeight();
        this.setSize(this.getSize().width, this.ap.annotationPanel.getSize().height);
        this.ap.validate();
        this.ap.paintAlignment(true, true);
    }

    boolean editLabelDescription(AlignmentAnnotation annotation) {
        Checkbox padGaps = new Checkbox("Fill Empty Gaps With \"" + this.ap.av.getGapCharacter() + "\"", annotation.padGaps);
        EditNameDialog dialog = new EditNameDialog(annotation.label, annotation.description, "      Annotation Label", "Annotation Description", this.ap.alignFrame, "Edit Annotation Name / Description", 500, 180, false);
        Panel empty = new Panel(new FlowLayout());
        empty.add(padGaps);
        dialog.add(empty);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.accept) {
            annotation.label = dialog.getName();
            annotation.description = dialog.getDescription();
            annotation.setPadGaps(padGaps.getState(), this.av.getGapCharacter());
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        this.resizePanel = evt.getY() < HEIGHT_ADJUSTER_HEIGHT && evt.getX() < 50;
        this.setCursor(Cursor.getPredefinedCursor(this.resizePanel ? 9 : 0));
        int row = this.getSelectedRow(evt.getY() + this.scrollOffset);
        if (row > -1) {
            ParseHtmlBodyAndLinks phb = new ParseHtmlBodyAndLinks(this.av.getAlignment().getAlignmentAnnotation()[row].getDescription(true), true, "\n");
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(phb.getNonHtmlContent(), this);
            } else {
                this.tooltip.setTip(phb.getNonHtmlContent());
            }
        } else if (this.tooltip != null) {
            this.tooltip.setTip("");
        }
    }

    public void cancelDrag() {
        this.dragEvent = null;
        this.dragCancelled = true;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.dragCancelled) {
            return;
        }
        this.dragEvent = evt;
        if (this.resizePanel) {
            Dimension d = this.ap.annotationPanelHolder.getSize();
            Dimension e = this.ap.annotationSpaceFillerHolder.getSize();
            Dimension f = this.ap.seqPanelHolder.getSize();
            int dif = evt.getY() - this.oldY;
            dif /= this.ap.av.getCharHeight();
            if (d.height - (dif *= this.ap.av.getCharHeight()) > 20 && f.height + dif > 20) {
                this.ap.annotationPanel.setSize(d.width, d.height - dif);
                this.setSize(new Dimension(e.width, d.height - dif));
                this.ap.annotationSpaceFillerHolder.setSize(new Dimension(e.width, d.height - dif));
                this.ap.annotationPanelHolder.setSize(new Dimension(d.width, d.height - dif));
                this.ap.apvscroll.setValues(this.ap.apvscroll.getValue(), d.height - dif, 0, this.av.calcPanelHeight());
                f.height += dif;
                this.ap.seqPanelHolder.setPreferredSize(f);
                this.ap.setScrollValues(this.av.getRanges().getStartRes(), this.av.getRanges().getStartSeq());
                this.ap.validate();
                this.ap.addNotify();
            }
        } else {
            int diff = 6 - evt.getY();
            if (diff > 0) {
                this.ap.apvscroll.setValue(this.ap.apvscroll.getValue() - diff);
                this.ap.adjustmentValueChanged(null);
            } else {
                diff = 6 - this.ap.annotationSpaceFillerHolder.getSize().height + evt.getY();
                if (0 < diff) {
                    this.ap.apvscroll.setValue(this.ap.apvscroll.getValue() + diff);
                    this.ap.adjustmentValueChanged(null);
                }
            }
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!this.resizePanel && !this.dragCancelled) {
            int start = this.selectedRow;
            int end = this.getSelectedRow(evt.getY() + this.scrollOffset);
            if (start > -1 && start != end) {
                AlignmentAnnotation startAA = this.ap.av.getAlignment().getAlignmentAnnotation()[start];
                if (end == -1) {
                    end = this.ap.av.getAlignment().getAlignmentAnnotation().length - 1;
                }
                AlignmentAnnotation endAA = this.ap.av.getAlignment().getAlignmentAnnotation()[end];
                this.ap.av.getAlignment().getAlignmentAnnotation()[end] = startAA;
                this.ap.av.getAlignment().getAlignmentAnnotation()[start] = endAA;
            }
        }
        this.resizePanel = false;
        this.dragEvent = null;
        this.dragCancelled = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.repaint();
        this.ap.annotationPanel.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (evt.getY() < 10 && evt.getX() < 14) {
            this.resizePanel = true;
            this.repaint();
        }
        this.setCursor(Cursor.getPredefinedCursor(this.resizePanel ? 9 : 0));
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.dragCancelled = false;
        if (this.dragEvent == null) {
            this.resizePanel = false;
        } else if (!this.resizePanel) {
            this.dragEvent = null;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.oldY = evt.getY();
        if (this.resizePanel) {
            return;
        }
        this.dragCancelled = false;
        this.selectedRow = this.getSelectedRow(evt.getY() + this.scrollOffset);
        AlignmentAnnotation[] aa = this.ap.av.getAlignment().getAlignmentAnnotation();
        if ((evt.getModifiersEx() & 0x1000) == 4096) {
            PopupMenu popup = new PopupMenu(MessageManager.getString("label.annotations"));
            MenuItem item = new MenuItem(ADDNEW);
            item.addActionListener(this);
            popup.add(item);
            if (this.selectedRow < 0) {
                if (this.hasHiddenRows) {
                    item = new MenuItem(SHOWALL);
                    item.addActionListener(this);
                    popup.add(item);
                }
                this.add(popup);
                popup.show(this, evt.getX(), evt.getY());
                return;
            }
            item = new MenuItem(EDITNAME);
            item.addActionListener(this);
            popup.add(item);
            item = new MenuItem(HIDE);
            item.addActionListener(this);
            popup.add(item);
            if (this.selectedRow < aa.length && aa[this.selectedRow].sequenceRef != null) {
                final String label = aa[this.selectedRow].label;
                MenuItem hideType = new MenuItem(MessageManager.getString("label.hide_all") + " " + label);
                hideType.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AlignmentUtils.showOrHideSequenceAnnotations(AnnotationLabels.this.ap.av.getAlignment(), Collections.singleton(label), null, false, false);
                        AnnotationLabels.this.refresh();
                    }
                });
                popup.add(hideType);
            }
            if (this.hasHiddenRows) {
                item = new MenuItem(SHOWALL);
                item.addActionListener(this);
                popup.add(item);
            }
            this.add(popup);
            item = new MenuItem(OUTPUT_TEXT);
            item.addActionListener(this);
            popup.add(item);
            if (this.selectedRow < aa.length && aa[this.selectedRow].autoCalculated && aa[this.selectedRow].label.indexOf("Consensus") > -1) {
                popup.addSeparator();
                final CheckboxMenuItem cbmi = new CheckboxMenuItem(MessageManager.getString("label.ignore_gaps_consensus"), aa[this.selectedRow].groupRef != null ? aa[this.selectedRow].groupRef.getIgnoreGapsConsensus() : this.ap.av.isIgnoreGapsConsensus());
                final AlignmentAnnotation aaa = aa[this.selectedRow];
                cbmi.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (aaa.groupRef != null) {
                            aaa.groupRef.setIgnoreGapsConsensus(cbmi.getState());
                        } else {
                            AnnotationLabels.this.ap.av.setIgnoreGapsConsensus(cbmi.getState(), AnnotationLabels.this.ap);
                        }
                        AnnotationLabels.this.ap.paintAlignment(true, true);
                    }
                });
                popup.add(cbmi);
                if (aaa.groupRef != null) {
                    final CheckboxMenuItem chist = new CheckboxMenuItem(MessageManager.getString("label.show_group_histogram"), aa[this.selectedRow].groupRef.isShowConsensusHistogram());
                    chist.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            aaa.groupRef.setShowConsensusHistogram(chist.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(chist);
                    final CheckboxMenuItem cprofl = new CheckboxMenuItem(MessageManager.getString("label.show_group_logo"), aa[this.selectedRow].groupRef.isShowSequenceLogo());
                    cprofl.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            aaa.groupRef.setshowSequenceLogo(cprofl.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(cprofl);
                    final CheckboxMenuItem cprofn = new CheckboxMenuItem(MessageManager.getString("label.normalise_group_logo"), aa[this.selectedRow].groupRef.isNormaliseSequenceLogo());
                    cprofn.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            aaa.groupRef.setshowSequenceLogo(true);
                            aaa.groupRef.setNormaliseSequenceLogo(cprofn.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(cprofn);
                } else {
                    final CheckboxMenuItem chist = new CheckboxMenuItem(MessageManager.getString("label.show_histogram"), this.av.isShowConsensusHistogram());
                    chist.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            AnnotationLabels.this.av.setShowConsensusHistogram(chist.getState());
                            AnnotationLabels.this.ap.alignFrame.showConsensusHistogram.setState(chist.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(chist);
                    final CheckboxMenuItem cprof = new CheckboxMenuItem(MessageManager.getString("label.show_logo"), this.av.isShowSequenceLogo());
                    cprof.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            AnnotationLabels.this.av.setShowSequenceLogo(cprof.getState());
                            AnnotationLabels.this.ap.alignFrame.showSequenceLogo.setState(cprof.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(cprof);
                    final CheckboxMenuItem cprofn = new CheckboxMenuItem(MessageManager.getString("label.normalise_logo"), this.av.isNormaliseSequenceLogo());
                    cprofn.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            AnnotationLabels.this.av.setShowSequenceLogo(true);
                            AnnotationLabels.this.ap.alignFrame.normSequenceLogo.setState(cprofn.getState());
                            AnnotationLabels.this.av.setNormaliseSequenceLogo(cprofn.getState());
                            AnnotationLabels.this.ap.repaint();
                        }
                    });
                    popup.add(cprofn);
                }
                item = new MenuItem(COPYCONS_SEQ);
                item.addActionListener(this);
                popup.add(item);
            }
            popup.show(this, evt.getX(), evt.getY());
        } else if (this.selectedRow > -1 && this.selectedRow < aa.length) {
            if (aa[this.selectedRow].groupRef != null) {
                if (evt.getClickCount() >= 2) {
                    this.ap.seqPanel.ap.idPanel.highlightSearchResults(null);
                    SequenceGroup sg = this.ap.av.getSelectionGroup();
                    if (sg == null || sg == aa[this.selectedRow].groupRef || !Platform.isControlDown(evt) && !evt.isShiftDown()) {
                        if (Platform.isControlDown(evt) || evt.isShiftDown()) {
                            this.ap.av.setSelectionGroup(new SequenceGroup(aa[this.selectedRow].groupRef));
                        } else {
                            this.ap.av.setSelectionGroup(aa[this.selectedRow].groupRef);
                        }
                    } else {
                        int remainToAdd = aa[this.selectedRow].groupRef.getSize();
                        for (SequenceI sgs : aa[this.selectedRow].groupRef.getSequences()) {
                            if (Platform.isControlDown(evt)) {
                                sg.addOrRemove(sgs, --remainToAdd == 0);
                                continue;
                            }
                            sg.addSequence(sgs, --remainToAdd == 0);
                        }
                    }
                    this.ap.paintAlignment(false, false);
                    PaintRefresher.Refresh(this.ap, this.ap.av.getSequenceSetId());
                    this.ap.av.sendSelection();
                } else {
                    this.ap.seqPanel.ap.idPanel.highlightSearchResults(aa[this.selectedRow].groupRef.getSequences(null));
                }
                return;
            }
            if (aa[this.selectedRow].sequenceRef != null) {
                if (evt.getClickCount() == 1) {
                    this.ap.seqPanel.ap.idPanel.highlightSearchResults(Arrays.asList(aa[this.selectedRow].sequenceRef));
                } else if (evt.getClickCount() >= 2) {
                    this.ap.seqPanel.ap.idPanel.highlightSearchResults(null);
                    SequenceGroup sg = this.ap.av.getSelectionGroup();
                    if (sg != null) {
                        if (!Platform.isControlDown(evt) && !evt.isShiftDown()) {
                            sg = new SequenceGroup(sg);
                            sg.clear();
                            sg.addSequence(aa[this.selectedRow].sequenceRef, false);
                        } else if (Platform.isControlDown(evt)) {
                            sg.addOrRemove(aa[this.selectedRow].sequenceRef, true);
                        } else {
                            sg.addSequence(aa[this.selectedRow].sequenceRef, true);
                        }
                    } else {
                        sg = new SequenceGroup();
                        sg.setStartRes(0);
                        sg.setEndRes(this.ap.av.getAlignment().getWidth() - 1);
                        sg.addSequence(aa[this.selectedRow].sequenceRef, false);
                    }
                    this.ap.av.setSelectionGroup(sg);
                    this.ap.paintAlignment(false, false);
                    PaintRefresher.Refresh(this.ap, this.ap.av.getSequenceSetId());
                    this.ap.av.sendSelection();
                }
            }
        }
    }

    protected void copy_annotseqtoclipboard(SequenceI sq) {
        if (sq == null || sq.getLength() < 1) {
            return;
        }
        AlignFrame.copiedSequences = new StringBuffer();
        AlignFrame.copiedSequences.append(sq.getName() + "\t" + sq.getStart() + "\t" + sq.getEnd() + "\t" + sq.getSequenceAsString() + "\n");
        if (this.av.hasHiddenColumns()) {
            AlignFrame.copiedHiddenColumns = new HiddenColumns(this.av.getAlignment().getHiddenColumns());
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.image == null || w != this.image.getWidth(this) || h != this.image.getHeight(this)) {
            this.image = this.createImage(w, this.ap.annotationPanel.getSize().height);
        }
        this.drawComponent(this.image.getGraphics(), w);
        g.drawImage(this.image, 0, 0, this);
    }

    public void drawComponent(Graphics g, int width) {
        g.setFont(this.av.getFont());
        FontMetrics fm = g.getFontMetrics(this.av.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.translate(0, -this.scrollOffset);
        g.setColor(Color.black);
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        int y = 0;
        int fy = g.getFont().getSize();
        int x = 0;
        if (aa != null) {
            this.hasHiddenRows = false;
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].visible) {
                    this.hasHiddenRows = true;
                    continue;
                }
                x = width - fm.stringWidth(aa[i].label) - 3;
                int offset = -(aa[i].height - fy) / 2;
                g.drawString(aa[i].label, x, (y += aa[i].height) + offset);
            }
        }
        g.translate(0, this.scrollOffset);
        if (!this.resizePanel && !this.dragCancelled && this.dragEvent != null && aa != null) {
            g.setColor(Color.lightGray);
            g.drawString(aa[this.selectedRow].label, this.dragEvent.getX(), this.dragEvent.getY());
        }
        if (!(this.av.getWrapAlignment() || aa != null && aa.length >= 1)) {
            g.setColor(Color.black);
            g.drawString(MessageManager.getString("label.right_click"), 2, 8);
            g.drawString(MessageManager.getString("label.to_add_annotation"), 2, 18);
        }
    }
}

