/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.util.Platform;

public class ParseProperties {
    private AlignmentI al = null;

    public ParseProperties(AlignmentI al) {
        this.al = al;
    }

    public int getScoresFromDescription(String ScoreName, String ScoreDescriptions, String regex, boolean repeat) {
        return this.getScoresFromDescription(new String[]{ScoreName}, new String[]{ScoreDescriptions}, regex, repeat);
    }

    public int getScoresFromDescription(String[] ScoreNames, String[] ScoreDescriptions, String regex, boolean repeat) {
        return this.getScoresFromDescription(this.al.getSequencesArray(), ScoreNames, ScoreDescriptions, regex, repeat);
    }

    public int getScoresFromDescription(SequenceI[] seqs, String[] ScoreNames, String[] ScoreDescriptions, String regex, boolean repeat) {
        int count = 0;
        Regex pattern = Platform.newRegex(regex);
        if (pattern.numSubs() > ScoreNames.length) {
            int onamelen = ScoreNames.length;
            String[] tnames = new String[pattern.numSubs() + 1];
            System.arraycopy(ScoreNames, 0, tnames, 0, ScoreNames.length);
            String base = tnames[ScoreNames.length - 1];
            ScoreNames = tnames;
            Object descrbase = ScoreDescriptions[onamelen - 1];
            if (descrbase == null) {
                descrbase = "Score parsed from (" + regex + ")";
            }
            tnames = new String[pattern.numSubs() + 1];
            System.arraycopy(ScoreDescriptions, 0, tnames, 0, ScoreDescriptions.length);
            ScoreDescriptions = tnames;
            for (int i = onamelen; i < ScoreNames.length; ++i) {
                ScoreNames[i] = base + "_" + i;
                ScoreDescriptions[i] = (String)descrbase + " (column " + i + ")";
            }
        }
        for (int i = 0; i < seqs.length; ++i) {
            String descr = seqs[i].getDescription();
            if (descr == null) continue;
            int pos = 0;
            boolean added = false;
            int reps = 0;
            while ((repeat || pos == 0) && pattern.searchFrom(descr, pos)) {
                pos = pattern.matchedTo();
                for (int cols = 0; cols < pattern.numSubs(); ++cols) {
                    String sstring = pattern.stringMatched(cols + 1);
                    double score = Double.NaN;
                    try {
                        score = Double.valueOf(sstring);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    AlignmentAnnotation an = new AlignmentAnnotation(ScoreNames[cols] + (String)(reps > 0 ? "_" + reps : ""), ScoreDescriptions[cols], null);
                    an.setScore(score);
                    Console.outPrintln(seqs[i].getName() + " score: '" + ScoreNames[cols] + "' = " + score);
                    an.setSequenceRef(seqs[i]);
                    seqs[i].addAlignmentAnnotation(an);
                    this.al.addAnnotation(an);
                    added = true;
                }
                ++reps;
            }
            if (!added) continue;
            ++count;
        }
        return count;
    }
}

