/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.TreeEngine;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactMatrixI;
import jalview.math.Matrix;
import jalview.viewmodel.AlignmentViewport;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Vector;

public class AverageDistanceEngine
extends TreeEngine {
    ContactMatrixI cm;
    AlignmentViewport av;
    AlignmentAnnotation aa;
    int mode = 1;

    public AverageDistanceEngine(AlignmentViewport av, AlignmentAnnotation aa, ContactMatrixI cm, boolean cosineOrDifference) {
        this.av = av;
        this.aa = aa;
        this.cm = cm;
        this.mode = cosineOrDifference ? 1 : 0;
        this.calculate(cm);
    }

    public void calculate(ContactMatrixI cm) {
        this.cm = cm;
        this.node = new Vector();
        this.clusters = new Vector();
        this.distances = new Matrix(new double[cm.getWidth()][cm.getWidth()]);
        this.noseqs = cm.getWidth();
        this.done = new BitSet();
        double[] moduli = new double[cm.getWidth()];
        double max = this.mode == 0 ? 1.0 : (double)(cm.getMax() * cm.getMax());
        for (int i = 0; i < cm.getWidth(); ++i) {
            ContactListI jth;
            BinaryNode<Integer> cnode = new BinaryNode<Integer>();
            cnode.setElement(i);
            cnode.setName("c" + i);
            this.node.addElement(cnode);
            BitSet bs = new BitSet();
            bs.set(i);
            this.clusters.addElement(bs);
            ContactListI ith = cm.getContactList(i);
            this.distances.setValue(i, i, 0.0);
            if (ith == null) continue;
            for (int j = 0; j < i && (jth = cm.getContactList(j)) != null; ++j) {
                double prd = 0.0;
                for (int indx = 0; indx < cm.getHeight(); ++indx) {
                    if (this.mode == 0) {
                        if (j == 0) {
                            int n = i;
                            moduli[n] = moduli[n] + ith.getContactAt(indx) * ith.getContactAt(indx);
                        }
                        prd += ith.getContactAt(indx) * jth.getContactAt(indx);
                        continue;
                    }
                    prd += Math.abs(ith.getContactAt(indx) - jth.getContactAt(indx));
                }
                if (this.mode == 0) {
                    if (j == 0) {
                        moduli[i] = Math.sqrt(moduli[i]);
                    }
                    prd = moduli[i] != 0.0 && moduli[j] != 0.0 ? prd / (moduli[i] * moduli[j]) : 0.0;
                    prd = 1.0 - prd;
                } else {
                    prd /= (double)cm.getHeight();
                }
                this.distances.setValue(i, j, prd);
                this.distances.setValue(j, i, prd);
            }
        }
        this.noClus = this.clusters.size();
        this.cluster();
    }

    @Override
    protected void findClusterDistance(int i, int j) {
        int noi = ((BitSet)this.clusters.elementAt(i)).cardinality();
        int noj = ((BitSet)this.clusters.elementAt(j)).cardinality();
        double[] newdist = new double[this.noseqs];
        for (int l = 0; l < this.noseqs; ++l) {
            newdist[l] = l != i && l != j ? (this.distances.getValue(i, l) * (double)noi + this.distances.getValue(j, l) * (double)noj) / (double)(noi + noj) : 0.0;
        }
        for (int ii = 0; ii < this.noseqs; ++ii) {
            this.distances.setValue(i, ii, newdist[ii]);
            this.distances.setValue(ii, i, newdist[ii]);
        }
    }

    @Override
    protected double findMinDistance() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.noseqs - 1; ++i) {
            for (int j = i + 1; j < this.noseqs; ++j) {
                if (this.done.get(i) || this.done.get(j) || !(this.distances.getValue(i, j) < min)) continue;
                this.mini = i;
                this.minj = j;
                min = this.distances.getValue(i, j);
            }
        }
        return min;
    }

    @Override
    protected void findNewDistances(BinaryNode nodei, BinaryNode nodej, double dist) {
        double ih = 0.0;
        double jh = 0.0;
        BinaryNode snj = nodej;
        for (BinaryNode sni = nodei; sni != null; sni = sni.left()) {
            ih += sni.dist;
        }
        while (snj != null) {
            jh += snj.dist;
            snj = snj.left();
        }
        nodei.dist = dist / 2.0 - ih;
        nodej.dist = dist / 2.0 - jh;
    }

    public List<BinaryNode> groupNodes(float threshold) {
        ArrayList<BinaryNode> groups = new ArrayList<BinaryNode>();
        this._groupNodes(groups, this.getTopNode(), threshold);
        return groups;
    }

    protected void _groupNodes(List<BinaryNode> groups, BinaryNode nd, float threshold) {
        if (nd == null) {
            return;
        }
        if (nd.height / this.maxheight > (double)threshold) {
            groups.add(nd);
        } else {
            this._groupNodes(groups, nd.left(), threshold);
            this._groupNodes(groups, nd.right(), threshold);
        }
    }

    @Override
    public double findHeight(BinaryNode nd) {
        if (nd == null) {
            return this.maxheight;
        }
        if (nd.left() == null && nd.right() == null) {
            nd.height = nd.parent().height + nd.dist;
            if (nd.height > this.maxheight) {
                return nd.height;
            }
            return this.maxheight;
        }
        if (nd.parent() != null) {
            nd.height = nd.parent().height + nd.dist;
        } else {
            this.maxheight = 0.0;
            nd.height = 0.0;
        }
        this.maxheight = this.findHeight(nd.left());
        this.maxheight = this.findHeight(nd.right());
        return this.maxheight;
    }

    public Vector<BinaryNode> findLeaves(BinaryNode top2) {
        Vector<BinaryNode> leaves = new Vector<BinaryNode>();
        this.findLeaves(top2, leaves);
        return leaves;
    }

    Vector<BinaryNode> findLeaves(BinaryNode nd, Vector<BinaryNode> leaves) {
        if (nd == null) {
            return leaves;
        }
        if (nd.left() == null && nd.right() == null) {
            leaves.addElement(nd);
            return leaves;
        }
        this.findLeaves(nd.left(), leaves);
        this.findLeaves(nd.right(), leaves);
        return leaves;
    }
}

