/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public final class ClustalAlignmentUtil {
    private static final Logger log = Logger.getLogger(ClustalAlignmentUtil.class.getCanonicalName());
    public static final char gapchar = '-';
    private static final String spacer = "      ";
    private static final int maxNameLength = 30;
    private static final int minNameHolderLength = 10;
    private static final int oneLineAlignmentLength = 60;

    public static Alignment readClustalFile(InputStream instream) throws IOException, UnknownFileFormatException {
        String line;
        boolean flag = false;
        ArrayList<String> headers = new ArrayList<String>();
        HashMap<String, StringBuffer> seqhash = new HashMap<String, StringBuffer>();
        FastaSequence[] seqs = null;
        BufferedReader breader = new BufferedReader(new InputStreamReader(instream));
        while ((line = breader.readLine()) != null) {
            StringBuffer tempseq;
            if (line.indexOf(" ") == 0) continue;
            StringTokenizer str = new StringTokenizer(line, " ");
            String id = "";
            if (!str.hasMoreTokens()) continue;
            id = str.nextToken();
            if (id.equals("CLUSTAL") || id.equals("PROBCONS") || id.equals("MSAPROBS")) {
                flag = true;
                continue;
            }
            if (!flag) continue;
            if (seqhash.containsKey(id)) {
                tempseq = (StringBuffer)seqhash.get(id);
            } else {
                tempseq = new StringBuffer();
                seqhash.put(id, tempseq);
            }
            if (!headers.contains(id)) {
                headers.add(id);
            }
            tempseq.append(str.nextToken());
        }
        breader.close();
        if (flag) {
            seqs = new FastaSequence[headers.size()];
            for (int i = 0; i < headers.size(); ++i) {
                FastaSequence newSeq;
                if (seqhash.get(headers.get(i)) == null) {
                    throw new AssertionError((Object)("Bizarreness! Can't find sequence for " + (String)headers.get(i)));
                }
                seqs[i] = newSeq = new FastaSequence((String)headers.get(i), ((StringBuffer)seqhash.get(headers.get(i))).toString());
            }
        }
        if (seqs == null || seqs.length == 0) {
            throw new UnknownFileFormatException("Input does not appear to be a clustal file! ");
        }
        return new Alignment(Arrays.asList(seqs), new AlignmentMetadata(Program.CLUSTAL, '-'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidClustalFile(InputStream input) {
        if (input == null) {
            throw new NullPointerException("Input is expected!");
        }
        BufferedReader breader = new BufferedReader(new InputStreamReader(input));
        try {
            if (input.available() < 10) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < 10; ++i) {
                String line = breader.readLine();
                if (line == null || !(line = line.toUpperCase().trim()).contains("CLUSTAL") && !line.contains("PROBCONS")) continue;
                boolean bl = true;
                return bl;
            }
            breader.close();
        }
        catch (IOException e) {
            log.severe("Could not read from the stream! " + e.getLocalizedMessage() + e.getCause());
        }
        finally {
            SequenceUtil.closeSilently(log, breader);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClustalAlignment(Writer out, Alignment alignment) throws IOException {
        List<FastaSequence> seqs = alignment.getSequences();
        out.write("CLUSTAL\n\n\n");
        int max = 0;
        int maxidLength = 0;
        int i = 0;
        for (FastaSequence fs : seqs) {
            String tmp = fs.getId();
            if (fs.getSequence().length() > max) {
                max = fs.getSequence().length();
            }
            if (tmp.length() > maxidLength) {
                maxidLength = tmp.length();
            }
            ++i;
        }
        if (maxidLength < 10) {
            maxidLength = 10;
        }
        if (maxidLength > 30) {
            maxidLength = 30;
        }
        int oneLineAlignmentLength = 60;
        int nochunks = max / oneLineAlignmentLength + 1;
        for (i = 0; i < nochunks; ++i) {
            int j = 0;
            for (FastaSequence fs : seqs) {
                String name = fs.getId();
                out.write(String.format("%-" + maxidLength + "s" + spacer, name.length() > 30 ? name.substring(0, maxidLength) : name));
                int start = i * oneLineAlignmentLength;
                int end = start + oneLineAlignmentLength;
                if (end < fs.getSequence().length() && start < fs.getSequence().length()) {
                    out.write(fs.getSequence().substring(start, end) + "\n");
                } else if (start < fs.getSequence().length()) {
                    out.write(fs.getSequence().substring(start) + "\n");
                }
                ++j;
            }
            out.write("\n");
        }
        try {
            out.close();
        }
        finally {
            SequenceUtil.closeSilently(log, out);
        }
    }

    public static Alignment readClustalFile(File file) throws UnknownFileFormatException, IOException {
        if (file == null) {
            throw new NullPointerException("File is expected!");
        }
        FileInputStream fio = new FileInputStream(file);
        Alignment seqAl = ClustalAlignmentUtil.readClustalFile(fio);
        try {
            fio.close();
        }
        finally {
            SequenceUtil.closeSilently(log, fio);
        }
        return seqAl;
    }
}

