/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.components;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurScriptParser;
import fr.orsay.lri.varna.models.VARNAConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class VARNAConsole
extends JFrame
implements ActionListener,
FocusListener,
KeyListener {
    private VARNAPanel _vp;
    private JButton _quitButton;
    private JPanel _contentPanel;
    private JPanel _quitPanel;
    private JTextField _input;
    private JEditorPane _output;
    private JScrollPane _scrolls;
    private boolean _firstFocus = true;

    public VARNAConsole(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this.init();
    }

    private void init() {
        this._quitButton = new JButton("Exit");
        this._quitPanel = new JPanel();
        this._contentPanel = new JPanel();
        this._input = new JTextField("Your command here...");
        this._output = new JEditorPane();
        this._scrolls = new JScrollPane(this._output);
        this._input.addFocusListener(this);
        this._input.addKeyListener(this);
        this._output.setText(VARNAConfig.getFullName() + " console\n");
        this._output.setPreferredSize(new Dimension(500, 300));
        this._output.setEditable(false);
        this._quitPanel.add(this._quitButton);
        this._quitButton.addActionListener(this);
        this._contentPanel.setLayout(new BorderLayout());
        this._contentPanel.add((Component)this._scrolls, "Center");
        this._contentPanel.add((Component)this._input, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._contentPanel, "Center");
        this.getContentPane().add((Component)this._quitPanel, "South");
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this._firstFocus) {
            this._input.setSelectionStart(0);
            this._input.setSelectionEnd(this._input.getText().length());
            this._firstFocus = false;
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            try {
                ControleurScriptParser.executeScript(this._vp, this._input.getText());
            }
            catch (Exception exception) {
                this._output.setText(this._output.getText() + exception.getMessage() + '\n');
                exception.printStackTrace();
            }
        }
    }
}

