/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import uk.ac.vamsas.client.simpleclient.VamsasArchiveReader;
import uk.ac.vamsas.client.simpleclient.VamsasFile;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;

public class ArchiveStreamReader {
    public static void main(String[] args) {
        try {
            VamsasFile av = new VamsasFile(new File(args[0]));
            VamsasArchiveReader var = new VamsasArchiveReader(av.getLock());
            VAMSAS[] roots = null;
            if (var.isValid()) {
                InputStreamReader vdoc = new InputStreamReader(var.getVamsasDocumentStream());
                VamsasDocument doc = VamsasDocument.unmarshal(vdoc);
                if (ArchiveReports.reportDocument(doc, var, true, System.out)) {
                    roots = doc.getVAMSAS();
                }
            } else {
                BufferedInputStream ixml;
                InputStreamReader vxml;
                VAMSAS root;
                InputStream vxmlis = var.getVamsasXmlStream();
                if (vxmlis != null && (root = VAMSAS.unmarshal(vxml = new InputStreamReader(ixml = new BufferedInputStream(var.getVamsasXmlStream())))) != null) {
                    System.out.println("Read a root.");
                    roots = new VAMSAS[]{root};
                }
            }
            if (!ArchiveReports.rootReport(roots, true, System.out)) {
                System.err.print(args[0] + " is not a valid vamsas archive.");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

