/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpClient;
import io.github.warownia1.simplehttpclient.HttpHeaders;
import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.HttpResponse;
import io.github.warownia1.simplehttpclient.impl.ResponseInfoImpl;
import io.github.warownia1.simplehttpclient.impl.SimpleHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

public class SimpleHttpClient
implements HttpClient {
    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> handler) throws IOException {
        URI uri;
        HttpURLConnection conn = (HttpURLConnection)request.uri().toURL().openConnection();
        if (!request.method().equals("HEAD")) {
            conn.setDoInput(true);
        }
        conn.setRequestMethod(request.method());
        request.headers().map().forEach((header, values) -> {
            for (String value : values) {
                conn.addRequestProperty((String)header, value);
            }
        });
        if (request.body().isPresent() && request.body().get().contentLength() != 0L) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Length", Long.toString(request.body().get().contentLength()));
        } else {
            conn.setRequestProperty("Content-Length", "0");
        }
        if (request.timeout().isPresent()) {
            int timeoutMillis = (int)Math.min(request.timeout().get().toMillis(), Integer.MAX_VALUE);
            conn.setConnectTimeout(timeoutMillis);
            conn.setReadTimeout(timeoutMillis);
        }
        conn.connect();
        if (conn.getDoOutput()) {
            HttpRequest.Body body = request.body().get();
            OutputStream os = conn.getOutputStream();
            os.write(body.getBytes());
        }
        int statusCode = conn.getResponseCode();
        LinkedHashMap<String, List<String>> headersMap = new LinkedHashMap<String, List<String>>(conn.getHeaderFields());
        headersMap.remove(null);
        HttpHeaders headers = HttpHeaders.of(headersMap);
        ResponseInfoImpl responseInfo = new ResponseInfoImpl(statusCode, headers, HttpClient.Version.HTTP_1_1);
        InputStream inputStream = statusCode < 400 ? conn.getInputStream() : conn.getErrorStream();
        T body = handler.apply(responseInfo, inputStream);
        try {
            uri = conn.getURL().toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            uri = request.uri();
        }
        return new SimpleHttpResponse<T>(statusCode, request, headers, body, uri);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler, Executor executor) {
        Supplier<HttpResponse> supplier = () -> {
            try {
                return this.send(request, handler);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        };
        return CompletableFuture.supplyAsync(supplier, executor);
    }
}

