/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FormatAdapter;
import jalview.ws.params.OptionI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.Option;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class Alignment
extends InputType {
    FileFormatI format = FileFormat.Fasta;
    InputType.molType type;
    boolean jvsuffix = false;
    public boolean writeAsFile = false;

    public Alignment() {
        super(new Class[]{AlignmentI.class});
    }

    @Override
    public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException {
        AlignmentI alignment = rj.getAlignmentForInput(this.token, this.type);
        if (this.writeAsFile) {
            try {
                File fa = File.createTempFile("jvmime", ".fa");
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(fa)), "UTF-8"));
                pw.append(new FormatAdapter().formatSequences(this.format, alignment, this.jvsuffix));
                pw.close();
                return new FileBody(fa, "text/plain");
            }
            catch (Exception ex) {
                throw new NoValidInputDataException("Couldn't write out alignment to file.", ex);
            }
        }
        FormatAdapter fa = new FormatAdapter();
        fa.setNewlineString("\r\n");
        return new StringBody(fa.formatSequences(this.format, alignment, this.jvsuffix));
    }

    @Override
    public List<String> getURLEncodedParameter() {
        ArrayList<String> prms = new ArrayList<String>();
        prms.add("format='" + this.format.getName() + "'");
        if (this.type != null) {
            prms.add("type='" + this.type.toString() + "'");
        }
        if (this.jvsuffix) {
            prms.add("jvsuffix");
        }
        if (this.writeAsFile) {
            prms.add("writeasfile");
        }
        return prms;
    }

    @Override
    public String getURLtokenPrefix() {
        return "ALIGNMENT";
    }

    @Override
    public boolean configureProperty(String tok, String val, StringBuffer warnings) {
        if (tok.startsWith("jvsuffix")) {
            this.jvsuffix = true;
            return true;
        }
        if (tok.startsWith("writeasfile")) {
            this.writeAsFile = true;
            return true;
        }
        if (tok.startsWith("format")) {
            for (FileFormatI fileFormatI : FileFormats.getInstance().getFormats()) {
                if (!fileFormatI.isWritable() || !val.equalsIgnoreCase(fileFormatI.getName())) continue;
                this.format = fileFormatI;
                return true;
            }
            warnings.append("Invalid alignment format '" + val + "'. Must be one of (");
            for (String string : FileFormats.getInstance().getWritableFormats(true)) {
                warnings.append(" ").append(string);
            }
            warnings.append(")\n");
        }
        if (tok.startsWith("type")) {
            try {
                this.type = InputType.molType.valueOf(val);
                return true;
            }
            catch (Exception x) {
                warnings.append("Invalid molecule type '" + val + "'. Must be one of (");
                for (InputType.molType v : InputType.molType.values()) {
                    warnings.append(" " + v);
                }
                warnings.append(")\n");
            }
        }
        return false;
    }

    @Override
    public List<OptionI> getOptions() {
        List<OptionI> lst = this.getBaseOptions();
        lst.add(new BooleanOption("jvsuffix", "Append jalview style /start-end suffix to ID", false, (Boolean)false, (Boolean)this.jvsuffix, null));
        lst.add(new BooleanOption("writeasfile", "Append jalview style /start-end suffix to ID", false, (Boolean)false, (Boolean)this.writeAsFile, null));
        List<String> writable = FileFormats.getInstance().getWritableFormats(true);
        lst.add(new Option("format", "Alignment upload format", true, FileFormat.Fasta.toString(), this.format.getName(), writable, null));
        lst.add(this.createMolTypeOption("type", "Sequence type", false, this.type, null));
        return lst;
    }
}

