/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingsI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.ComplexAlignFile;
import jalview.api.FeatureRenderer;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.bin.BuildDetails;
import jalview.datamodel.AlignExportSettingsAdapter;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.PDBFeatureSettings;
import jalview.json.binding.biojson.v1.AlignmentAnnotationPojo;
import jalview.json.binding.biojson.v1.AlignmentPojo;
import jalview.json.binding.biojson.v1.AnnotationDisplaySettingPojo;
import jalview.json.binding.biojson.v1.AnnotationPojo;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.json.binding.biojson.v1.SequenceFeaturesPojo;
import jalview.json.binding.biojson.v1.SequenceGrpPojo;
import jalview.json.binding.biojson.v1.SequencePojo;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.JalviewColourScheme;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.JSONUtils;
import jalview.viewmodel.seqfeatures.FeaturesDisplayed;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class JSONFile
extends AlignFile
implements ComplexAlignFile {
    private static String version = new BuildDetails().getVersion();
    private String webstartUrl = "https://www.jalview.org/services/launchApp";
    private String application = "Jalview";
    private String globalColourScheme;
    private boolean showSeqFeatures;
    private Hashtable<String, Sequence> seqMap;
    private FeaturesDisplayedI displayedFeatures;
    private FeatureRenderer fr;
    private HiddenColumns hiddenColumns;
    private List<String> hiddenSeqRefs;
    private ArrayList<SequenceI> hiddenSequences;
    private static final String TCOFFEE_SCORE = "TCoffeeScore";

    public JSONFile() {
    }

    public JSONFile(FileParse source) throws IOException {
        super(source);
    }

    public JSONFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    @Override
    public void parse() throws IOException {
        this.parse(this.getReader());
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        String jsonOutput = null;
        try {
            AlignmentPojo jsonAlignmentPojo = new AlignmentPojo();
            AlignExportSettingsI exportSettings = this.getExportSettings();
            if (exportSettings == null) {
                exportSettings = new AlignExportSettingsAdapter(true);
            }
            int count = 0;
            for (SequenceI seq : sqs) {
                StringBuilder name = new StringBuilder();
                name.append(seq.getName()).append("/").append(seq.getStart()).append("-").append(seq.getEnd());
                SequencePojo jsonSeqPojo = new SequencePojo();
                jsonSeqPojo.setId(String.valueOf(seq.hashCode()));
                jsonSeqPojo.setOrder(++count);
                jsonSeqPojo.setEnd(seq.getEnd());
                jsonSeqPojo.setStart(seq.getStart());
                jsonSeqPojo.setName(name.toString());
                jsonSeqPojo.setSeq(seq.getSequenceAsString());
                jsonAlignmentPojo.getSeqs().add(jsonSeqPojo);
            }
            jsonAlignmentPojo.setGlobalColorScheme(this.globalColourScheme);
            jsonAlignmentPojo.getAppSettings().put("application", this.application);
            jsonAlignmentPojo.getAppSettings().put("version", version);
            jsonAlignmentPojo.getAppSettings().put("webStartUrl", this.webstartUrl);
            jsonAlignmentPojo.getAppSettings().put("showSeqFeatures", String.valueOf(this.showSeqFeatures));
            String[] hiddenSections = this.getHiddenSections();
            if (hiddenSections != null) {
                if (hiddenSections[0] != null && exportSettings.isExportHiddenColumns()) {
                    jsonAlignmentPojo.getAppSettings().put("hiddenCols", String.valueOf(hiddenSections[0]));
                }
                if (hiddenSections[1] != null && exportSettings.isExportHiddenSequences()) {
                    jsonAlignmentPojo.getAppSettings().put("hiddenSeqs", String.valueOf(hiddenSections[1]));
                }
            }
            if (exportSettings.isExportAnnotations()) {
                jsonAlignmentPojo.setAlignAnnotation(JSONFile.annotationToJsonPojo(this.annotations));
            } else if (this.globalColourScheme.equalsIgnoreCase(JalviewColourScheme.RNAHelices.toString()) || this.globalColourScheme.equalsIgnoreCase(JalviewColourScheme.TCoffee.toString())) {
                jsonAlignmentPojo.setGlobalColorScheme("None");
            }
            if (exportSettings.isExportFeatures()) {
                jsonAlignmentPojo.setSeqFeatures(this.sequenceFeatureToJsonPojo(sqs));
            }
            if (exportSettings.isExportGroups() && this.seqGroups != null && this.seqGroups.size() > 0) {
                for (SequenceGroup seqGrp : this.seqGroups) {
                    SequenceGrpPojo seqGrpPojo = new SequenceGrpPojo();
                    seqGrpPojo.setGroupName(seqGrp.getName());
                    seqGrpPojo.setColourScheme(ColourSchemeProperty.getColourName(seqGrp.getColourScheme()));
                    seqGrpPojo.setColourText(seqGrp.getColourText());
                    seqGrpPojo.setDescription(seqGrp.getDescription());
                    seqGrpPojo.setDisplayBoxes(seqGrp.getDisplayBoxes());
                    seqGrpPojo.setDisplayText(seqGrp.getDisplayText());
                    seqGrpPojo.setEndRes(seqGrp.getEndRes());
                    seqGrpPojo.setStartRes(seqGrp.getStartRes());
                    seqGrpPojo.setShowNonconserved(seqGrp.getShowNonconserved());
                    for (SequenceI seq : seqGrp.getSequences()) {
                        seqGrpPojo.getSequenceRefs().add(String.valueOf(seq.hashCode()));
                    }
                    jsonAlignmentPojo.getSeqGroups().add(seqGrpPojo);
                }
            }
            jsonOutput = JSONUtils.stringify(jsonAlignmentPojo);
            return jsonOutput.replaceAll("xstart", "xStart").replaceAll("xend", "xEnd");
        }
        catch (Exception e) {
            e.printStackTrace();
            return jsonOutput;
        }
    }

    public String[] getHiddenSections() {
        HiddenSequences hiddenSeqsObj;
        String[] hiddenSections = new String[2];
        if (this.getViewport() == null) {
            return null;
        }
        if (this.getViewport().hasHiddenColumns()) {
            hiddenSections[0] = this.getViewport().getAlignment().getHiddenColumns().regionsToString(";", "-");
        }
        if ((hiddenSeqsObj = this.getViewport().getAlignment().getHiddenSequences()) == null || hiddenSeqsObj.hiddenSequences == null) {
            return hiddenSections;
        }
        SequenceI[] hiddenSeqs = hiddenSeqsObj.hiddenSequences;
        StringBuilder hiddenSeqsBuilder = new StringBuilder();
        for (SequenceI hiddenSeq : hiddenSeqs) {
            if (hiddenSeq == null) continue;
            hiddenSeqsBuilder.append(";").append(hiddenSeq.hashCode());
        }
        if (hiddenSeqsBuilder.length() > 0) {
            hiddenSeqsBuilder.deleteCharAt(0);
        }
        hiddenSections[1] = hiddenSeqsBuilder.toString();
        return hiddenSections;
    }

    protected List<SequenceFeaturesPojo> sequenceFeatureToJsonPojo(SequenceI[] sqs) {
        this.displayedFeatures = this.fr == null ? null : this.fr.getFeaturesDisplayed();
        ArrayList<SequenceFeaturesPojo> sequenceFeaturesPojo = new ArrayList<SequenceFeaturesPojo>();
        if (sqs == null) {
            return sequenceFeaturesPojo;
        }
        FeatureColourFinder finder = new FeatureColourFinder(this.fr);
        String[] visibleFeatureTypes = this.displayedFeatures == null ? null : this.displayedFeatures.getVisibleFeatures().toArray(new String[this.displayedFeatures.getVisibleFeatureCount()]);
        for (SequenceI seq : sqs) {
            List<SequenceFeature> seqFeatures = seq.getFeatures().getAllFeatures(visibleFeatureTypes);
            for (SequenceFeature sf : seqFeatures) {
                SequenceFeaturesPojo jsonFeature = new SequenceFeaturesPojo(String.valueOf(seq.hashCode()));
                String featureColour = this.fr == null ? null : Format.getHexString(finder.findFeatureColour(Color.white, seq, seq.findIndex(sf.getBegin())));
                int xStart = sf.getBegin() == 0 ? 0 : seq.findIndex(sf.getBegin()) - 1;
                int xEnd = sf.getEnd() == 0 ? 0 : seq.findIndex(sf.getEnd());
                jsonFeature.setXstart(xStart);
                jsonFeature.setXend(xEnd);
                jsonFeature.setType(sf.getType());
                jsonFeature.setDescription(sf.getDescription());
                jsonFeature.setLinks(sf.links);
                jsonFeature.setOtherDetails(sf.otherDetails);
                jsonFeature.setScore(Float.valueOf(sf.getScore()));
                jsonFeature.setFillColor(featureColour);
                jsonFeature.setFeatureGroup(sf.getFeatureGroup());
                sequenceFeaturesPojo.add(jsonFeature);
            }
        }
        return sequenceFeaturesPojo;
    }

    public static List<AlignmentAnnotationPojo> annotationToJsonPojo(Vector<AlignmentAnnotation> annotations) {
        ArrayList<AlignmentAnnotationPojo> jsonAnnotations = new ArrayList<AlignmentAnnotationPojo>();
        if (annotations == null) {
            return jsonAnnotations;
        }
        for (AlignmentAnnotation annot : annotations) {
            AlignmentAnnotationPojo alignAnnotPojo = new AlignmentAnnotationPojo();
            alignAnnotPojo.setDescription(annot.description);
            alignAnnotPojo.setLabel(annot.label);
            if (!Double.isNaN(annot.score)) {
                alignAnnotPojo.setScore(annot.score);
            }
            alignAnnotPojo.setCalcId(annot.getCalcId());
            alignAnnotPojo.setGraphType(annot.graph);
            AnnotationDisplaySettingPojo annotSetting = new AnnotationDisplaySettingPojo();
            annotSetting.setBelowAlignment(annot.belowAlignment);
            annotSetting.setCentreColLabels(annot.centreColLabels);
            annotSetting.setScaleColLabel(annot.scaleColLabel);
            annotSetting.setShowAllColLabels(annot.showAllColLabels);
            annotSetting.setVisible(annot.visible);
            annotSetting.setHasIcon(annot.hasIcons);
            alignAnnotPojo.setAnnotationSettings(annotSetting);
            SequenceI refSeq = annot.sequenceRef;
            if (refSeq != null) {
                alignAnnotPojo.setSequenceRef(String.valueOf(refSeq.hashCode()));
            }
            for (Annotation annotation : annot.annotations) {
                AnnotationPojo annotationPojo = new AnnotationPojo();
                if (annotation != null) {
                    annotationPojo.setDescription(annotation.description);
                    annotationPojo.setValue(annotation.value);
                    annotationPojo.setSecondaryStructure(annotation.secondaryStructure);
                    String displayChar = annotation.displayCharacter == null ? null : annotation.displayCharacter;
                    annotationPojo.setDisplayCharacter(displayChar);
                    if (annotation.colour != null) {
                        annotationPojo.setColour(Format.getHexString(annotation.colour));
                    }
                    alignAnnotPojo.getAnnotations().add(annotationPojo);
                    continue;
                }
                if (annot.getCalcId() != null && annot.getCalcId().equalsIgnoreCase(TCOFFEE_SCORE)) continue;
                alignAnnotPojo.getAnnotations().add(annotationPojo);
            }
            jsonAnnotations.add(alignAnnotPojo);
        }
        return jsonAnnotations;
    }

    public JSONFile parse(Reader jsonAlignmentString) {
        try {
            Map alignmentJsonObj = (Map)JSONUtils.parse(jsonAlignmentString);
            List seqJsonArray = (List)alignmentJsonObj.get("seqs");
            List alAnnotJsonArray = (List)alignmentJsonObj.get("alignAnnotation");
            List jsonSeqArray = (List)alignmentJsonObj.get("seqFeatures");
            List seqGrpJsonArray = (List)alignmentJsonObj.get("seqGroups");
            Map jvSettingsJsonObj = (Map)alignmentJsonObj.get("appSettings");
            if (jvSettingsJsonObj != null) {
                this.globalColourScheme = (String)jvSettingsJsonObj.get("globalColorScheme");
                Boolean showFeatures = Boolean.valueOf(jvSettingsJsonObj.get("showSeqFeatures").toString());
                this.setShowSeqFeatures(showFeatures);
                this.parseHiddenSeqRefsAsList(jvSettingsJsonObj);
                this.parseHiddenCols(jvSettingsJsonObj);
            }
            this.hiddenSequences = new ArrayList();
            this.seqMap = new Hashtable();
            for (Map sequence : seqJsonArray) {
                String sequcenceString = sequence.get("seq").toString();
                String sequenceName = sequence.get("name").toString();
                String seqUniqueId = sequence.get("id").toString();
                int start = Integer.valueOf(sequence.get("start").toString());
                int end = Integer.valueOf(sequence.get("end").toString());
                Sequence seq = new Sequence(sequenceName, sequcenceString, start, end);
                if (this.hiddenSeqRefs != null && this.hiddenSeqRefs.contains(seqUniqueId)) {
                    this.hiddenSequences.add(seq);
                }
                this.seqs.add(seq);
                this.seqMap.put(seqUniqueId, seq);
            }
            this.parseFeatures(jsonSeqArray);
            for (Map seqGrpObj : seqGrpJsonArray) {
                String grpName = seqGrpObj.get("groupName").toString();
                String colourScheme = seqGrpObj.get("colourScheme").toString();
                String description = seqGrpObj.get("description") == null ? null : seqGrpObj.get("description").toString();
                boolean displayBoxes = Boolean.valueOf(seqGrpObj.get("displayBoxes").toString());
                boolean displayText = Boolean.valueOf(seqGrpObj.get("displayText").toString());
                boolean colourText = Boolean.valueOf(seqGrpObj.get("colourText").toString());
                boolean showNonconserved = Boolean.valueOf(seqGrpObj.get("showNonconserved").toString());
                int startRes = Integer.valueOf(seqGrpObj.get("startRes").toString());
                int endRes = Integer.valueOf(seqGrpObj.get("endRes").toString());
                List sequenceRefs = (List)seqGrpObj.get("sequenceRefs");
                ArrayList<SequenceI> grpSeqs = new ArrayList<SequenceI>();
                if (sequenceRefs.size() > 0) {
                    Iterator seqHashIter = sequenceRefs.iterator();
                    while (seqHashIter.hasNext()) {
                        Sequence sequence = this.seqMap.get(seqHashIter.next());
                        if (sequence == null) continue;
                        grpSeqs.add(sequence);
                    }
                }
                SequenceGroup seqGrp = new SequenceGroup(grpSeqs, grpName, null, displayBoxes, displayText, colourText, startRes, endRes);
                seqGrp.setColourScheme(ColourSchemeMapper.getJalviewColourScheme(colourScheme, seqGrp));
                seqGrp.setShowNonconserved(showNonconserved);
                seqGrp.setDescription(description);
                this.seqGroups.add(seqGrp);
            }
            for (Map alAnnot : alAnnotJsonArray) {
                Sequence sequence;
                List annotJsonArray = (List)alAnnot.get("annotations");
                Annotation[] annotations = new Annotation[annotJsonArray.size()];
                int count = 0;
                for (Map annot : annotJsonArray) {
                    if (annot == null) {
                        annotations[count] = null;
                    } else {
                        float val = (annot.get("value") == null ? null : Float.valueOf(annot.get("value").toString())).floatValue();
                        String desc = annot.get("description") == null ? null : annot.get("description").toString();
                        char ss = annot.get("secondaryStructure") == null || annot.get("secondaryStructure").toString().equalsIgnoreCase("u0000") ? (char)' ' : (char)annot.get("secondaryStructure").toString().charAt(0);
                        String displayChar = annot.get("displayCharacter") == null ? "" : annot.get("displayCharacter").toString();
                        annotations[count] = new Annotation(displayChar, desc, ss, val);
                        if (annot.get("colour") != null) {
                            Color color;
                            annotations[count].colour = color = ColorUtils.parseColourString(annot.get("colour").toString());
                        }
                    }
                    ++count;
                }
                AlignmentAnnotation alignAnnot = new AlignmentAnnotation(alAnnot.get("label").toString(), alAnnot.get("description").toString(), annotations);
                alignAnnot.graph = alAnnot.get("graphType") == null ? 0 : Integer.valueOf(alAnnot.get("graphType").toString());
                Map diplaySettings = (Map)alAnnot.get("annotationSettings");
                if (diplaySettings != null) {
                    alignAnnot.scaleColLabel = diplaySettings.get("scaleColLabel") == null ? false : Boolean.valueOf(diplaySettings.get("scaleColLabel").toString());
                    alignAnnot.showAllColLabels = diplaySettings.get("showAllColLabels") == null ? true : Boolean.valueOf(diplaySettings.get("showAllColLabels").toString());
                    alignAnnot.centreColLabels = diplaySettings.get("centreColLabels") == null ? true : Boolean.valueOf(diplaySettings.get("centreColLabels").toString());
                    alignAnnot.belowAlignment = diplaySettings.get("belowAlignment") == null ? false : Boolean.valueOf(diplaySettings.get("belowAlignment").toString());
                    alignAnnot.visible = diplaySettings.get("visible") == null ? true : Boolean.valueOf(diplaySettings.get("visible").toString());
                    boolean bl = alignAnnot.hasIcons = diplaySettings.get("hasIcon") == null ? true : Boolean.valueOf(diplaySettings.get("hasIcon").toString());
                }
                if (alAnnot.get("score") != null) {
                    alignAnnot.score = Double.valueOf(alAnnot.get("score").toString());
                }
                String calcId = alAnnot.get("calcId") == null ? "" : alAnnot.get("calcId").toString();
                alignAnnot.setCalcId(calcId);
                String seqHash = alAnnot.get("sequenceRef") != null ? alAnnot.get("sequenceRef").toString() : null;
                Sequence sequence2 = sequence = seqHash != null ? this.seqMap.get(seqHash) : null;
                if (sequence != null) {
                    alignAnnot.sequenceRef = sequence;
                    sequence.addAlignmentAnnotation(alignAnnot);
                    if (alignAnnot.label.equalsIgnoreCase("T-COFFEE")) {
                        alignAnnot.createSequenceMapping(sequence, sequence.getStart(), false);
                        sequence.addAlignmentAnnotation(alignAnnot);
                        alignAnnot.adjustForAlignment();
                    }
                }
                alignAnnot.validateRangeAndDisplay();
                this.annotations.add(alignAnnot);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void parseHiddenSeqRefsAsList(Map<String, Object> jvSettingsJson) {
        this.hiddenSeqRefs = new ArrayList<String>();
        String hiddenSeqs = (String)jvSettingsJson.get("hiddenSeqs");
        if (hiddenSeqs != null && !hiddenSeqs.isEmpty()) {
            String[] seqRefs = hiddenSeqs.split(";");
            int n = seqRefs.length;
            for (int i = 0; i < n; ++i) {
                this.hiddenSeqRefs.add(seqRefs[i]);
            }
        }
    }

    public void parseHiddenCols(Map<String, Object> jvSettingsJson) {
        String hiddenCols = (String)jvSettingsJson.get("hiddenCols");
        if (hiddenCols != null && !hiddenCols.isEmpty()) {
            this.hiddenColumns = new HiddenColumns();
            String[] rangeStrings = hiddenCols.split(";");
            int n = rangeStrings.length;
            for (int i = 0; i < n; ++i) {
                String[] range = rangeStrings[i].split("-");
                this.hiddenColumns.hideColumns(Integer.valueOf(range[0]), Integer.valueOf(range[1]));
            }
        }
    }

    private void parseFeatures(List<Object> jsonSeqFeatures) {
        if (jsonSeqFeatures != null) {
            this.displayedFeatures = new FeaturesDisplayed();
            for (Object o : jsonSeqFeatures) {
                Map jsonFeature = (Map)o;
                Long begin = (Long)jsonFeature.get("xStart");
                Long end = (Long)jsonFeature.get("xEnd");
                String type = (String)jsonFeature.get("type");
                String featureGrp = (String)jsonFeature.get("featureGroup");
                String description = (String)jsonFeature.get("description");
                String seqRef = (String)jsonFeature.get("sequenceRef");
                Float score = Float.valueOf(jsonFeature.get("score").toString());
                Sequence seq = this.seqMap.get(seqRef);
                int featureBegin = begin.intValue() == 0 ? 0 : seq.findPosition(begin.intValue());
                int featureEnd = end.intValue() == 0 ? 0 : seq.findPosition(end.intValue()) - 1;
                SequenceFeature sequenceFeature = new SequenceFeature(type, description, featureBegin, featureEnd, score.floatValue(), featureGrp);
                List linksJsonArray = (List)jsonFeature.get("links");
                if (linksJsonArray != null && linksJsonArray.size() > 0) {
                    Iterator linkList = linksJsonArray.iterator();
                    while (linkList.hasNext()) {
                        sequenceFeature.addLink((String)linkList.next());
                    }
                }
                seq.addSequenceFeature(sequenceFeature);
                this.displayedFeatures.setVisible(type);
            }
        }
    }

    @Override
    public String getGlobalColourScheme() {
        return this.globalColourScheme;
    }

    public void setGlobalColorScheme(String globalColourScheme) {
        this.globalColourScheme = globalColourScheme;
    }

    @Override
    public FeaturesDisplayedI getDisplayedFeatures() {
        return this.displayedFeatures;
    }

    public void setDisplayedFeatures(FeaturesDisplayedI displayedFeatures) {
        this.displayedFeatures = displayedFeatures;
    }

    @Override
    public void configureForView(AlignmentViewPanel avpanel) {
        if (avpanel == null) {
            return;
        }
        super.configureForView(avpanel);
        AlignViewportI viewport = avpanel.getAlignViewport();
        AlignmentI alignment = viewport.getAlignment();
        AlignmentAnnotation[] annots = alignment.getAlignmentAnnotation();
        this.seqGroups = alignment.getGroups();
        this.fr = avpanel.cloneFeatureRenderer();
        if (annots != null) {
            for (AlignmentAnnotation annot : annots) {
                if (annot == null || annot.autoCalculated) continue;
                this.annotations.add(annot);
            }
        }
        this.globalColourScheme = ColourSchemeProperty.getColourName(viewport.getGlobalColourScheme());
        this.setDisplayedFeatures(viewport.getFeaturesDisplayed());
        this.showSeqFeatures = viewport.isShowSequenceFeatures();
    }

    @Override
    public boolean isShowSeqFeatures() {
        return this.showSeqFeatures;
    }

    public void setShowSeqFeatures(boolean showSeqFeatures) {
        this.showSeqFeatures = showSeqFeatures;
    }

    @Override
    public Vector<AlignmentAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public HiddenColumns getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(HiddenColumns hidden) {
        this.hiddenColumns = hidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceI[] getHiddenSequences() {
        if (this.hiddenSequences == null || this.hiddenSequences.isEmpty()) {
            return new SequenceI[0];
        }
        ArrayList<SequenceI> arrayList = this.hiddenSequences;
        synchronized (arrayList) {
            return this.hiddenSequences.toArray(new SequenceI[this.hiddenSequences.size()]);
        }
    }

    public void setHiddenSequences(ArrayList<SequenceI> hiddenSequences) {
        this.hiddenSequences = hiddenSequences;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }

    public class JSONExportSettings {
        private boolean exportSequence;
        private boolean exportSequenceFeatures;
        private boolean exportAnnotations;
        private boolean exportGroups;
        private boolean exportJalviewSettings;

        public boolean isExportSequence() {
            return this.exportSequence;
        }

        public void setExportSequence(boolean exportSequence) {
            this.exportSequence = exportSequence;
        }

        public boolean isExportSequenceFeatures() {
            return this.exportSequenceFeatures;
        }

        public void setExportSequenceFeatures(boolean exportSequenceFeatures) {
            this.exportSequenceFeatures = exportSequenceFeatures;
        }

        public boolean isExportAnnotations() {
            return this.exportAnnotations;
        }

        public void setExportAnnotations(boolean exportAnnotations) {
            this.exportAnnotations = exportAnnotations;
        }

        public boolean isExportGroups() {
            return this.exportGroups;
        }

        public void setExportGroups(boolean exportGroups) {
            this.exportGroups = exportGroups;
        }

        public boolean isExportJalviewSettings() {
            return this.exportJalviewSettings;
        }

        public void setExportJalviewSettings(boolean exportJalviewSettings) {
            this.exportJalviewSettings = exportJalviewSettings;
        }
    }
}

