/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.hmmer.Search;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StockholmFile;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class JackHMMER
extends Search {
    SequenceI seq = null;

    public JackHMMER(AlignFrame af, List<ArgumentI> args) {
        super(af, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.seq = this.getSequence();
        if (this.seq == null) {
            Console.error("Error: no sequence for jackhmmer");
            return;
        }
        long msgId = System.currentTimeMillis();
        this.af.setProgressBar(MessageManager.getString("status.running_search"), msgId);
        try {
            File seqFile = FileUtils.createTempFile("seq", ".sto");
            File hitsAlignmentFile = FileUtils.createTempFile("hitAlignment", ".sto");
            File searchOutputFile = FileUtils.createTempFile("searchOutput", ".txt");
            this.exportStockholm(new SequenceI[]{this.seq}, seqFile.getAbsoluteFile(), null);
            boolean ran = this.runCommand(searchOutputFile, hitsAlignmentFile, seqFile);
            if (!ran) {
                JvOptionPane.showInternalMessageDialog(this.af, MessageManager.formatMessage("warn.command_failed", "jackhmmer"));
                return;
            }
            this.importData(hitsAlignmentFile, seqFile, searchOutputFile);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.af.setProgressBar("", msgId);
        }
    }

    private boolean runCommand(File searchOutputFile, File hitsAlignmentFile, File seqFile) throws IOException {
        String command = this.getCommandPath("jackhmmer");
        if (command == null) {
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(command);
        this.buildArguments(args, searchOutputFile, hitsAlignmentFile, seqFile);
        return this.runCommand(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData(File inputAlignmentTemp, File seqTemp, File searchOutputFile) throws IOException, InterruptedException {
        try (BufferedReader br = new BufferedReader(new FileReader(inputAlignmentTemp));){
            if (br.readLine() == null) {
                JOptionPane.showMessageDialog(this.af, MessageManager.getString("label.no_sequences_found"));
                return;
            }
            StockholmFile file = new StockholmFile(new FileParse(inputAlignmentTemp.getAbsolutePath(), DataSourceType.FILE));
            this.seqs = file.getSeqsAsArray();
            this.readDomainTable(searchOutputFile, true);
            if (this.searchAlignment) {
                this.recoverSequences(this.sequencesHash, this.seqs);
            }
            int seqCount = this.seqs.length;
            Alignment al = new Alignment(this.seqs);
            AlignFrame alignFrame = new AlignFrame(al, 700, 500);
            String ttl = "jackhmmer search of " + this.databaseName + " using " + this.seqs[0].getName();
            Desktop.addInternalFrame(alignFrame, ttl, 700, 500);
            seqTemp.delete();
            inputAlignmentTemp.delete();
            searchOutputFile.delete();
        }
    }
}

