/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.gui.JvOptionPane;
import jalview.util.MessageManager;
import jalview.ws2.client.api.WebServiceDiscovererI;
import jalview.ws2.client.slivka.SlivkaWSDiscoverer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class SlivkaPreferences
extends JPanel {
    WebServiceDiscovererI discoverer;
    private final ArrayList<URL> urls;
    private final Map<URL, Integer> statuses;
    private final AbstractTableModel urlTableModel;
    private JTable urlListTable;
    JButton newWsUrl;
    JButton editWsUrl;
    JButton deleteWsUrl;
    JButton moveUrlUp;
    JButton moveUrlDown;
    private ActionListener newUrlAction;
    private ActionListener editUrlAction;
    private ActionListener deleteUrlAction;
    private ActionListener moveUrlUpAction;
    private ActionListener moveUrlDownAction;
    private MouseListener tableClickListener;
    JButton refreshServices;
    JButton resetServices;
    JProgressBar progressBar;
    private ActionListener refreshServicesAction;
    private ActionListener resetServicesAction;

    private URL showEditUrlDialog(String oldUrl) {
        String input = (String)JvOptionPane.showInternalInputDialog((Component)this, MessageManager.getString("label.url:"), UIManager.getString((Object)"OptionPane.inputDialogTitle", MessageManager.getLocale()), 3, null, null, (Object)oldUrl);
        if (input == null) {
            return null;
        }
        try {
            return new URL(input);
        }
        catch (MalformedURLException ex) {
            JvOptionPane.showInternalMessageDialog((Component)this, MessageManager.getString("label.invalid_url"), UIManager.getString((Object)"OptionPane.messageDialogTitle", MessageManager.getLocale()), 2);
            return null;
        }
    }

    private void moveTableRow(int fromIndex, int toIndex) {
        URL url = this.urls.get(fromIndex);
        int status = this.statuses.get(fromIndex);
        this.urls.set(fromIndex, this.urls.get(toIndex));
        this.urls.set(toIndex, url);
        if (this.urlListTable.getSelectedRow() == fromIndex) {
            this.urlListTable.setRowSelectionInterval(toIndex, toIndex);
        }
        int firstRow = Math.min(toIndex, fromIndex);
        int lastRow = Math.max(fromIndex, toIndex);
        this.urlTableModel.fireTableRowsUpdated(firstRow, lastRow);
    }

    SlivkaPreferences() {
        this.setLayout(new BoxLayout(this, 3));
        this.setPreferredSize(new Dimension(500, 450));
        this.urls = new ArrayList();
        this.statuses = new HashMap<URL, Integer>();
        this.urlTableModel = new AbstractTableModel(){
            final String[] columnNames = new String[]{"Service URL", "Status"};

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return SlivkaPreferences.this.urls.get(rowIndex).toString();
                    }
                    case 1: {
                        return SlivkaPreferences.this.statuses.getOrDefault(SlivkaPreferences.this.urls.get(rowIndex), -2);
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public int getRowCount() {
                return SlivkaPreferences.this.urls.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }
        };
        this.urlListTable = new JTable(this.urlTableModel);
        this.urlListTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.urlListTable.getColumnModel().getColumn(1).setCellRenderer(new WSStatusCellRenderer());
        this.newWsUrl = new JButton(MessageManager.getString("label.new_service_url"));
        this.editWsUrl = new JButton(MessageManager.getString("label.edit_service_url"));
        this.deleteWsUrl = new JButton(MessageManager.getString("label.delete_service_url"));
        this.moveUrlUp = new JButton(MessageManager.getString("action.move_up"));
        this.moveUrlDown = new JButton(MessageManager.getString("action.move_down"));
        this.newUrlAction = e -> {
            URL input = this.showEditUrlDialog("");
            if (input != null) {
                this.urls.add(input);
                this.reloadStatusForUrl(input);
                this.urlTableModel.fireTableRowsInserted(this.urls.size(), this.urls.size());
                this.discoverer.setUrls(this.urls);
            }
        };
        this.editUrlAction = e -> {
            URL input;
            int i = this.urlListTable.getSelectedRow();
            if (i >= 0 && (input = this.showEditUrlDialog(this.urls.get(i).toString())) != null) {
                this.urls.set(i, input);
                this.statuses.remove(input);
                this.reloadStatusForUrl(input);
                this.urlTableModel.fireTableRowsUpdated(i, i);
                this.discoverer.setUrls(this.urls);
            }
        };
        this.deleteUrlAction = e -> {
            int i = this.urlListTable.getSelectedRow();
            if (i >= 0) {
                this.urls.remove(i);
                this.statuses.remove(i);
                this.urlTableModel.fireTableRowsDeleted(i, i);
                this.discoverer.setUrls(this.urls);
            }
        };
        this.moveUrlUpAction = e -> {
            int i = this.urlListTable.getSelectedRow();
            if (i > 0) {
                this.moveTableRow(i, i - 1);
                this.discoverer.setUrls(this.urls);
            }
        };
        this.moveUrlDownAction = e -> {
            int i = this.urlListTable.getSelectedRow();
            if (i >= 0 && i < this.urls.size() - 1) {
                this.moveTableRow(i, i + 1);
                this.discoverer.setUrls(this.urls);
            }
        };
        this.tableClickListener = new MouseAdapter(){
            final ActionEvent actionEvent;
            {
                this.actionEvent = new ActionEvent(SlivkaPreferences.this.urlListTable, 1001, "edit");
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    SlivkaPreferences.this.editUrlAction.actionPerformed(this.actionEvent);
                }
            }
        };
        Font font = new Font("Verdana", 0, 10);
        JPanel urlPaneContainer = new JPanel(new BorderLayout(5, 5));
        urlPaneContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Slivka Web Services"), BorderFactory.createEmptyBorder(10, 5, 5, 5)));
        this.newWsUrl.setFont(font);
        this.editWsUrl.setFont(font);
        this.deleteWsUrl.setFont(font);
        this.moveUrlUp.setFont(font);
        this.moveUrlDown.setFont(font);
        JPanel editContainer = new JPanel();
        editContainer.add(this.newWsUrl);
        editContainer.add(this.editWsUrl);
        editContainer.add(this.deleteWsUrl);
        urlPaneContainer.add((Component)editContainer, "Last");
        JPanel moveContainer = new JPanel();
        moveContainer.setLayout(new BoxLayout(moveContainer, 3));
        moveContainer.add(this.moveUrlUp);
        moveContainer.add(Box.createRigidArea(new Dimension(0, 5)));
        moveContainer.add(this.moveUrlDown);
        urlPaneContainer.add((Component)moveContainer, "Before");
        urlPaneContainer.add((Component)new JScrollPane(this.urlListTable), "Center");
        this.add(urlPaneContainer);
        this.urlListTable.addMouseListener(this.tableClickListener);
        this.newWsUrl.addActionListener(this.newUrlAction);
        this.editWsUrl.addActionListener(this.editUrlAction);
        this.deleteWsUrl.addActionListener(this.deleteUrlAction);
        this.moveUrlUp.addActionListener(this.moveUrlUpAction);
        this.moveUrlDown.addActionListener(this.moveUrlDownAction);
        this.refreshServices = new JButton(MessageManager.getString("action.refresh_services"));
        this.resetServices = new JButton(MessageManager.getString("action.reset_services"));
        this.progressBar = new JProgressBar();
        this.refreshServicesAction = e -> {
            this.progressBar.setVisible(true);
            Console.info("Requesting service reload");
            this.discoverer.startDiscoverer().handle((services, exception) -> {
                if (exception == null) {
                    Console.info("Reloading done");
                } else if (exception instanceof CancellationException) {
                    Console.info("Reloading cancelled");
                } else {
                    Console.error("Reloading failed", exception);
                }
                SwingUtilities.invokeLater(() -> this.progressBar.setVisible(false));
                return null;
            });
        };
        this.resetServicesAction = e -> {
            this.discoverer.setUrls(null);
            this.urls.clear();
            this.statuses.clear();
            this.urls.addAll(this.discoverer.getUrls());
            for (URL url : this.urls) {
                this.reloadStatusForUrl(url);
            }
            this.urlTableModel.fireTableDataChanged();
        };
        font = new Font("Verdana", 0, 11);
        this.refreshServices.setFont(font);
        this.resetServices.setFont(font);
        JPanel container = new JPanel();
        container.add(this.refreshServices);
        container.add(this.resetServices);
        this.add(container);
        this.refreshServices.addActionListener(this.refreshServicesAction);
        this.resetServices.addActionListener(this.resetServicesAction);
        this.progressBar.setVisible(false);
        this.progressBar.setIndeterminate(true);
        this.add(this.progressBar);
        this.discoverer = SlivkaWSDiscoverer.getInstance();
        this.urls.addAll(this.discoverer.getUrls());
        for (URL url : this.urls) {
            this.reloadStatusForUrl(url);
        }
    }

    private void reloadStatusForUrl(URL url) {
        CompletableFuture.supplyAsync(() -> this.discoverer.getStatusForUrl(url)).thenAccept(status -> {
            this.statuses.put(url, (Integer)status);
            int row = this.urls.indexOf(url);
            if (row >= 0) {
                this.urlTableModel.fireTableCellUpdated(row, 1);
            }
        });
    }

    private class WSStatusCellRenderer
    extends DefaultTableCellRenderer {
        private WSStatusCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            super.getTableCellRendererComponent(table, "\u25cf", isSelected, hasFocus, row, column);
            switch ((Integer)value) {
                case 0: {
                    this.setForeground(Color.ORANGE);
                    break;
                }
                case 1: {
                    this.setForeground(Color.GREEN);
                    break;
                }
                case -1: {
                    this.setForeground(Color.RED);
                    break;
                }
                default: {
                    this.setForeground(Color.LIGHT_GRAY);
                }
            }
            return this;
        }
    }
}

