/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class AnnotationChooser
extends JPanel {
    private static final Font CHECKBOX_FONT = new Font("Serif", 1, 12);
    private static final int MY_FRAME_WIDTH = 600;
    private static final int MY_FRAME_HEIGHT = 250;
    private JInternalFrame frame;
    private AlignmentPanel ap;
    private SequenceGroup sg;
    private boolean[] resetState = null;
    private boolean showSelected;
    private boolean applyToSelectedSequences;
    private boolean applyToUnselectedSequences;
    private Map<String, String> selectedTypes = new HashMap<String, String>();

    public AnnotationChooser(AlignmentPanel alignPane) {
        this.ap = alignPane;
        this.sg = alignPane.av.getSelectionGroup();
        this.saveResetState(alignPane.getAlignment());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.showFrame();
    }

    protected void saveResetState(AlignmentI alignment) {
        AlignmentAnnotation[] annotations = alignment.getAlignmentAnnotation();
        int count = annotations.length;
        this.resetState = new boolean[count];
        for (int i = 0; i < count; ++i) {
            this.resetState[i] = annotations[i].visible;
        }
    }

    protected void jbInit() {
        this.setLayout(new GridLayout(3, 1));
        this.add(this.buildAnnotationTypesPanel());
        this.add(this.buildShowHideOptionsPanel());
        this.add(this.buildActionButtonsPanel());
        this.validate();
    }

    protected JPanel buildAnnotationTypesPanel() {
        JPanel jp = new JPanel(new FlowLayout(0));
        List<String> annotationTypes = AnnotationChooser.getAnnotationTypes(this.ap.getAlignment(), true);
        for (final String type : annotationTypes) {
            Checkbox check = new Checkbox(type);
            check.setFont(CHECKBOX_FONT);
            check.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (evt.getStateChange() == 1) {
                        AnnotationChooser.this.selectedTypes.put(type, type);
                    } else {
                        AnnotationChooser.this.selectedTypes.remove(type);
                    }
                    AnnotationChooser.this.changeTypeSelected_actionPerformed(type);
                }
            });
            jp.add(check);
        }
        return jp;
    }

    protected void changeApplyTo_actionPerformed() {
        this.setAnnotationVisibility(true);
        this.ap.updateAnnotation();
    }

    protected void changeTypeSelected_actionPerformed(String type) {
        boolean typeSelected = this.selectedTypes.containsKey(type);
        for (AlignmentAnnotation aa : this.ap.getAlignment().getAlignmentAnnotation()) {
            if (aa.sequenceRef == null || !type.equals(aa.label) || !this.isInActionScope(aa)) continue;
            aa.visible = typeSelected ? this.showSelected : !this.showSelected;
        }
        this.ap.updateAnnotation();
    }

    protected void changeShowHide_actionPerformed() {
        this.setAnnotationVisibility(false);
        this.ap.updateAnnotation();
    }

    protected void setAnnotationVisibility(boolean updateAllRows) {
        for (AlignmentAnnotation aa : this.ap.getAlignment().getAlignmentAnnotation()) {
            if (aa.sequenceRef == null) continue;
            this.setAnnotationVisibility(aa, updateAllRows);
        }
    }

    protected void setAnnotationVisibility(AlignmentAnnotation aa, boolean updateAllRows) {
        if (this.selectedTypes.containsKey(aa.label)) {
            if (this.isInActionScope(aa)) {
                aa.visible = this.showSelected;
            } else if (updateAllRows) {
                aa.visible = !this.showSelected;
            }
        }
    }

    protected boolean isInActionScope(AlignmentAnnotation aa) {
        boolean result = false;
        result = this.applyToSelectedSequences && this.applyToUnselectedSequences ? true : (this.sg == null ? true : (this.sg.getSequences().contains(aa.sequenceRef) ? this.applyToSelectedSequences : this.applyToUnselectedSequences));
        return result;
    }

    public static List<String> getAnnotationTypes(AlignmentI alignment, boolean sequenceSpecificOnly) {
        ArrayList<String> result = new ArrayList<String>();
        for (AlignmentAnnotation aa : alignment.getAlignmentAnnotation()) {
            String label;
            if (sequenceSpecificOnly && aa.sequenceRef == null || result.contains(label = aa.label)) continue;
            result.add(label);
        }
        return result;
    }

    protected JPanel buildShowHideOptionsPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        JPanel showHideOptions = this.buildShowHidePanel();
        jp.add((Component)showHideOptions, "Center");
        JPanel applyToOptions = this.buildApplyToOptionsPanel();
        jp.add((Component)applyToOptions, "South");
        return jp;
    }

    protected JPanel buildApplyToOptionsPanel() {
        boolean wholeAlignment = this.sg == null;
        JPanel applyToOptions = new JPanel(new FlowLayout(0));
        CheckboxGroup actingOn = new CheckboxGroup();
        String forAll = MessageManager.getString("label.all_sequences");
        Checkbox allSequences = new Checkbox(forAll, actingOn, wholeAlignment);
        allSequences.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    AnnotationChooser.this.setApplyToSelectedSequences(true);
                    AnnotationChooser.this.setApplyToUnselectedSequences(true);
                    AnnotationChooser.this.changeApplyTo_actionPerformed();
                }
            }
        });
        applyToOptions.add(allSequences);
        String forSelected = MessageManager.getString("label.selected_sequences");
        Checkbox selectedSequences = new Checkbox(forSelected, actingOn, !wholeAlignment);
        selectedSequences.setEnabled(!wholeAlignment);
        selectedSequences.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    AnnotationChooser.this.setApplyToSelectedSequences(true);
                    AnnotationChooser.this.setApplyToUnselectedSequences(false);
                    AnnotationChooser.this.changeApplyTo_actionPerformed();
                }
            }
        });
        applyToOptions.add(selectedSequences);
        String exceptSelected = MessageManager.getString("label.except_selected_sequences");
        Checkbox unselectedSequences = new Checkbox(exceptSelected, actingOn, false);
        unselectedSequences.setEnabled(!wholeAlignment);
        unselectedSequences.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    AnnotationChooser.this.setApplyToSelectedSequences(false);
                    AnnotationChooser.this.setApplyToUnselectedSequences(true);
                    AnnotationChooser.this.changeApplyTo_actionPerformed();
                }
            }
        });
        applyToOptions.add(unselectedSequences);
        this.applyToSelectedSequences = selectedSequences.getState() || allSequences.getState();
        this.applyToUnselectedSequences = unselectedSequences.getState() || allSequences.getState();
        return applyToOptions;
    }

    protected JPanel buildShowHidePanel() {
        JPanel showHideOptions = new JPanel(new FlowLayout(0));
        CheckboxGroup showOrHide = new CheckboxGroup();
        String showLabel = MessageManager.getString("label.show_selected_annotations");
        Checkbox showOption = new Checkbox(showLabel, showOrHide, false);
        showOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    AnnotationChooser.this.setShowSelected(true);
                    AnnotationChooser.this.changeShowHide_actionPerformed();
                }
            }
        });
        showHideOptions.add(showOption);
        String hideLabel = MessageManager.getString("label.hide_selected_annotations");
        Checkbox hideOption = new Checkbox(hideLabel, showOrHide, true);
        hideOption.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    AnnotationChooser.this.setShowSelected(false);
                    AnnotationChooser.this.changeShowHide_actionPerformed();
                }
            }
        });
        showHideOptions.add(hideOption);
        this.showSelected = showOption.getState();
        return showHideOptions;
    }

    protected JPanel buildActionButtonsPanel() {
        JPanel jp = new JPanel();
        Font labelFont = JvSwingUtils.getLabelFont();
        JButton ok = new JButton(MessageManager.getString("action.ok"));
        ok.setFont(labelFont);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationChooser.this.close_actionPerformed();
            }
        });
        jp.add(ok);
        JButton cancel = new JButton(MessageManager.getString("action.cancel"));
        cancel.setFont(labelFont);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationChooser.this.cancel_actionPerformed();
            }
        });
        jp.add(cancel);
        return jp;
    }

    protected void cancel_actionPerformed() {
        this.resetOriginalState();
        this.ap.repaint();
        this.close_actionPerformed();
    }

    protected void resetOriginalState() {
        int i = 0;
        for (AlignmentAnnotation aa : this.ap.getAlignment().getAlignmentAnnotation()) {
            aa.visible = this.resetState[i++];
        }
    }

    protected void close_actionPerformed() {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showFrame() {
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.choose_annotations"), true, 600, 250, true, false);
    }

    protected void setShowSelected(boolean showSelected) {
        this.showSelected = showSelected;
    }

    protected void setApplyToSelectedSequences(boolean applyToSelectedSequences) {
        this.applyToSelectedSequences = applyToSelectedSequences;
    }

    protected void setApplyToUnselectedSequences(boolean applyToUnselectedSequences) {
        this.applyToUnselectedSequences = applyToUnselectedSequences;
    }

    protected boolean isShowSelected() {
        return this.showSelected;
    }

    protected boolean isApplyToSelectedSequences() {
        return this.applyToSelectedSequences;
    }

    protected boolean isApplyToUnselectedSequences() {
        return this.applyToUnselectedSequences;
    }
}

