/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.threedbeacons;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.api.StructureFTSRestClientI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestClient;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.service.threedbeacons.TDB_FTSData;
import jalview.javascript.web.Client;
import jalview.util.JSONUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

public class TDBeaconsFTSRestClient
extends FTSRestClient
implements StructureFTSRestClientI {
    private static String TDB_PROD_API = "https://www.ebi.ac.uk/pdbe/pdbe-kb/3dbeacons/api/uniprot/summary/";
    private static String TDB_DEV_API = "https://wwwdev.ebi.ac.uk/pdbe/pdbe-kb/3dbeacons/api/uniprot/summary/";
    private static String DEFAULT_THREEDBEACONS_DOMAIN = TDB_PROD_API;
    public static FTSRestClientI instance = null;
    private Collection<FTSDataColumnI> allDefaultDisplayedStructureDataColumns;

    protected TDBeaconsFTSRestClient() {
    }

    @Override
    public FTSRestResponse executeRequest(FTSRestRequest tdbRestRequest) throws Exception {
        try {
            Class clientResponseClass;
            com.sun.jersey.api.client.Client client;
            String query = tdbRestRequest.getSearchTerm();
            if (Platform.isJS()) {
                client = (com.sun.jersey.api.client.Client)new Client();
                clientResponseClass = jalview.javascript.web.ClientResponse.class;
            } else {
                client = com.sun.jersey.api.client.Client.create((ClientConfig)new DefaultClientConfig());
                clientResponseClass = ClientResponse.class;
            }
            WebResource webResource = client.resource(DEFAULT_THREEDBEACONS_DOMAIN + query);
            URI uri = webResource.getURI();
            Console.outPrintln(uri.toString());
            ClientResponse clientResponse = this.isMocked() ? null : (ClientResponse)webResource.accept(new String[]{"application/json"}).get(clientResponseClass);
            Map jsonObj = null;
            String responseString = null;
            int responseStatus = this.isMocked() ? (this.mockQueries.containsKey(query) ? 200 : 404) : clientResponse.getStatus();
            switch (responseStatus) {
                case 200: {
                    if (Platform.isJS()) {
                        jsonObj = (Map)clientResponse.getEntity(Map.class);
                        break;
                    }
                    responseString = this.isMocked() ? (String)this.mockQueries.get(query) : (String)clientResponse.getEntity(String.class);
                    break;
                }
                case 400: {
                    throw new Exception(this.parseJsonExceptionString(responseString));
                }
                case 404: {
                    return this.emptyTDBeaconsJsonResponse();
                }
                default: {
                    throw new Exception(TDBeaconsFTSRestClient.getMessageByHTTPStatusCode(responseStatus, "3DBeacons"));
                }
            }
            return TDBeaconsFTSRestClient.parseTDBeaconsJsonResponse(responseString, jsonObj, tdbRestRequest);
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg != null) {
                if (exceptionMsg.contains("SocketException")) {
                    throw new Exception(MessageManager.getString("exception.unable_to_detect_internet_connection"));
                }
                if (exceptionMsg.contains("UnknownHostException")) {
                    throw new Exception(MessageManager.formatMessage("exception.fts_server_unreachable", "3DB Hub"));
                }
            }
            throw e;
        }
    }

    private FTSRestResponse emptyTDBeaconsJsonResponse() {
        return null;
    }

    public String setSearchTerm(String term) {
        return term;
    }

    public static FTSRestResponse parseTDBeaconsJsonResponse(String tdbJsonResponseString, FTSRestRequest tdbRestRequest) {
        return TDBeaconsFTSRestClient.parseTDBeaconsJsonResponse(tdbJsonResponseString, null, tdbRestRequest);
    }

    public static FTSRestResponse parseTDBeaconsJsonResponse(String tdbJsonResponseString, Map<String, Object> jsonObj, FTSRestRequest tdbRestRequest) {
        FTSRestResponse searchResult = new FTSRestResponse();
        ArrayList<FTSData> result = null;
        try {
            if (jsonObj == null) {
                jsonObj = (Map)JSONUtils.parse(tdbJsonResponseString);
            }
            Object uniprot_entry = jsonObj.get("uniprot_entry");
            List structures = (List)jsonObj.get("structures");
            result = new ArrayList<FTSData>();
            int numFound = 0;
            for (Map structure : structures) {
                result.add(TDBeaconsFTSRestClient.getFTSData(structure, tdbRestRequest));
                ++numFound;
            }
            searchResult.setNumberOfItemsFound(numFound);
            searchResult.setSearchSummary(result);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return searchResult;
    }

    private static FTSData getFTSData(Map<String, Object> tdbJsonStructureSummary, FTSRestRequest tdbRequest) {
        String primaryKey = null;
        Collection<FTSDataColumnI> displayFields = tdbRequest.getWantedFields();
        SequenceI associatedSeq = tdbRequest.getAssociatedSequence();
        int colCounter = 0;
        Object[] summaryRowData = new Object[associatedSeq != null ? displayFields.size() + 1 : displayFields.size()];
        if (associatedSeq != null) {
            SequenceI associatedSequence = associatedSeq;
            summaryRowData[0] = associatedSequence;
            colCounter = 1;
        }
        Map tdbJsonStructure = (Map)tdbJsonStructureSummary.get("summary");
        for (FTSDataColumnI field : displayFields) {
            String fieldData;
            String string = fieldData = tdbJsonStructure.get(field.getCode()) == null ? " " : tdbJsonStructure.get(field.getCode()).toString();
            if (field.isPrimaryKeyColumn()) {
                primaryKey = fieldData;
                summaryRowData[colCounter++] = primaryKey;
                continue;
            }
            if (fieldData == null || fieldData.trim().isEmpty()) {
                summaryRowData[colCounter++] = null;
                continue;
            }
            try {
                summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(fieldData) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(fieldData) : fieldData);
            }
            catch (Exception e) {
                Console.outPrintln("offending value:" + fieldData + fieldData);
            }
        }
        String primaryKey1 = primaryKey;
        Object[] summaryRowData1 = summaryRowData;
        return new TDB_FTSData(primaryKey, tdbJsonStructure, summaryRowData1);
    }

    private String parseJsonExceptionString(String jsonErrorString) {
        return null;
    }

    @Override
    public String getColumnDataConfigFileName() {
        return "/fts/tdbeacons_data_columns.txt";
    }

    public static FTSRestClientI getInstance() {
        if (instance == null) {
            instance = new TDBeaconsFTSRestClient();
        }
        return instance;
    }

    @Override
    public Collection<FTSDataColumnI> getAllDefaultDisplayedStructureDataColumns() {
        if (this.allDefaultDisplayedStructureDataColumns == null || this.allDefaultDisplayedStructureDataColumns.isEmpty()) {
            this.allDefaultDisplayedStructureDataColumns = new ArrayList<FTSDataColumnI>();
            this.allDefaultDisplayedStructureDataColumns.addAll(super.getAllDefaultDisplayedFTSDataColumns());
        }
        return this.allDefaultDisplayedStructureDataColumns;
    }

    @Override
    public String[] getPreferencesColumnsFor(FTSDataColumnPreferences.PreferenceSource source) {
        String[] columnNames = null;
        switch (source) {
            case SEARCH_SUMMARY: {
                columnNames = new String[]{"", "Display", "Group"};
                break;
            }
            case STRUCTURE_CHOOSER: {
                columnNames = new String[]{"", "Display", "Group"};
                break;
            }
            case PREFERENCES: {
                columnNames = new String[]{"3DB Beacons Field", "Show in search summary", "Show in structure summary"};
                break;
            }
        }
        return columnNames;
    }
}

