/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import com.stevesoft.pat.Regex;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblSeqProxy;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.util.Platform;
import java.util.ArrayList;
import java.util.List;

public class EnsemblProtein
extends EnsemblSeqProxy {
    private static final Regex ACCESSION_REGEX = Platform.newRegex("(ENS([A-Z]{3}|)P[0-9]{11}$)|(CCDS[0-9.]{3,}$)");

    public EnsemblProtein() {
    }

    public EnsemblProtein(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (Protein)";
    }

    @Override
    protected EnsemblSeqProxy.EnsemblSeqType getSourceEnsemblType() {
        return EnsemblSeqProxy.EnsemblSeqType.PROTEIN;
    }

    @Override
    public boolean isDnaCoding() {
        return false;
    }

    @Override
    public String getTestQuery() {
        return "ENSP00000288602";
    }

    @Override
    protected void addFeaturesAndProduct(String accId, AlignmentI alignment) {
    }

    @Override
    protected EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch() {
        return null;
    }

    @Override
    protected List<SequenceFeature> getIdentifyingFeatures(SequenceI seq, String accId) {
        return new ArrayList<SequenceFeature>();
    }

    @Override
    public Regex getAccessionValidator() {
        return ACCESSION_REGEX;
    }

    @Override
    public String getAccessionIdFromQuery(String query) {
        String accId = super.getAccessionIdFromQuery(query);
        if (accId != null && accId.length() >= 12) {
            char[] chars = accId.toCharArray();
            chars[chars.length - 12] = 80;
            accId = new String(chars);
        }
        return accId;
    }
}

