/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationLabels;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.PaintRefresher;
import jalview.datamodel.SequenceI;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.util.List;

public class IdCanvas
extends Panel
implements ViewportListenerI {
    protected AlignViewport av;
    protected boolean showScores = true;
    protected int maxIdLength = -1;
    protected String maxIdStr = null;
    Image image;
    Graphics gg;
    int imgHeight = 0;
    boolean fastPaint = false;
    List<SequenceI> searchResults;
    private int avcharHeight;

    public IdCanvas(AlignViewport av) {
        this.setLayout(null);
        this.av = av;
        PaintRefresher.Register(this, av.getSequenceSetId());
        av.getRanges().addPropertyChangeListener(this);
    }

    public void drawIdString(Graphics gg, boolean hiddenRows, SequenceI s, int i, int starty, int ypos) {
        int charHeight = this.av.getCharHeight();
        if (this.searchResults != null && this.searchResults.contains(s)) {
            gg.setColor(Color.black);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.white);
        } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(s)) {
            gg.setColor(Color.lightGray);
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.white);
        } else {
            gg.setColor(this.av.getSequenceColour(s));
            gg.fillRect(0, (i - starty) * charHeight + ypos, this.getSize().width, charHeight);
            gg.setColor(Color.black);
        }
        gg.drawString(s.getDisplayId(this.av.getShowJVSuffix()), 0, (i - starty) * charHeight + ypos + charHeight - charHeight / 5);
        if (hiddenRows) {
            this.drawMarker(i, starty, ypos);
        }
    }

    public void fastPaint(int vertical) {
        if (this.gg == null || this.av.getWrapAlignment()) {
            this.repaint();
            return;
        }
        ViewportRanges ranges = this.av.getRanges();
        this.gg.copyArea(0, 0, this.getSize().width, this.imgHeight, 0, -vertical * this.av.getCharHeight());
        int ss = ranges.getStartSeq();
        int es = ranges.getEndSeq();
        int transY = 0;
        if (vertical > 0) {
            ss = es - vertical;
            if (ss < ranges.getStartSeq()) {
                ss = ranges.getStartSeq();
            } else {
                transY = this.imgHeight - (vertical + 1) * this.av.getCharHeight();
            }
        } else if (vertical < 0 && (es = ss - vertical) > ranges.getEndSeq()) {
            es = ranges.getEndSeq();
        }
        this.gg.translate(0, transY);
        this.drawIds(ss, es);
        this.gg.translate(0, -transY);
        this.fastPaint = true;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getSize().height < 0 || this.getSize().width < 0) {
            return;
        }
        if (this.fastPaint) {
            this.fastPaint = false;
            g.drawImage(this.image, 0, 0, this);
            return;
        }
        this.imgHeight = this.getSize().height;
        this.imgHeight -= this.imgHeight % this.av.getCharHeight();
        if (this.imgHeight < 1) {
            return;
        }
        if (this.image == null || this.imgHeight != this.image.getHeight(this)) {
            this.image = this.createImage(this.getSize().width, this.imgHeight);
            this.gg = this.image.getGraphics();
            this.gg.setFont(this.av.getFont());
        }
        this.gg.setColor(Color.white);
        Font italic = new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize());
        this.gg.setFont(italic);
        this.gg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.drawIds(this.av.getRanges().getStartSeq(), this.av.getRanges().getEndSeq());
        g.drawImage(this.image, 0, 0, this);
    }

    void drawIds(int starty, int endy) {
        boolean hiddenRows;
        this.avcharHeight = this.av.getCharHeight();
        Color currentColor = Color.white;
        Color currentTextColor = Color.black;
        boolean doHiddenCheck = this.av.isDisplayReferenceSeq() || this.av.hasHiddenRows();
        boolean bl = hiddenRows = this.av.hasHiddenRows() && this.av.getShowHiddenMarkers();
        if (this.av.getWrapAlignment()) {
            this.drawIdsWrapped(starty, doHiddenCheck, hiddenRows);
            return;
        }
        for (int i = starty; i <= endy; ++i) {
            SequenceI seq = this.av.getAlignment().getSequenceAt(i);
            if (seq == null) continue;
            Font italic = new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize());
            this.gg.setFont(italic);
            if (doHiddenCheck) {
                this.setHiddenFont(seq);
            }
            if (this.searchResults != null && this.searchResults.contains(seq)) {
                currentColor = Color.black;
                currentTextColor = Color.white;
            } else if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(seq)) {
                currentColor = Color.lightGray;
                currentTextColor = Color.black;
            } else {
                currentColor = this.av.getSequenceColour(seq);
                currentTextColor = Color.black;
            }
            this.gg.setColor(currentColor);
            this.gg.fillRect(0, (i - starty) * this.avcharHeight, this.getSize().width, this.avcharHeight);
            this.gg.setColor(currentTextColor);
            this.gg.drawString(seq.getDisplayId(this.av.getShowJVSuffix()), 0, (i - starty) * this.avcharHeight + this.avcharHeight - this.avcharHeight / 5);
            if (!hiddenRows) continue;
            this.drawMarker(i, starty, 0);
        }
    }

    protected void drawIdsWrapped(int starty, boolean doHiddenCheck, boolean hiddenRows) {
        int maxwidth = this.av.getAlignment().getVisibleWidth();
        int alheight = this.av.getAlignment().getHeight();
        int annotationHeight = 0;
        AnnotationLabels labels = null;
        if (this.av.isShowAnnotation()) {
            AnnotationPanel ap = new AnnotationPanel(this.av);
            annotationHeight = ap.adjustPanelHeight();
            labels = new AnnotationLabels(this.av);
        }
        int hgap = this.avcharHeight;
        if (this.av.getScaleAboveWrapped()) {
            hgap += this.avcharHeight;
        }
        int cHeight = alheight * this.avcharHeight + hgap + annotationHeight;
        int rowSize = this.av.getRanges().getViewportWidth();
        Font italic = new Font(this.av.getFont().getName(), 2, this.av.getFont().getSize());
        this.gg.setFont(italic);
        int ypos = hgap;
        for (int row = this.av.getRanges().getStartRes(); ypos <= this.getHeight() && row < maxwidth; ypos += cHeight, row += rowSize) {
            for (int i = starty; i < alheight; ++i) {
                SequenceI s = this.av.getAlignment().getSequenceAt(i);
                if (doHiddenCheck) {
                    this.setHiddenFont(s);
                }
                this.drawIdString(this.gg, hiddenRows, s, i, 0, ypos);
            }
            if (labels == null) continue;
            this.gg.translate(0, ypos + alheight * this.avcharHeight);
            labels.drawComponent(this.gg, this.getSize().width);
            this.gg.translate(0, -ypos - alheight * this.avcharHeight);
        }
    }

    public void setHighlighted(List<SequenceI> list) {
        this.searchResults = list;
        this.repaint();
    }

    void drawMarker(int i, int starty, int yoffset) {
        SequenceI[] hseqs = this.av.getAlignment().getHiddenSequences().hiddenSequences;
        int hSize = hseqs.length;
        int hiddenIndex = i;
        int lastIndex = i - 1;
        int nextIndex = i + 1;
        for (int j = 0; j < hSize; ++j) {
            if (hseqs[j] == null) continue;
            if (j - 1 < hiddenIndex) {
                ++hiddenIndex;
            }
            if (j - 1 < lastIndex) {
                ++lastIndex;
            }
            if (j - 1 >= nextIndex) continue;
            ++nextIndex;
        }
        boolean below = hiddenIndex > lastIndex + 1;
        boolean above = nextIndex > hiddenIndex + 1;
        this.gg.setColor(Color.blue);
        if (below) {
            this.gg.fillPolygon(new int[]{this.getSize().width - this.avcharHeight, this.getSize().width - this.avcharHeight, this.getSize().width}, new int[]{(i - starty) * this.avcharHeight + yoffset, (i - starty) * this.avcharHeight + yoffset + this.avcharHeight / 4, (i - starty) * this.avcharHeight + yoffset}, 3);
        }
        if (above) {
            this.gg.fillPolygon(new int[]{this.getSize().width - this.avcharHeight, this.getSize().width - this.avcharHeight, this.getSize().width}, new int[]{(i - starty + 1) * this.avcharHeight + yoffset, (i - starty + 1) * this.avcharHeight + yoffset - this.avcharHeight / 4, (i - starty + 1) * this.avcharHeight + yoffset}, 3);
        }
    }

    boolean setHiddenFont(SequenceI seq) {
        Font bold = new Font(this.av.getFont().getName(), 1, this.av.getFont().getSize());
        if (this.av.isReferenceSeq(seq) || this.av.isHiddenRepSequence(seq)) {
            this.gg.setFont(bold);
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("startseq") || this.av.getWrapAlignment() && propertyName.equals("startres")) {
            this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (propertyName.equals("startresandseq")) {
            this.fastPaint(((int[])evt.getNewValue())[1] - ((int[])evt.getOldValue())[1]);
        } else if (propertyName.equals("move_viewport")) {
            this.repaint();
        }
    }
}

