/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.FeatureColourI;
import jalview.api.FeatureSettingsControllerI;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureColourChooser;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureSettings
extends Panel
implements ItemListener,
MouseListener,
MouseMotionListener,
AdjustmentListener,
FeatureSettingsControllerI {
    FeatureRenderer fr;
    AlignmentPanel ap;
    AlignViewport av;
    Frame frame;
    Panel groupPanel;
    Panel featurePanel = new Panel();
    ScrollPane scrollPane;
    Image linkImage;
    Scrollbar transparency;
    private ItemListener groupItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent evt) {
            Checkbox source = (Checkbox)evt.getSource();
            FeatureSettings.this.fr.setGroupVisibility(source.getLabel(), source.getState());
            FeatureSettings.this.ap.seqPanel.seqCanvas.repaint();
            if (FeatureSettings.this.ap.overviewPanel != null) {
                FeatureSettings.this.ap.overviewPanel.updateOverviewImage();
            }
            FeatureSettings.this.resetTable(true);
        }
    };
    MyCheckbox selectedCheck;
    boolean dragging = false;

    public FeatureSettings(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        ap.av.featureSettings = this;
        this.fr = ap.seqPanel.seqCanvas.getFeatureRenderer();
        this.transparency = new Scrollbar(0, 100 - (int)(this.fr.getTransparency() * 100.0f), 1, 1, 100);
        this.transparency.addAdjustmentListener(this);
        URL url = this.getClass().getResource("/images/link.gif");
        if (url != null) {
            this.linkImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        if (this.av.isShowSequenceFeatures() || !this.fr.hasRenderOrder()) {
            this.fr.findAllFeatures(true);
        }
        this.groupPanel = new Panel();
        this.discoverAllFeatureData();
        this.setLayout(new BorderLayout());
        this.scrollPane = new ScrollPane();
        this.scrollPane.add(this.featurePanel);
        if (this.fr.getAllFeatureColours() != null && this.fr.getAllFeatureColours().size() > 0) {
            this.add((Component)this.scrollPane, "Center");
        }
        Button invert = new Button(MessageManager.getString("label.invert_selection"));
        invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.invertSelection();
            }
        });
        Panel lowerPanel = new Panel(new GridLayout(2, 1, 5, 10));
        lowerPanel.add(invert);
        Panel tPanel = new Panel(new BorderLayout());
        tPanel.add((Component)this.transparency, "Center");
        tPanel.add((Component)new Label("Transparency"), "East");
        lowerPanel.add((Component)tPanel, "South");
        this.add((Component)lowerPanel, "South");
        this.groupPanel.setLayout(new GridLayout(this.fr.getFeatureGroupsSize() / 4 + 1, 4));
        this.groupPanel.validate();
        this.add((Component)this.groupPanel, "North");
        this.frame = new Frame();
        this.frame.add(this);
        final FeatureSettings me = this;
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (me.av.featureSettings == me) {
                    me.av.featureSettings = null;
                    me.ap = null;
                    me.av = null;
                }
            }
        });
        int height = this.featurePanel.getComponentCount() * 50 + 60;
        height = Math.max(200, height);
        height = Math.min(400, height);
        int width = 300;
        JalviewLite.addFrame(this.frame, MessageManager.getString("label.sequence_feature_settings"), width, height);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawString(MessageManager.getString("label.no_features_added_to_this_alignment"), 10, 20);
        g.drawString(MessageManager.getString("label.features_can_be_added_from_searches_1"), 10, 40);
        g.drawString(MessageManager.getString("label.features_can_be_added_from_searches_2"), 10, 60);
    }

    protected void popupSort(final MyCheckbox check, Map<String, float[][]> minmax, int x, int y) {
        float[][] typeMinMax;
        final String type = check.type;
        final FeatureColourI typeCol = this.fr.getFeatureStyle(type);
        PopupMenu men = new PopupMenu(MessageManager.formatMessage("label.settings_for_type", new String[]{type}));
        MenuItem scr = new MenuItem(MessageManager.getString("label.sort_by_score"));
        men.add(scr);
        final FeatureSettings me = this;
        scr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.ap.alignFrame.avc.sortAlignmentByFeatureScore(Arrays.asList(type));
            }
        });
        MenuItem dens = new MenuItem(MessageManager.getString("label.sort_by_density"));
        dens.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.ap.alignFrame.avc.sortAlignmentByFeatureDensity(Arrays.asList(type));
            }
        });
        men.add(dens);
        if (minmax != null && (typeMinMax = minmax.get(type)) != null && typeMinMax[0] != null) {
            MenuItem mxcol = new MenuItem(typeCol.isSimpleColour() ? "Graduated Colour" : "Single Colour");
            men.add(mxcol);
            mxcol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (typeCol.isSimpleColour()) {
                        new FeatureColourChooser(me, type);
                        check.updateColor(FeatureSettings.this.fr.getFeatureStyle(type));
                    } else {
                        new UserDefinedColours(me, check.type, typeCol);
                    }
                }
            });
        }
        MenuItem selectContaining = new MenuItem(MessageManager.getString("label.select_columns_containing"));
        selectContaining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.ap.alignFrame.avc.markColumnsContainingFeatures(false, false, false, type);
            }
        });
        men.add(selectContaining);
        MenuItem selectNotContaining = new MenuItem(MessageManager.getString("label.select_columns_not_containing"));
        selectNotContaining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                me.ap.alignFrame.avc.markColumnsContainingFeatures(true, false, false, type);
            }
        });
        men.add(selectNotContaining);
        MenuItem hideContaining = new MenuItem(MessageManager.getString("label.hide_columns_containing"));
        hideContaining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.hideFeatureColumns(type, true);
            }
        });
        men.add(hideContaining);
        MenuItem hideNotContaining = new MenuItem(MessageManager.getString("label.hide_columns_not_containing"));
        hideNotContaining.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureSettings.this.hideFeatureColumns(type, false);
            }
        });
        men.add(hideNotContaining);
        this.featurePanel.add(men);
        men.show(this.featurePanel, x, y);
    }

    @Override
    public void discoverAllFeatureData() {
        if (this.fr.getAllFeatureColours() == null || this.fr.getAllFeatureColours().size() > 0) {
            // empty if block
        }
        this.resetTable(false);
    }

    public boolean checkGroupState(String group) {
        boolean visible = this.fr.checkGroupVisibility(group, true);
        for (int g = 0; g < this.groupPanel.getComponentCount(); ++g) {
            if (!((Checkbox)this.groupPanel.getComponent(g)).getLabel().equals(group)) continue;
            ((Checkbox)this.groupPanel.getComponent(g)).setState(visible);
            return visible;
        }
        MyCheckbox check = new MyCheckbox(group, visible, false);
        check.addMouseListener(this);
        check.setFont(new Font("Serif", 1, 12));
        check.addItemListener(this.groupItemListener);
        this.groupPanel.add(check);
        this.groupPanel.validate();
        return visible;
    }

    void resetTable(boolean groupsChanged) {
        ArrayList<String> displayableTypes = new ArrayList<String>();
        HashSet<String> foundGroups = new HashSet<String>();
        AlignmentI alignment = this.av.getAlignment();
        for (int i = 0; i < alignment.getHeight(); ++i) {
            SequenceI seq = alignment.getSequenceAt(i);
            Set<String> groups = seq.getFeatures().getFeatureGroups(true, new String[0]);
            HashSet<String> visibleGroups = new HashSet<String>();
            for (String group : groups) {
                if (group != null && !this.checkGroupState(group)) continue;
                visibleGroups.add(group);
            }
            foundGroups.addAll(groups);
            Set<String> types = seq.getFeatures().getFeatureTypesForGroups(true, visibleGroups.toArray(new String[visibleGroups.size()]));
            displayableTypes.addAll(types);
        }
        this.pruneGroups(foundGroups);
        int cSize = this.featurePanel.getComponentCount();
        for (int i = 0; i < cSize; ++i) {
            Component[] comps = this.featurePanel.getComponents();
            MyCheckbox check = (MyCheckbox)comps[i];
            if (displayableTypes.contains(check.type)) continue;
            this.featurePanel.remove(i);
            --cSize;
            --i;
        }
        if (this.fr.getRenderOrder() != null) {
            List<String> rol = this.fr.getRenderOrder();
            for (int ro = rol.size() - 1; ro > -1; --ro) {
                String item = rol.get(ro);
                if (!displayableTypes.contains(item)) continue;
                displayableTypes.remove(item);
                this.addCheck(false, item);
            }
        }
        for (String type : displayableTypes) {
            this.addCheck(groupsChanged, type);
        }
        this.featurePanel.setLayout(new GridLayout(this.featurePanel.getComponentCount(), 1, 10, 5));
        this.featurePanel.validate();
        if (this.scrollPane != null) {
            this.scrollPane.validate();
        }
        this.itemStateChanged(null);
    }

    protected void pruneGroups(Set<String> foundGroups) {
        for (int g = 0; g < this.groupPanel.getComponentCount(); ++g) {
            Checkbox checkbox = (Checkbox)this.groupPanel.getComponent(g);
            if (foundGroups.contains(checkbox.getLabel())) continue;
            this.groupPanel.remove(checkbox);
        }
    }

    void addCheck(boolean groupsChanged, String type) {
        MyCheckbox check;
        Component[] comps = this.featurePanel.getComponents();
        boolean addCheck = true;
        for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
            check = (MyCheckbox)comps[i];
            if (!check.type.equals(type)) continue;
            addCheck = false;
            break;
        }
        if (addCheck) {
            boolean selected = false;
            if (groupsChanged || this.av.getFeaturesDisplayed().isVisible(type)) {
                selected = true;
            }
            check = new MyCheckbox(type, selected, false, this.fr.getFeatureStyle(type));
            check.addMouseListener(this);
            check.addMouseMotionListener(this);
            check.addItemListener(this);
            if (groupsChanged) {
                this.featurePanel.add((Component)check, 0);
            } else {
                this.featurePanel.add(check);
            }
        }
    }

    protected void invertSelection() {
        for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
            Checkbox check;
            check.setState(!(check = (Checkbox)this.featurePanel.getComponent(i)).getState());
        }
        this.selectionChanged(true);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        this.selectionChanged(true);
    }

    void selectionChanged(boolean updateOverview) {
        Component[] comps = this.featurePanel.getComponents();
        int cSize = comps.length;
        FeatureRendererModel.FeatureSettingsBean[] rowData = new FeatureRendererModel.FeatureSettingsBean[cSize];
        int i = 0;
        for (Component comp : comps) {
            MyCheckbox check = (MyCheckbox)comp;
            FeatureColourI colour = this.fr.getFeatureStyle(check.type);
            rowData[i] = new FeatureRendererModel.FeatureSettingsBean(check.type, colour, null, check.getState());
            ++i;
        }
        this.fr.setFeaturePriority(rowData);
        this.ap.paintAlignment(updateOverview, updateOverview);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (((Component)evt.getSource()).getParent() != this.featurePanel) {
            return;
        }
        this.dragging = true;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (((Component)evt.getSource()).getParent() != this.featurePanel) {
            return;
        }
        Component comp = null;
        Checkbox target = null;
        int height = evt.getY() + evt.getComponent().getLocation().y;
        comp = height > this.featurePanel.getSize().height ? this.featurePanel.getComponent(this.featurePanel.getComponentCount() - 1) : (height < 0 ? this.featurePanel.getComponent(0) : this.featurePanel.getComponentAt(evt.getX(), evt.getY() + evt.getComponent().getLocation().y));
        if (comp != null && comp instanceof Checkbox) {
            target = (Checkbox)comp;
        }
        if (this.selectedCheck != null && target != null && this.selectedCheck != target) {
            int targetIndex = -1;
            for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
                if (target != this.featurePanel.getComponent(i)) continue;
                targetIndex = i;
                break;
            }
            this.featurePanel.remove(this.selectedCheck);
            this.featurePanel.add((Component)this.selectedCheck, targetIndex);
            this.featurePanel.validate();
            this.itemStateChanged(null);
        }
    }

    public void setUserColour(String feature, FeatureColourI originalColour) {
        this.fr.setColour(feature, originalColour);
        this.refreshTable();
    }

    public void refreshTable() {
        this.featurePanel.removeAll();
        this.resetTable(false);
        this.ap.paintAlignment(true, true);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        MyCheckbox check = (MyCheckbox)evt.getSource();
        if ((evt.getModifiersEx() & 0x1000) != 0) {
            this.popupSort(check, this.fr.getMinMax(), evt.getX(), evt.getY());
        }
        if (check.getParent() != this.featurePanel) {
            return;
        }
        if (evt.getClickCount() > 1) {
            FeatureColourI fcol = this.fr.getFeatureStyle(check.type);
            if (fcol.isSimpleColour()) {
                new UserDefinedColours((Object)this, check.type, fcol.getColour());
            } else {
                new FeatureColourChooser(this, check.type);
                check.updateColor(this.fr.getFeatureStyle(check.type));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.fr.setTransparency((float)(100 - this.transparency.getValue()) / 100.0f);
        this.ap.paintAlignment(true, true);
    }

    void hideFeatureColumns(String type, boolean columnsContaining) {
        if (this.ap.alignFrame.avc.markColumnsContainingFeatures(columnsContaining, false, false, type) && this.ap.alignFrame.avc.markColumnsContainingFeatures(!columnsContaining, false, false, type)) {
            this.ap.alignFrame.viewport.hideSelectedColumns();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    class MyCheckbox
    extends Checkbox {
        public String type;
        public int stringWidth;
        boolean hasLink;
        FeatureColourI col;

        public void updateColor(FeatureColourI newcol) {
            this.col = newcol;
            if (this.col.isSimpleColour()) {
                this.setBackground(this.col.getColour());
            } else {
                Object vlabel = this.type;
                if (this.col.isAboveThreshold()) {
                    vlabel = (String)vlabel + " (>)";
                } else if (this.col.isBelowThreshold()) {
                    vlabel = (String)vlabel + " (<)";
                }
                if (this.col.isColourByLabel()) {
                    this.setBackground(Color.white);
                    vlabel = (String)vlabel + " (by Label)";
                } else {
                    this.setBackground(this.col.getMinColour());
                }
                this.setLabel((String)vlabel);
            }
            this.repaint();
        }

        public MyCheckbox(String label, boolean checked, boolean haslink) {
            super(label, checked);
            this.type = label;
            FontMetrics fm = FeatureSettings.this.av.nullFrame.getFontMetrics(FeatureSettings.this.av.nullFrame.getFont());
            this.stringWidth = fm.stringWidth(label);
            this.hasLink = haslink;
        }

        public MyCheckbox(String type, boolean selected, boolean b, FeatureColourI featureStyle) {
            this(type, selected, b);
            this.updateColor(featureStyle);
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (this.col != null) {
                if (this.col.isColourByLabel()) {
                    g.setColor(Color.white);
                    g.fillRect(d.width / 2, 0, d.width / 2, d.height);
                } else if (this.col.isGraduatedColour()) {
                    Color maxCol = this.col.getMaxColour();
                    g.setColor(maxCol);
                    g.fillRect(d.width / 2, 0, d.width / 2, d.height);
                }
            }
            if (this.hasLink) {
                g.drawImage(FeatureSettings.this.linkImage, this.stringWidth + 25, (this.getSize().height - FeatureSettings.this.linkImage.getHeight(this)) / 2, this);
            }
        }
    }
}

