/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class VueFont {
    private VARNAPanel _vp;
    private Font font;
    private JComboBox stylesBox;
    private JComboBox boxPolice;
    private JPanel panel;
    private JSlider sizeSlider;

    public VueFont(VARNAPanel vARNAPanel) {
        this._vp = vARNAPanel;
        this.init();
        this.buildViewVPTitle();
    }

    public VueFont(Font font) {
        this.font = font;
        this.init();
        this.buildViewFont();
    }

    private void init() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.boxPolice = new JComboBox<String>(stringArray);
        this.sizeSlider = new JSlider(0, 4, 88, 14);
        this.sizeSlider.setMajorTickSpacing(10);
        this.sizeSlider.setMinorTickSpacing(5);
        this.sizeSlider.setPaintTicks(true);
        this.sizeSlider.setPaintLabels(true);
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold"};
        this.stylesBox = new JComboBox<String>(stringArray2);
        this.panel = new JPanel();
        this.panel.add(this.boxPolice);
        this.panel.add(this.sizeSlider);
        this.panel.add(this.stylesBox);
    }

    private void buildViewFont() {
        this.boxPolice.setSelectedItem(this.font.getFamily());
        this.sizeSlider.setValue(this.font.getSize());
        this.stylesBox.setSelectedItem(this.styleIntToString(this.font.getStyle()));
    }

    private void buildViewVPTitle() {
        this.boxPolice.setSelectedItem(this._vp.getTitleFont().getFamily());
        this.sizeSlider.setValue(this._vp.getTitleFont().getSize());
        this.stylesBox.setSelectedItem(this.styleIntToString(this._vp.getTitleFont().getStyle()));
    }

    public String styleIntToString(int n) {
        switch (n) {
            case 0: {
                return "Plain";
            }
            case 2: {
                return "Italic";
            }
            case 1: {
                return "Bold";
            }
        }
        return "Plain";
    }

    public JComboBox getStylesBox() {
        return this.stylesBox;
    }

    public JComboBox getBoxPolice() {
        return this.boxPolice;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JSlider getSizeSlider() {
        return this.sizeSlider;
    }

    public Font getFont() {
        int n;
        switch (this.getStylesBox().getSelectedIndex()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return new Font((String)this.getBoxPolice().getSelectedItem(), n, this.getSizeSlider().getValue());
    }
}

