/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModelBaseStyle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4331494086323517208L;
    private Color _base_outline_color;
    private Color _base_inner_color;
    private Color _base_number_color;
    private Color _base_name_color;
    private boolean _selected;
    public static String XML_ELEMENT_NAME = "basestyle";
    public static String XML_VAR_OUTLINE_NAME = "outline";
    public static String XML_VAR_INNER_NAME = "inner";
    public static String XML_VAR_NUMBER_NAME = "num";
    public static String XML_VAR_NAME_NAME = "name";
    public static final String PARAM_INNER_COLOR = "fill";
    public static final String PARAM_OUTLINE_COLOR = "outline";
    public static final String PARAM_TEXT_COLOR = "label";
    public static final String PARAM_NUMBER_COLOR = "number";

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_OUTLINE_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._base_outline_color));
        attributesImpl.addAttribute("", "", XML_VAR_INNER_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._base_inner_color));
        attributesImpl.addAttribute("", "", XML_VAR_NUMBER_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._base_number_color));
        attributesImpl.addAttribute("", "", XML_VAR_NAME_NAME, "CDATA", "" + XMLUtils.toHTMLNotation(this._base_name_color));
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModelBaseStyle clone() {
        ModelBaseStyle modelBaseStyle = new ModelBaseStyle();
        modelBaseStyle._base_inner_color = this._base_inner_color;
        modelBaseStyle._base_name_color = this._base_name_color;
        modelBaseStyle._base_number_color = this._base_number_color;
        modelBaseStyle._base_outline_color = this._base_outline_color;
        modelBaseStyle._selected = this._selected;
        return modelBaseStyle;
    }

    public ModelBaseStyle() {
        this._base_outline_color = VARNAConfig.BASE_OUTLINE_COLOR_DEFAULT;
        this._base_inner_color = VARNAConfig.BASE_INNER_COLOR_DEFAULT;
        this._base_number_color = VARNAConfig.BASE_NUMBER_COLOR_DEFAULT;
        this._base_name_color = VARNAConfig.BASE_NAME_COLOR_DEFAULT;
        this._selected = false;
    }

    public ModelBaseStyle(Color color, Color color2, Color color3, Color color4, Font font) {
        this._base_outline_color = color;
        this._base_inner_color = color2;
        this._base_number_color = color3;
        this._base_name_color = color4;
    }

    public ModelBaseStyle(String string) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        this();
        this.assignParameters(string);
    }

    public ModelBaseStyle(ModelBaseStyle modelBaseStyle) {
        this._base_outline_color = modelBaseStyle.get_base_outline_color();
        this._base_inner_color = modelBaseStyle.get_base_inner_color();
        this._base_number_color = modelBaseStyle.get_base_number_color();
        this._base_name_color = modelBaseStyle.get_base_name_color();
    }

    public Color get_base_outline_color() {
        return this._base_outline_color;
    }

    public void setBaseOutlineColor(Color color) {
        this._base_outline_color = color;
    }

    public Color get_base_inner_color() {
        return this._base_inner_color;
    }

    public void setBaseInnerColor(Color color) {
        this._base_inner_color = color;
    }

    public Color get_base_number_color() {
        return this._base_number_color;
    }

    public void setBaseNumberColor(Color color) {
        this._base_number_color = color;
    }

    public Color get_base_name_color() {
        return this._base_name_color;
    }

    public void setBaseNameColor(Color color) {
        this._base_name_color = color;
    }

    public static Color getSafeColor(String string) {
        Color color;
        try {
            color = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            color = Color.getColor(string, Color.green);
        }
        return color;
    }

    public void assignParameters(String string) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        int n;
        if (string.equals("")) {
            return;
        }
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = stringArray[n].split("=");
            if (stringArray2.length != 2) {
                throw new ExceptionModeleStyleBaseSyntaxError("Bad parameter: '" + stringArray2[0] + "' ...");
            }
            arrayList.add(stringArray2[0].replace(" ", ""));
            arrayList2.add(stringArray2[1].replace(" ", ""));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_INNER_COLOR)) {
                try {
                    this.setBaseInnerColor(ModelBaseStyle.getSafeColor((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad inner color Syntax:" + (String)arrayList2.get(n));
                }
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_TEXT_COLOR)) {
                try {
                    this.setBaseNameColor(ModelBaseStyle.getSafeColor((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad name color Syntax:" + (String)arrayList2.get(n));
                }
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_NUMBER_COLOR)) {
                try {
                    this.setBaseNumberColor(ModelBaseStyle.getSafeColor((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad numbers color Syntax:" + (String)arrayList2.get(n));
                }
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_OUTLINE_COLOR)) {
                try {
                    this.setBaseOutlineColor(ModelBaseStyle.getSafeColor((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad outline color Syntax:" + (String)arrayList2.get(n));
                }
            }
            throw new ExceptionModeleStyleBaseSyntaxError("Unknown parameter:" + (String)arrayList.get(n));
        }
    }

    public static Integer StyleToInteger(String string) {
        Integer n = string.toLowerCase().equals("italic") ? Integer.valueOf(2) : (string.toLowerCase().equals("bold") ? Integer.valueOf(1) : (string.toLowerCase().equals("plain") ? Integer.valueOf(0) : null));
        return n;
    }
}

