/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpClient;
import io.github.warownia1.simplehttpclient.HttpHeaders;
import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.HttpResponse;
import io.github.warownia1.simplehttpclient.impl.HttpHeadersBuilder;
import io.github.warownia1.simplehttpclient.impl.ResponseInfoImpl;
import io.github.warownia1.simplehttpclient.impl.SimpleHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class JQueryHttpClient
implements HttpClient {
    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> handler) throws IOException {
        Object jqXHR = this.doAjax(request, false);
        return this.responseFromJqXHR(request, handler, jqXHR);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> handler, Executor executor) {
        CompletableFuture responseFuture = new CompletableFuture();
        AjaxDoneConsumer doneConsumer = (data, textStatus, jqXHR) -> {
            try {
                HttpResponse response = this.responseFromJqXHR(request, handler, jqXHR);
                responseFuture.complete(response);
            }
            catch (Exception e) {
                responseFuture.completeExceptionally(e);
            }
        };
        AjaxFailConsumer failConsumer = (jqXHR, textStatus, errorThrown) -> {
            try {
                HttpResponse response = this.responseFromJqXHR(request, handler, jqXHR);
                responseFuture.complete(response);
            }
            catch (Exception e) {
                responseFuture.completeExceptionally(e);
            }
        };
        Object XHRHandler = this.doAjax(request, true);
        return responseFuture;
    }

    private <T> HttpResponse<T> responseFromJqXHR(HttpRequest request, HttpResponse.BodyHandler<T> handler, Object jqXHR) throws IOException {
        int statusCode = 0;
        HttpHeadersBuilder responseHeaders = new HttpHeadersBuilder();
        String allHeadersText = "";
        for (String line : allHeadersText.split("\\n")) {
            int idx = line.indexOf(58);
            if (idx < 0) continue;
            String header = line.substring(0, idx);
            for (String value : line.substring(idx + 1).trim().split(",")) {
                responseHeaders.addHeader(header, value.trim());
            }
        }
        String responseText = "";
        ByteArrayInputStream stream = new ByteArrayInputStream(responseText.getBytes(StandardCharsets.UTF_8));
        HttpHeaders headers = responseHeaders.build();
        ResponseInfoImpl responseInfo = new ResponseInfoImpl(statusCode, headers, HttpClient.Version.HTTP_1_1);
        return new SimpleHttpResponse<T>(statusCode, request, headers, handler.apply(responseInfo, stream), request.uri());
    }

    private Object doAjax(HttpRequest request, boolean async) {
        String url = request.uri().toString();
        String method = request.method();
        Object headers = null;
        for (Map.Entry<String, List<String>> entry : request.headers().map().entrySet()) {
        }
        byte[] data = null;
        if (request.body().isPresent()) {
            data = request.body().get().getBytes();
        }
        long timeout = 0L;
        if (request.timeout().isPresent()) {
            timeout = request.timeout().get().toMillis();
        }
        return null;
    }

    @FunctionalInterface
    static interface AjaxFailConsumer {
        public void accept(Object var1, String var2, String var3);
    }

    @FunctionalInterface
    static interface AjaxDoneConsumer {
        public void accept(String var1, String var2, Object var3);
    }
}

