/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.robsite.jswingreader.action.AboutAction;
import org.robsite.jswingreader.action.AddRSSFeedAction;
import org.robsite.jswingreader.action.DeleteRSSFeedAction;
import org.robsite.jswingreader.action.EditRSSFeedsAction;
import org.robsite.jswingreader.action.ExitAction;
import org.robsite.jswingreader.action.LaunchBrowserOnItem;
import org.robsite.jswingreader.action.MarkChannelAsRead;
import org.robsite.jswingreader.action.MarkChannelAsUnread;
import org.robsite.jswingreader.action.MarkItemAsRead;
import org.robsite.jswingreader.action.MarkItemAsUnread;
import org.robsite.jswingreader.action.PreferencesAction;
import org.robsite.jswingreader.action.RefreshChannelAction;
import org.robsite.jswingreader.action.UpdatableAction;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.ChannelListModel;
import org.robsite.jswingreader.model.Item;
import org.robsite.jswingreader.model.SimpleRSSParser;
import org.robsite.jswingreader.ui.BlogContentPane;
import org.robsite.jswingreader.ui.ChannelsRenderer;
import org.robsite.jswingreader.ui.ItemReadTimer;
import org.robsite.jswingreader.ui.ItemsRenderer;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.util.ContextMenuMouseAdapter;

public final class MainWindow
extends JFrame {
    private JButton buttonAbout = new JButton();
    private JButton buttonRemove = new JButton();
    private JButton buttonAdd = new JButton();
    private JButton buttonEdit = new JButton();
    private JButton buttonRefresh = new JButton();
    private JToolBar toolBar = new JToolBar();
    private JLabel statusBar = new JLabel();
    private JMenuItem menuFileExit = new JMenuItem();
    private JMenuItem menuFileAdd = new JMenuItem();
    private JMenuItem menuFileDel = new JMenuItem();
    private JMenuItem menuFileRefresh = new JMenuItem();
    private JMenuItem menuHelpAbout = new JMenuItem();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuEditPreferences = new JMenuItem();
    private JMenu menuEdit = new JMenu();
    private JMenu menuHelp = new JMenu();
    private JMenuBar menuBar = new JMenuBar();
    private JPanel panelMain = new JPanel();
    private BorderLayout layoutMain = new BorderLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JSplitPane leftRightSplitPane = new JSplitPane();
    private JPanel leftPanel = new JPanel();
    private JPanel rightPanel = new JPanel();
    private JPanel topPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JSplitPane topBottomSplitPane = new JSplitPane();
    private JList listItems = new JList(new DefaultListModel());
    private BlogContentPane textDescription = new BlogContentPane();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout5 = new BorderLayout();
    private JList listChannels = new JList();
    private ChannelListModel _channelModel = null;
    private Action addAction = new AddRSSFeedAction(this.listChannels);
    private Action refreshAction = new RefreshChannelAction(this.listChannels);
    private Action editAction = new EditRSSFeedsAction(this.listChannels);
    private UpdatableAction delAction = new DeleteRSSFeedAction(this.listChannels);
    private UpdatableAction prefsAction = new PreferencesAction();
    private Action aboutAction = new AboutAction();
    private Action exitAction = new ExitAction();
    private JMenuItem menuFileEdit = new JMenuItem();
    private JLabel lblChannels = new JLabel();
    private List _updatableActions = new ArrayList();
    private ItemReadTimer _itemTimer = null;
    private JPopupMenu _popupItems = null;
    private JPopupMenu _popupChannels = null;

    MainWindow() {
        this._channelModel = Main.getChannelModel();
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.listChannels.setModel(this._channelModel);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(this.layoutMain);
        this.panelMain.setLayout(this.borderLayout1);
        this.leftRightSplitPane.setOrientation(1);
        this.leftPanel.setLayout(this.borderLayout2);
        this.rightPanel.setLayout(this.borderLayout3);
        this.topPanel.setLayout(this.borderLayout5);
        this.bottomPanel.setLayout(this.borderLayout4);
        this.topBottomSplitPane.setOrientation(0);
        this.topBottomSplitPane.setDividerLocation(100);
        this.topBottomSplitPane.setTopComponent(this.topPanel);
        this.topBottomSplitPane.setBottomComponent(this.bottomPanel);
        JScrollPane spTextDescription = new JScrollPane(this.textDescription);
        this.textDescription.setText("");
        this.setSize(new Dimension(750, 550));
        this.setTitle("JSwingReader - RSS News Feed Reader");
        this.menuFile.setText("File");
        this.menuEdit.setText("Edit");
        this.menuHelp.setText("Help");
        this.menuFileExit.setAction(this.exitAction);
        this.menuFileAdd.setAction(this.addAction);
        this.menuFileEdit.setAction(this.editAction);
        this.menuFileDel.setAction(this.delAction);
        this.menuFileRefresh.setAction(this.refreshAction);
        this.menuEditPreferences.setAction(this.prefsAction);
        this.menuHelpAbout.setAction(this.aboutAction);
        this.statusBar.setText(" [Status] ");
        this.buttonAdd.setAction(this.addAction);
        this.buttonEdit.setAction(this.editAction);
        this.buttonRemove.setAction(this.delAction);
        this.buttonAbout.setAction(this.aboutAction);
        this.buttonRefresh.setAction(this.refreshAction);
        this.menuFile.add(this.menuFileAdd);
        this.menuFile.add(this.menuFileDel);
        this.menuFile.add(this.menuFileEdit);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileRefresh);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuEdit.add(this.menuEditPreferences);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuEdit);
        this.menuHelp.add(this.menuHelpAbout);
        this.menuBar.add(this.menuHelp);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.toolBar.add(this.buttonAdd);
        this.toolBar.add(this.buttonEdit);
        this.toolBar.add(this.buttonRemove);
        this.toolBar.addSeparator();
        this.toolBar.add(this.buttonRefresh);
        this.toolBar.addSeparator();
        this.toolBar.add(this.buttonAbout);
        this.toolBar.setFloatable(false);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.leftRightSplitPane.setLeftComponent(this.leftPanel);
        this.leftRightSplitPane.setDividerLocation(200);
        this.leftRightSplitPane.setRightComponent(this.rightPanel);
        this.panelMain.add((Component)this.leftRightSplitPane, "Center");
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.rightPanel.add((Component)this.topBottomSplitPane, "Center");
        JScrollPane spListItems = new JScrollPane(this.listItems);
        this.listItems.setSelectionMode(1);
        this.topPanel.add((Component)spListItems, "Center");
        this.bottomPanel.add((Component)spTextDescription, "Center");
        this.listChannels.setSelectionMode(1);
        JScrollPane spListChannels = new JScrollPane(this.listChannels);
        this.listItems.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MainWindow.this.listItems_mouseClicked(e);
            }
        });
        this._popupItems = this._buildItemsPopupMenu();
        this._popupChannels = this._buildChannelsPopupMenu();
        ContextMenuMouseAdapter popupAdapter = new ContextMenuMouseAdapter(this._popupItems);
        ContextMenuMouseAdapter popupChannelsAdapter = new ContextMenuMouseAdapter(this._popupChannels);
        this.listItems.addMouseListener(popupAdapter);
        this.listChannels.addMouseListener(popupChannelsAdapter);
        this.listItems.setCellRenderer(new ItemsRenderer());
        this.listChannels.setCellRenderer(new ChannelsRenderer());
        this.menuFileDel.setText("Delete Channel");
        this.menuFileAdd.setText("Add Channel");
        this.menuFileEdit.setText("Edit Channels");
        this.menuFileRefresh.setText("Refresh Channel");
        this.lblChannels.setText("Channels");
        this.leftPanel.add((Component)spListChannels, "Center");
        this.leftPanel.setPreferredSize(new Dimension(200, 200));
        this.leftPanel.add((Component)this.lblChannels, "North");
    }

    private void postInit() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, (String)MainWindow.this.exitAction.getValue("Name"));
                MainWindow.this.exitAction.actionPerformed(actionEvent);
            }

            public void windowOpened(WindowEvent e) {
                MainWindow.this.listChannels.requestFocusInWindow();
            }
        });
        this.listChannels.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MainWindow.this.channel_ValueChanged(MainWindow.this.listChannels, MainWindow.this.listItems);
                }
            }
        });
        this.listItems.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MainWindow.this._itemsValueChanged(MainWindow.this.listItems);
                }
            }
        });
        this._updatableActions.add(this.delAction);
        this._updatableActions.add(this.editAction);
        this._updatableActions.add(this.prefsAction);
        this._updatableActions.add(this.refreshAction);
        if (this.listChannels.getModel().getSize() > 0) {
            this.listChannels.setSelectedIndex(0);
            this.listChannels.requestFocus(true);
        }
        this._updateAllActions();
        this.listChannels.requestFocusInWindow();
        this._updateToolbarButtons();
        this._itemTimer = new ItemReadTimer(this.listChannels, this.listItems);
        this._itemsValueChanged(this.listItems);
    }

    private JPopupMenu _buildItemsPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(new LaunchBrowserOnItem(this.listItems)));
        popup.addSeparator();
        popup.add(new JMenuItem(new MarkItemAsRead(this.listItems)));
        popup.add(new JMenuItem(new MarkItemAsUnread(this.listItems)));
        return popup;
    }

    private JPopupMenu _buildChannelsPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(new MarkChannelAsRead(this.listChannels, this.listItems)));
        popup.add(new JMenuItem(new MarkChannelAsUnread(this.listChannels, this.listItems)));
        return popup;
    }

    private void channel_ValueChanged(JList channelList, JList itemList) {
        Channel channel = (Channel)channelList.getSelectedValue();
        if (channel == null) {
            channel = new Channel();
        }
        if (!channel.isOpen() && channel.getURL() != null) {
            try {
                SimpleRSSParser.parse(channel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DefaultListModel itemsModel = (DefaultListModel)this.listItems.getModel();
        itemsModel.clear();
        Iterator iter = channel.getItems() != null ? channel.getItems().iterator() : Collections.EMPTY_LIST.iterator();
        while (iter.hasNext()) {
            itemsModel.addElement(iter.next());
        }
        if (itemsModel.getSize() > 0) {
            this.listItems.setSelectedIndex(0);
            this._itemsValueChanged(this.listItems);
        }
        this.setStatusBarText(channel.getURL());
        this._updateAllActions();
    }

    private void _itemsValueChanged(JList itemList) {
        Item item = (Item)itemList.getSelectedValue();
        if (item == null) {
            if (itemList.getModel().getSize() > 0) {
                item = (Item)itemList.getModel().getElementAt(0);
            }
            if (item == null) {
                item = new Item();
            } else {
                itemList.setSelectedIndex(0);
            }
        }
        if (this._itemTimer != null) {
            this._itemTimer.start();
            this._itemTimer.setLastItem(item);
        }
        this.setStatusBarText(item.getLink());
        this.textDescription.setBlogText(item);
        this._updateAllActions();
    }

    public void setStatusBarText(String text) {
        this.statusBar.setText(text);
    }

    private void _updateAllActions() {
        for (UpdatableAction action : this._updatableActions) {
            action.update(this);
        }
    }

    private void _updateToolbarButtons() {
        Map general = (Map)Main.getPreferences().get("general");
        if (general == null) {
            return;
        }
        Component[] components = this.toolBar.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            if (component instanceof JButton) {
                JButton button = (JButton)component;
                if (Boolean.toString(false).equals(general.get("useToolBarText"))) {
                    button.setText("");
                }
                if (Boolean.toString(true).equals(general.get("radioTextBelow"))) {
                    button.setVerticalTextPosition(3);
                    button.setHorizontalTextPosition(0);
                } else if (Boolean.toString(true).equals(general.get("radioTextRight"))) {
                    button.setVerticalTextPosition(0);
                    button.setHorizontalTextPosition(4);
                }
            }
            ++i;
        }
    }

    private void listItems_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getModifiersEx() == 0) {
            Item item = (Item)this.listItems.getSelectedValue();
            item.setRead(true);
            if (this._itemTimer != null) {
                this._itemTimer.stop();
            }
            LaunchBrowserOnItem action = new LaunchBrowserOnItem(this.listItems);
            ActionEvent event = new ActionEvent(this, 1001, "LaunchBrowserOnItem");
            action.actionPerformed(event);
        }
    }
}

