/*
 * Decompiled with CFR 0.152.
 */
package org.jcolorbrewer.ui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import org.jcolorbrewer.ColorBrewer;
import org.jcolorbrewer.ui.ColorPanelSelectionModel;
import org.jcolorbrewer.ui.PaletteIcon;

public class SequentialColorPalettePanel
extends AbstractColorChooserPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;

    @Override
    public void updateChooser() {
    }

    protected JToggleButton createPalette(ColorBrewer brewer, Border normalBorder) {
        JToggleButton palette = new JToggleButton();
        palette.setActionCommand(brewer.name());
        palette.addActionListener(this);
        PaletteIcon icon = new PaletteIcon(brewer, 5, 15, 15);
        palette.setIcon(icon);
        palette.setToolTipText(brewer.getPaletteDescription());
        palette.setBorder(normalBorder);
        return palette;
    }

    @Override
    protected void buildChooser() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new FlowLayout(2, 0, 0));
        ButtonGroup boxOfPalettes = new ButtonGroup();
        Border border = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        for (ColorBrewer palette : ColorBrewer.getSequentialColorPalettes(false)) {
            JToggleButton button = this.createPalette(palette, border);
            boxOfPalettes.add(button);
            this.add(button);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorSelectionModel model = this.getColorSelectionModel();
        String command = ((JToggleButton)e.getSource()).getActionCommand();
        for (ColorBrewer palette : ColorBrewer.getSequentialColorPalettes(false)) {
            if (!palette.name().equals(command)) continue;
            ((ColorPanelSelectionModel)model).setColorBrewer(palette);
            break;
        }
    }

    @Override
    public String getDisplayName() {
        return "Sequential";
    }

    public void stateChanged(ChangeEvent ce) {
        this.getColorSelectionModel().setSelectedColor(new Color(1));
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }
}

