/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.plaf.UIResource;

public class AsyncColorChooser
implements PropertyChangeListener {
    private ActionListener listener;
    private Color selectedColor;

    public void showDialog(Component component, String title, Color initialColor, ActionListener listener) {
        this.setListener(listener);
        this.process(JColorChooser.showDialog(component, title, initialColor));
        this.unsetListener();
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Color c = (Color)evt.getNewValue();
        switch (evt.getPropertyName()) {
            case "SelectedColor": {
                this.process(c);
            }
        }
    }

    private void setListener(ActionListener a) {
        this.listener = a;
    }

    private void unsetListener() {
    }

    private void process(Color c) {
        if (c instanceof UIResource) {
            return;
        }
        this.selectedColor = c;
        this.listener.actionPerformed(new ActionEvent(this, c == null ? 0 : c.getRGB(), c == null ? null : c.toString()));
    }
}

