/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.gui;

import jalview.analysis.AlignmentUtils;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.WebserviceInfo;
import jalview.util.ArrayUtils;
import jalview.util.MessageManager;
import jalview.ws2.actions.api.ActionI;
import jalview.ws2.actions.api.JobI;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebService;
import jalview.ws2.helpers.WSClientTaskWrapper;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;

class SearchServiceGuiHandler
implements TaskEventListener<AlignmentI> {
    private final AlignFrame parentFrame;
    private final ActionI<?> action;
    private final WebService<?> service;
    private WebserviceInfo infoPanel;
    private JobI[] jobs = new JobI[0];
    private int[] tabs = new int[0];
    private int[] logOffset = new int[0];
    private int[] errLogOffset = new int[0];

    public SearchServiceGuiHandler(ActionI<?> action, AlignFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.action = action;
        this.service = action.getWebService();
        String info = String.format("%s search using service at %s%n%s", this.service.getName(), this.service.getUrl(), this.service.getDescription());
        this.infoPanel = new WebserviceInfo(this.service.getName(), info, false);
    }

    @Override
    public void taskStarted(TaskI<AlignmentI> source, List<? extends JobI> subJobs) {
        Console.debug(String.format("task %s#%x started with %d sub-jobs", this.service.getName(), source.getUid(), subJobs.size()));
        this.jobs = subJobs.toArray(new JobI[subJobs.size()]);
        this.tabs = new int[subJobs.size()];
        this.logOffset = new int[subJobs.size()];
        this.errLogOffset = new int[subJobs.size()];
        for (int i = 0; i < subJobs.size(); ++i) {
            int tabIndex;
            JobI job = this.jobs[i];
            this.tabs[i] = tabIndex = this.infoPanel.addJobPane();
            this.infoPanel.setProgressName(String.format("region %d", i), tabIndex);
            this.infoPanel.setProgressText(tabIndex, "Job details:\n");
            if (job.getStatus() == JobStatus.INVALID) {
                this.infoPanel.setStatus(tabIndex, 2);
                continue;
            }
            if (job.getStatus() != JobStatus.READY) continue;
            this.infoPanel.setStatus(tabIndex, 0);
        }
    }

    @Override
    public void taskStatusChanged(TaskI<AlignmentI> source, JobStatus status) {
        Console.debug(String.format("task %s#%x status changed to %s", new Object[]{this.service.getName(), source.getUid(), status}));
        switch (status) {
            case INVALID: {
                this.infoPanel.setVisible(false);
                JvOptionPane.showMessageDialog((Component)this.parentFrame, MessageManager.getString("info.invalid_search_input"), MessageManager.getString("info.invalid_search_input"), 1);
                break;
            }
            case READY: {
                this.infoPanel.setthisService(new WSClientTaskWrapper(source));
                this.infoPanel.setVisible(true);
            }
            case SUBMITTED: 
            case QUEUED: {
                this.infoPanel.setStatus(0);
                break;
            }
            case RUNNING: 
            case UNKNOWN: {
                this.infoPanel.setStatus(1);
                break;
            }
            case COMPLETED: {
                this.infoPanel.setProgressBar(MessageManager.getString("status.collecting_job_results"), this.jobs[0].getInternalId());
                this.infoPanel.setStatus(2);
                break;
            }
            case FAILED: {
                this.infoPanel.removeProgressBar(this.jobs[0].getInternalId());
                this.infoPanel.setStatus(4);
                break;
            }
            case CANCELLED: {
                this.infoPanel.setStatus(3);
                break;
            }
            case SERVER_ERROR: {
                this.infoPanel.removeProgressBar(this.jobs[0].getInternalId());
                this.infoPanel.setStatus(5);
            }
        }
    }

    @Override
    public void taskCompleted(TaskI<AlignmentI> source, AlignmentI result) {
        Console.debug(String.format("task %s#%x completed", this.service.getName(), source.getUid()));
        SwingUtilities.invokeLater(() -> this.infoPanel.removeProgressBar(this.jobs[0].getInternalId()));
        if (result == null) {
            SwingUtilities.invokeLater(this.infoPanel::setFinishedNoResults);
            return;
        }
        this.infoPanel.showResultsNewFrame.addActionListener(evt -> {
            AlignmentI alnCpy = AlignmentUtils.deepCopyAlignment(result);
            this.displayResultsNewFrame(alnCpy);
        });
        SwingUtilities.invokeLater(this.infoPanel::setResultsReady);
    }

    private void displayResultsNewFrame(AlignmentI aln) {
        AlignFrame frame = new AlignFrame(aln, 700, 500);
        frame.getFeatureRenderer().transferSettings(this.parentFrame.getFeatureRenderer().getSettings());
        String actionName = this.action.getName() != null ? this.action.getName() : "Search";
        String title = String.format("%s %s of %s", this.service.getName(), actionName, this.parentFrame.getTitle());
        Desktop.addInternalFrame(frame, title, 700, 500);
    }

    @Override
    public void taskException(TaskI<AlignmentI> source, Exception e) {
        Console.error(String.format("Task %s#%x raised an exception.", this.service.getName(), source.getUid()), e);
        this.infoPanel.appendProgressText(e.getMessage());
    }

    @Override
    public void subJobStatusChanged(TaskI<AlignmentI> source, JobI job, JobStatus status) {
        int wsStatus;
        Console.debug(String.format("sub-job %x status changed to %s", new Object[]{job.getInternalId(), status}));
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        switch (status) {
            case INVALID: 
            case COMPLETED: {
                wsStatus = 2;
                break;
            }
            case READY: 
            case SUBMITTED: 
            case QUEUED: {
                wsStatus = 0;
                break;
            }
            case RUNNING: 
            case UNKNOWN: {
                wsStatus = 1;
                break;
            }
            case FAILED: {
                wsStatus = 4;
                break;
            }
            case CANCELLED: {
                wsStatus = 3;
                break;
            }
            case SERVER_ERROR: {
                wsStatus = 5;
                break;
            }
            default: {
                throw new AssertionError((Object)"Non-exhaustive switch statement");
            }
        }
        this.infoPanel.setStatus(this.tabs[i], wsStatus);
    }

    @Override
    public void subJobLogChanged(TaskI<AlignmentI> source, JobI job, String log) {
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        this.infoPanel.appendProgressText(this.tabs[i], log.substring(this.logOffset[i]));
    }

    @Override
    public void subJobErrorLogChanged(TaskI<AlignmentI> source, JobI job, String log) {
        int i = ArrayUtils.indexOf(this.jobs, job);
        assert (i >= 0) : "job does not exist";
        if (i < 0) {
            return;
        }
        this.infoPanel.appendProgressText(this.tabs[i], log.substring(this.errLogOffset[i]));
    }
}

