/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.slivka;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import jalview.ws2.client.slivka.SlivkaWSClient;
import java.io.IOException;
import java.util.regex.Matcher;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

class SlivkaAlignmentWSClient
extends SlivkaWSClient
implements AlignmentWebServiceClientI {
    SlivkaAlignmentWSClient(SlivkaClient client, SlivkaService service) {
        super(client, service);
    }

    @Override
    public AlignmentI getAlignment(WebServiceJobHandle job) throws IOException {
        for (RemoteFile f : this.client.fetchFilesList(job.getJobId())) {
            FileFormat format;
            Matcher match = mediaTypePattern.matcher(f.getMediaType());
            if (!match.find()) continue;
            String fmt = match.group(1);
            if (fmt.equalsIgnoreCase("clustal")) {
                format = FileFormat.Clustal;
            } else {
                if (!fmt.equalsIgnoreCase("fasta")) continue;
                format = FileFormat.Fasta;
            }
            return new FormatAdapter().readFile(f.getContentUrl().toString(), DataSourceType.URL, (FileFormatI)format);
        }
        Console.warn("No alignment found on the server");
        throw new IOException("no alignment found");
    }
}

