/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.api;

import java.util.Objects;

public final class Credentials {
    String username = null;
    String email = null;
    String password = null;
    private static final Credentials EMPTY = new Credentials();

    private Credentials() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public static final Credentials empty() {
        return EMPTY;
    }

    public static final Credentials usingEmail(String email) {
        Objects.requireNonNull(email);
        if (email.isEmpty()) {
            throw new IllegalArgumentException("empty email");
        }
        Credentials credentials = new Credentials();
        credentials.email = email;
        return credentials;
    }

    public static final Credentials usingEmail(String email, String password) {
        Objects.requireNonNull(email);
        Objects.requireNonNull(password);
        if (email.isEmpty()) {
            throw new IllegalArgumentException("empty email");
        }
        Credentials credentials = new Credentials();
        credentials.email = email;
        credentials.password = password;
        return credentials;
    }

    public static final Credentials usingUsername(String username, String password) {
        Objects.requireNonNull(username);
        Objects.requireNonNull(password);
        if (username.isEmpty()) {
            throw new IllegalArgumentException("empty username");
        }
        Credentials credentials = new Credentials();
        credentials.username = username;
        credentials.password = password;
        return credentials;
    }
}

