/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.api;

import jalview.bin.Console;
import jalview.ws2.actions.api.JobI;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.JobStatus;
import java.util.List;

public interface TaskEventListener<T> {
    public static final TaskEventListener NULL_LISTENER = new TaskEventListener(){

        public void taskStarted(TaskI source, List subJobs) {
            Console.info("task started with " + subJobs.size() + " jobs");
        }

        public void taskStatusChanged(TaskI source, JobStatus status) {
            Console.info("task status " + status);
        }

        public void taskCompleted(TaskI source, Object result) {
            Console.info("task completed");
        }

        public void taskException(TaskI source, Exception e) {
            Console.info("task failed", e);
        }

        public void subJobStatusChanged(TaskI source, JobI job, JobStatus status) {
            Console.info("sub-job " + job.getInternalId() + " status " + status);
        }

        public void subJobLogChanged(TaskI source, JobI job, String log) {
        }

        public void subJobErrorLogChanged(TaskI source, JobI job, String log) {
        }
    };

    default public void taskStarted(TaskI<T> source, List<? extends JobI> subJobs) {
    }

    default public void taskStatusChanged(TaskI<T> source, JobStatus status) {
    }

    default public void taskCompleted(TaskI<T> source, T result) {
    }

    default public void taskException(TaskI<T> source, Exception e) {
    }

    default public void subJobStatusChanged(TaskI<T> source, JobI job, JobStatus status) {
    }

    default public void subJobLogChanged(TaskI<T> source, JobI job, String log) {
    }

    default public void subJobErrorLogChanged(TaskI<T> source, JobI job, String log) {
    }

    public static <T> TaskEventListener<T> nullListener() {
        return NULL_LISTENER;
    }
}

