/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.annotation;

import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.util.MapList;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.ServiceInputInvalidException;
import jalview.ws2.actions.annotation.AnnotationAction;
import jalview.ws2.actions.annotation.AnnotationJob;
import jalview.ws2.actions.annotation.AnnotationResult;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.client.api.AnnotationWebServiceClientI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AnnotationTask
extends BaseTask<AnnotationJob, AnnotationResult> {
    private AnnotationWebServiceClientI client;
    private final AnnotationAction action;
    private final AlignmentI alignment;
    private final AnnotatedCollectionI selectionGroup;

    public AnnotationTask(AnnotationWebServiceClientI client, AnnotationAction action, List<ArgumentI> args, Credentials credentials, AlignViewportI viewport) {
        super(client, args, credentials);
        this.client = client;
        this.action = action;
        this.alignment = viewport.getAlignment();
        this.selectionGroup = viewport.getSelectionGroup();
    }

    @Override
    public List<AnnotationJob> prepareJobs() throws ServiceInputInvalidException {
        int minSize;
        boolean filterSymbols;
        boolean requireAligned;
        boolean submitGaps;
        AnnotationJob job;
        AnnotatedCollectionI inputSeqs;
        if (this.alignment == null || this.alignment.getWidth() <= 0 || this.alignment.getSequences() == null) {
            throw new ServiceInputInvalidException("Alignment does not contain sequences");
        }
        if (this.alignment.isNucleotide() && !this.action.doAllowNucleotide()) {
            throw new ServiceInputInvalidException(this.action.getFullName() + " does not allow nucleotide sequences");
        }
        if (!this.alignment.isNucleotide() && !this.action.doAllowProtein()) {
            throw new ServiceInputInvalidException(this.action.getFullName() + " does not allow protein sequences");
        }
        boolean bySequence = !this.action.isAlignmentAnalysis();
        AnnotatedCollectionI annotatedCollectionI = inputSeqs = bySequence ? this.selectionGroup : null;
        if (inputSeqs == null || inputSeqs.getWidth() <= 0 || inputSeqs.getSequences() == null || inputSeqs.getSequences().size() < 1) {
            inputSeqs = this.alignment;
        }
        if (!(job = AnnotationJob.create(inputSeqs, bySequence, submitGaps = this.action.isAlignmentAnalysis(), requireAligned = this.action.getRequireAlignedSequences(), filterSymbols = this.action.getFilterSymbols(), minSize = this.action.getMinSequences())).isInputValid()) {
            job.setStatus(JobStatus.INVALID);
            throw new ServiceInputInvalidException("Annotation job has invalid input");
        }
        job.setStatus(JobStatus.READY);
        return List.of(job);
    }

    @Override
    protected AnnotationResult collectResult(List<AnnotationJob> jobs) throws IOException {
        HashMap<String, FeatureColourI> featureColours = new HashMap<String, FeatureColourI>();
        HashMap<String, FeatureMatcherSetI> featureFilters = new HashMap<String, FeatureMatcherSetI>();
        AnnotationJob job = jobs.get(0);
        List<AlignmentAnnotation> returnedAnnot = this.client.attachAnnotations(job.getServerJob(), job.getInputSequences(), featureColours, featureFilters);
        this.udpateCalcId(returnedAnnot);
        for (AlignmentAnnotation ala : returnedAnnot) {
            SequenceI seq;
            SequenceI sequenceI = seq = ala.sequenceRef == null ? null : job.seqNames.get(ala.sequenceRef.getName());
            if (job.gapMap != null && job.gapMap.length > 0) {
                ala.annotations = this.createGappedAnnotations(ala.annotations, job.gapMap);
            }
            if (seq == null) continue;
            int startRes = seq.findPosition(job.regionStart);
            ala.createSequenceMapping(seq, startRes, false);
        }
        boolean hasFeatures = false;
        for (SequenceI sq : job.getInputSequences()) {
            if (!sq.getFeatures().hasFeatures() && (sq.getDBRefs() == null || sq.getDBRefs().isEmpty())) continue;
            hasFeatures = true;
            SequenceI seq = job.seqNames.get(sq.getName());
            SequenceI datasetSeq = seq.getRootDatasetSequence();
            List<ContiguousI> sourceRange = this.findContiguousRanges(seq, job.gapMap, job.regionStart, job.regionEnd);
            int[] sourceStartEnd = ContiguousI.toStartEndArray(sourceRange);
            Mapping mp = new Mapping(new MapList(sourceStartEnd, new int[]{datasetSeq.getStart(), datasetSeq.getEnd()}, 1, 1));
            datasetSeq.transferAnnotation(sq, mp);
        }
        return new AnnotationResult(returnedAnnot, hasFeatures, featureColours, featureFilters);
    }

    public void udpateCalcId(Iterable<AlignmentAnnotation> annotations) {
        for (AlignmentAnnotation annotation : annotations) {
            if (annotation.getCalcId() == null || annotation.getCalcId().isEmpty()) {
                annotation.setCalcId(this.action.getFullName());
            }
            annotation.autoCalculated = this.action.isAlignmentAnalysis() && this.action.getWebService().isInteractive();
        }
    }

    private Annotation[] createGappedAnnotations(Annotation[] annotations, boolean[] gapMap) {
        int size = Math.max(annotations.length, gapMap.length);
        Annotation[] gappedAnnotations = new Annotation[size];
        int p = 0;
        for (int ap = 0; ap < size; ++ap) {
            if (ap < gapMap.length && !gapMap[ap]) {
                gappedAnnotations[ap] = new Annotation("", "", ' ', Float.NaN);
                continue;
            }
            if (p >= annotations.length) continue;
            gappedAnnotations[ap] = annotations[p++];
        }
        return gappedAnnotations;
    }

    private List<ContiguousI> findContiguousRanges(SequenceI seq, boolean[] gapMap, int start, int end) {
        if (gapMap == null || gapMap.length < end) {
            return List.of(seq.findPositions(start + 1, end + 1));
        }
        ArrayList<ContiguousI> ranges = new ArrayList<ContiguousI>();
        int lastcol = start;
        int col = start;
        do {
            if (col != end && gapMap[col]) continue;
            if (lastcol < col) {
                ranges.add(seq.findPositions(lastcol, col));
            }
            lastcol = col + 1;
        } while (++col <= end);
        return ranges;
    }
}

