/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.annotation;

import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.ws2.actions.BaseJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationJob
extends BaseJob {
    final boolean[] gapMap;
    final Map<String, SequenceI> seqNames;
    final int regionStart;
    final int regionEnd;
    final int minSize;

    public AnnotationJob(List<SequenceI> inputSeqs, boolean[] gapMap, Map<String, SequenceI> seqNames, int start, int end, int minSize) {
        super(inputSeqs);
        this.gapMap = gapMap;
        this.seqNames = seqNames;
        this.regionStart = start;
        this.regionEnd = end;
        this.minSize = minSize;
    }

    @Override
    public boolean isInputValid() {
        int nvalid = 0;
        for (SequenceI sq : this.getInputSequences()) {
            if (sq.getStart() > sq.getEnd()) continue;
            ++nvalid;
        }
        return nvalid >= this.minSize;
    }

    public static AnnotationJob create(SequenceCollectionI inputSeqs, boolean bySequence, boolean submitGaps, boolean requireAligned, boolean filterNonStandardResidues, int minSize) {
        ArrayList<SequenceI> sequences = new ArrayList<SequenceI>();
        int minlen = 10;
        int width = 0;
        HashMap<String, SequenceI> namesMap = bySequence ? new HashMap<String, SequenceI>() : null;
        BitSet residueMap = new BitSet();
        int start = inputSeqs.getStartRes();
        int end = inputSeqs.getEndRes();
        for (SequenceI sq : inputSeqs.getSequences()) {
            Sequence seq;
            int sqLen;
            int n = sqLen = bySequence ? sq.findPosition(end + 1) - sq.findPosition(start + 1) : sq.getEnd() - sq.getStart();
            if (sqLen < minlen) continue;
            width = Math.max(width, sq.getLength());
            String newName = SeqsetUtils.unique_name(sequences.size() + 1);
            if (namesMap != null) {
                namesMap.put(newName, sq);
            }
            char[] seqChars = sq.getSequence(start, end + 1);
            if (filterNonStandardResidues) {
                AnnotationJob.replaceNonStandardResidues(seqChars, '-', sq.isProtein());
            }
            if (submitGaps) {
                seq = new Sequence(newName, seqChars);
                AnnotationJob.updateResidueMap(residueMap, seq);
            } else {
                seq = new Sequence(newName, AlignSeq.extractGaps(Comparison.GapChars, new String(seqChars)));
            }
            sequences.add(seq);
        }
        boolean[] gapMapArray = null;
        if (submitGaps) {
            AnnotationJob.adjustColumns(sequences, residueMap, requireAligned);
            gapMapArray = new boolean[width];
            for (int i = 0; i < width; ++i) {
                gapMapArray[i] = residueMap.get(i);
            }
        }
        return new AnnotationJob(sequences, gapMapArray, namesMap, start, end, minSize);
    }

    static void replaceNonStandardResidues(char[] seq, char replacement, boolean isProtein) {
        for (int i = 0; i < seq.length; ++i) {
            char chr = seq[i];
            if (!(isProtein ? ResidueProperties.aaIndex[chr] >= 20 : ResidueProperties.nucleotideIndex[chr] >= 5)) continue;
            seq[i] = replacement;
        }
    }

    static void updateResidueMap(BitSet residueMap, SequenceI seq) {
        BitSet gaps = seq.gapBitset();
        gaps.flip(0, seq.getLength());
        residueMap.or(gaps);
    }

    static void adjustColumns(List<SequenceI> sequences, BitSet mask, boolean padToLength) {
        int width = mask.cardinality();
        for (SequenceI seq : sequences) {
            char[] chars = SeqsetUtils.filterSequence(seq.getSequence(), mask);
            if (padToLength && chars.length < width) {
                int limit = chars.length;
                chars = Arrays.copyOf(chars, width);
                Arrays.fill(chars, limit, chars.length, '-');
            }
            seq.setEnd(seq.getStart());
            seq.setSequence(chars);
        }
    }
}

