/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions;

import jalview.bin.Console;
import jalview.util.ArrayUtils;
import jalview.util.MathUtils;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseJob;
import jalview.ws2.actions.ServiceInputInvalidException;
import jalview.ws2.actions.api.TaskEventListener;
import jalview.ws2.actions.api.TaskI;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.WebServiceClientI;
import jalview.ws2.helpers.DelegateJobEventListener;
import jalview.ws2.helpers.TaskEventSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class BaseTask<T extends BaseJob, R>
implements TaskI<R> {
    protected final long uid = MathUtils.getUID();
    protected final WebServiceClientI webClient;
    protected final List<ArgumentI> args;
    protected final Credentials credentials;
    private final TaskEventSupport<R> eventHandler;
    protected JobStatus status = JobStatus.CREATED;
    protected List<T> jobs = Collections.emptyList();
    protected R result = null;
    protected Runnable cancelAction = () -> {};
    static final int MAX_SUBMIT_RETRY = 5;

    protected BaseTask(WebServiceClientI webClient, List<ArgumentI> args, Credentials credentials) {
        this.webClient = webClient;
        this.args = args;
        this.credentials = credentials;
        this.eventHandler = new TaskEventSupport(this);
    }

    @Override
    public final long getUid() {
        return this.uid;
    }

    @Override
    public final JobStatus getStatus() {
        return this.status;
    }

    @Override
    public final List<T> getSubJobs() {
        return this.jobs;
    }

    @Override
    public final void addTaskEventListener(TaskEventListener<R> listener) {
        this.eventHandler.addListener(listener);
    }

    @Override
    public final void removeTaskEventListener(TaskEventListener<R> listener) {
        this.eventHandler.addListener(listener);
    }

    @Override
    public final R getResult() {
        return this.result;
    }

    @Override
    public final void init() throws Exception {
        try {
            this.jobs = this.prepareJobs();
        }
        catch (ServiceInputInvalidException e) {
            this.setStatus(JobStatus.INVALID);
            this.eventHandler.fireTaskException(e);
            throw e;
        }
        this.setStatus(JobStatus.READY);
        this.eventHandler.fireTaskStarted(this.jobs);
        DelegateJobEventListener<R> jobListener = new DelegateJobEventListener<R>(this.eventHandler);
        for (BaseJob job : this.jobs) {
            job.addPropertyChangeListener(jobListener);
        }
        this.submitJobs(this.jobs);
    }

    protected final void submitJobs(List<T> jobs) throws IOException {
        int retryCounter = 0;
        while (true) {
            try {
                this.submitJobs0(jobs);
                this.setStatus(JobStatus.SUBMITTED);
            }
            catch (IOException e) {
                this.eventHandler.fireTaskException(e);
                if (++retryCounter <= 5) continue;
                this.cancel();
                this.setStatus(JobStatus.SERVER_ERROR);
                throw e;
            }
            break;
        }
    }

    private final void submitJobs0(List<T> jobs) throws IOException {
        IOException exception = null;
        for (BaseJob job : jobs) {
            if (job.getStatus() != JobStatus.READY || !job.isInputValid()) continue;
            try {
                WebServiceJobHandle jobRef = this.webClient.submit(job.getInputSequences(), this.args, this.credentials);
                job.setServerJob(jobRef);
                job.setStatus(JobStatus.SUBMITTED);
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public final boolean poll() throws IOException {
        boolean allDone = true;
        IOException exception = null;
        for (BaseJob job : this.jobs) {
            if (job.isInputValid() && !job.getStatus().isDone()) {
                WebServiceJobHandle serverJob = job.getServerJob();
                try {
                    job.setStatus(this.webClient.getStatus(serverJob));
                    job.setLog(this.webClient.getLog(serverJob));
                    job.setErrorLog(this.webClient.getErrorLog(serverJob));
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            allDone &= job.isCompleted();
        }
        this.updateGlobalStatus();
        if (exception != null) {
            throw exception;
        }
        return allDone;
    }

    @Override
    public final void complete() throws IOException {
        for (BaseJob job : this.jobs) {
            if (job.isCompleted()) continue;
            this.cancelJob(job);
            job.setStatus(JobStatus.SERVER_ERROR);
        }
        this.updateGlobalStatus();
        try {
            this.result = this.collectResult(this.jobs);
            this.eventHandler.fireTaskCompleted(this.result);
        }
        catch (Exception e) {
            this.eventHandler.fireTaskException(e);
            this.setStatus(JobStatus.SERVER_ERROR);
            throw e;
        }
    }

    @Override
    public final void cancel() {
        this.cancelAction.run();
        for (BaseJob job : this.jobs) {
            this.cancelJob(job);
        }
        this.setStatus(JobStatus.CANCELLED);
    }

    private final void cancelJob(T job) {
        if (!((BaseJob)job).isCompleted()) {
            try {
                if (((BaseJob)job).getServerJob() != null) {
                    this.webClient.cancel(((BaseJob)job).getServerJob());
                }
                ((BaseJob)job).setStatus(JobStatus.CANCELLED);
            }
            catch (IOException e) {
                Console.error(String.format("failed to cancel job %s", ((BaseJob)job).getServerJob()), e);
            }
        }
    }

    protected final void setStatus(JobStatus status) {
        Objects.requireNonNull(status);
        if (this.status != status) {
            this.status = status;
            this.eventHandler.fireTaskStatusChanged(status);
        }
    }

    protected abstract List<T> prepareJobs() throws ServiceInputInvalidException;

    protected abstract R collectResult(List<T> var1) throws IOException;

    protected final void updateGlobalStatus() {
        int precedence = -1;
        for (BaseJob job : this.jobs) {
            JobStatus status = job.getStatus();
            int jobPrecedence = ArrayUtils.indexOf((Object[])JobStatus.statusPrecedence, (Object)status);
            if (precedence >= jobPrecedence) continue;
            precedence = jobPrecedence;
        }
        if (precedence >= 0) {
            this.setStatus(JobStatus.statusPrecedence[precedence]);
        }
    }

    public void setCancelAction(Runnable action) {
        Objects.requireNonNull(action);
        this.cancelAction = action;
    }

    public String toString() {
        String statusName = this.status != null ? this.status.name() : "UNSET";
        return String.format("%s(%x, %s)", this.getClass().getSimpleName(), this.uid, statusName);
    }
}

