/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions;

import jalview.ws2.actions.api.ActionI;
import jalview.ws2.api.CredentialType;
import jalview.ws2.api.WebService;
import java.util.EnumSet;
import java.util.Objects;

public abstract class BaseAction<R>
implements ActionI<R> {
    protected final WebService<? extends ActionI<R>> webService;
    protected final String name;
    protected final String tooltip;
    protected final String subcategory;
    protected final int minSequences;
    protected final int maxSequences;
    protected final boolean allowProtein;
    protected final boolean allowNucleotide;
    protected final EnumSet<CredentialType> requiredCredentials;

    protected BaseAction(Builder<? extends BaseAction<R>> builder) {
        Objects.requireNonNull(builder.webService);
        this.webService = builder.webService;
        this.name = builder.name;
        this.tooltip = builder.tooltip;
        this.subcategory = builder.subcategory;
        this.minSequences = builder.minSequences;
        this.maxSequences = builder.maxSequences;
        this.allowProtein = builder.allowProtein;
        this.allowNucleotide = builder.allowNucleotide;
        this.requiredCredentials = builder.requiredCredentials;
    }

    @Override
    public WebService<? extends ActionI<R>> getWebService() {
        return this.webService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.webService.getName();
        }
        return this.webService.getName() + " " + this.name;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public String getSubcategory() {
        return this.subcategory;
    }

    @Override
    public int getMinSequences() {
        return this.minSequences;
    }

    @Override
    public int getMaxSequences() {
        return this.maxSequences;
    }

    @Override
    public boolean doAllowProtein() {
        return this.allowProtein;
    }

    @Override
    public boolean doAllowNucleotide() {
        return this.allowNucleotide;
    }

    @Override
    public EnumSet<CredentialType> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public static abstract class Builder<A extends BaseAction<?>> {
        protected WebService<A> webService;
        protected String name = null;
        protected String tooltip = "";
        protected String subcategory = null;
        protected int minSequences = -1;
        protected int maxSequences = -1;
        protected boolean allowProtein = true;
        protected boolean allowNucleotide = true;
        protected EnumSet<CredentialType> requiredCredentials = EnumSet.noneOf(CredentialType.class);

        public void name(String val) {
            this.name = val;
        }

        public void webService(WebService<A> val) {
            this.webService = val;
        }

        public void tooltip(String val) {
            this.tooltip = val;
        }

        public void subcategory(String val) {
            this.subcategory = val;
        }

        public void minSequences(int val) {
            this.minSequences = val;
        }

        public void maxSequecnes(int val) {
            this.maxSequences = val;
        }

        public void allowProtein(boolean val) {
            this.allowProtein = val;
        }

        public void allowNucleotide(boolean val) {
            this.allowNucleotide = val;
        }

        public void addRequiredCredential(CredentialType val) {
            this.requiredCredentials.add(val);
        }

        public void requiredCredentials(EnumSet<CredentialType> val) {
            this.requiredCredentials = val;
        }
    }
}

