/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.slivkaws;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.DoubleParameter;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.StringParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.dundee.compbio.slivkaclient.Parameter;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaParamSet
implements WsParamSetI {
    private SlivkaService service;
    private List<ArgumentI> args = new ArrayList<ArgumentI>();

    SlivkaParamSet(SlivkaService service) {
        this.service = service;
        for (Parameter param : service.getParameters()) {
            Integer defVal;
            Number min;
            Object defaultValue;
            Object object = defaultValue = param.getDefault() instanceof List ? ((List)param.getDefault()).get(0) : param.getDefault();
            if (param instanceof Parameter.FlagParameter) {
                this.args.add(new BooleanOption(param.getId(), param.getDescription(), param.getName(), param.isRequired(), (Boolean)defaultValue, null));
                continue;
            }
            if (param instanceof Parameter.TextParameter) {
                this.args.add(new StringParameter(param.getId(), param.getDescription(), param.isRequired(), (String)defaultValue, (String)defaultValue));
                continue;
            }
            if (param instanceof Parameter.IntegerParameter) {
                min = ((Parameter.IntegerParameter)param).getMin();
                Integer max = ((Parameter.IntegerParameter)param).getMax();
                defVal = defaultValue != null ? Integer.valueOf(((Number)defaultValue).intValue()) : null;
                this.args.add(new IntegerParameter(param.getId(), param.getDescription(), param.isRequired(), defVal, min == null ? Integer.MIN_VALUE : (Integer)min, max == null ? Integer.MAX_VALUE : max));
                continue;
            }
            if (param instanceof Parameter.DecimalParameter) {
                min = ((Parameter.DecimalParameter)param).getMin();
                Double max = ((Parameter.DecimalParameter)param).getMax();
                defVal = defaultValue != null ? Double.valueOf(((Number)defaultValue).doubleValue()) : null;
                this.args.add(new DoubleParameter(param.getId(), param.getDescription(), param.isRequired(), (Double)((Object)defVal), min == null ? -1.7976931348623157E308 : (Double)min, max == null ? Double.MAX_VALUE : max));
                continue;
            }
            if (param instanceof Parameter.ChoiceParameter) {
                List choices = ((Parameter.ChoiceParameter)param).getChoices();
                if (param.isArray()) {
                    int i = 0;
                    List selected = param.getDefault() != null ? (List)param.getDefault() : Collections.EMPTY_LIST;
                    for (String choice : choices) {
                        this.args.add(new BooleanOption(String.format("%s$%d", param.getId(), i++), param.getDescription(), choice, param.isRequired(), selected.contains(choice), choice, null));
                    }
                    continue;
                }
                this.args.add(new StringParameter(param.getId(), param.getDescription(), param.isRequired(), (String)param.getDefault(), (String)defaultValue, (List<String>)choices, choices));
                continue;
            }
            if (param instanceof Parameter.FileParameter) continue;
            String defaultVal = param.getDefault() != null ? param.getDefault().toString() : null;
            this.args.add(new StringParameter(param.getId(), param.getDescription(), param.isRequired(), defaultVal, defaultVal));
        }
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public String getDescription() {
        return this.service.getDescription();
    }

    @Override
    public String[] getApplicableUrls() {
        return new String[]{this.service.getUrl().toString()};
    }

    @Override
    public String getSourceFile() {
        return null;
    }

    @Override
    public void setSourceFile(String newfile) {
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public List<ArgumentI> getArguments() {
        return this.args;
    }

    @Override
    public void setArguments(List<ArgumentI> args) {
        throw new RuntimeException();
    }
}

