/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.params;

import jalview.util.MessageManager;
import jalview.ws.params.OptionI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class JobConstant
extends InputType {
    String value;

    public JobConstant(String param, String val) {
        super(null);
        this.token = param;
        this.value = val;
    }

    @Override
    public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException {
        return new StringBody(this.value);
    }

    @Override
    public List<String> getURLEncodedParameter() {
        ArrayList<String> prm = new ArrayList<String>();
        if (this.value != null && this.value.length() > 0) {
            try {
                prm.add(URLEncoder.encode(this.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(MessageManager.formatMessage("error.couldnt_encode_as_utf8", new String[]{this.value}), ex);
            }
        }
        return prm;
    }

    @Override
    public String getURLtokenPrefix() {
        return "";
    }

    @Override
    public boolean configureFromURLtokenString(List<String> tokenstring, StringBuffer warnings) {
        if (tokenstring.size() > 1) {
            warnings.append("IMPLEMENTATION ERROR: Constant POST parameters cannot have more than one value.");
            return false;
        }
        if (tokenstring.size() == 1) {
            this.value = tokenstring.get(0);
        }
        return true;
    }

    @Override
    public boolean configureProperty(String tok, String val, StringBuffer warnings) {
        warnings.append("IMPLEMENTATION ERROR: No Properties to configure for a Constant parameter.");
        return false;
    }

    @Override
    public List<OptionI> getOptions() {
        return new ArrayList<OptionI>();
    }
}

