/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.params.simple;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.simple.Option;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class BooleanOption
extends Option {
    public static Builder newBuilder() {
        return new Builder();
    }

    protected BooleanOption(Builder builder) {
        super(builder);
        String reprValue = builder.reprValue != null ? builder.reprValue : this.name;
        this.defvalue = builder.defaultValue ? reprValue : null;
        this.value = builder.value ? reprValue : null;
        this.possibleVals = List.of(reprValue);
        this.displayVals = List.of(this.label);
    }

    public BooleanOption(String name, String descr, boolean required, Boolean defVal, Boolean val, URL link) {
        super(name, descr, required, defVal != null && defVal != false ? name : null, val != null && val != false ? name : null, Arrays.asList(name), link);
    }

    public BooleanOption(String name, String description, String label, boolean isrequired, Boolean defValue, String reprValue, URL link) {
        super(name, description, label, isrequired, defValue != null && defValue != false ? reprValue : null, defValue != null && defValue != false ? reprValue : null, Arrays.asList(reprValue), link);
    }

    public BooleanOption(String name, String description, String label, boolean isrequired, Boolean defValue, URL link) {
        this(name, description, label, isrequired, defValue, String.valueOf(true), link);
    }

    public static Boolean parseBoolean(ArgumentI argument) {
        return argument.getValue() != null && !argument.getValue().isEmpty();
    }

    public static class Builder
    extends Option.Builder {
        private boolean defaultValue = false;
        private boolean value = false;
        private String reprValue = null;

        public void setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue != null ? defaultValue : false;
        }

        public void setValue(Boolean value) {
            this.value = value != null ? value : false;
        }

        public void setReprValue(String reprValue) {
            this.reprValue = reprValue;
        }

        @Override
        public void setPossibleValues(List<String> possibleValues) {
            throw new UnsupportedOperationException("cannot set possible values for boolean");
        }

        @Override
        public BooleanOption build() {
            return new BooleanOption(this);
        }
    }
}

