/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.sequence.RNAStructReader;
import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import compbio.ws.client.Services;
import jalview.api.FeatureColourI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.util.MessageManager;
import jalview.ws.jws2.jabaws2.JabawsAnnotationInstance;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class RNAalifoldClient
extends JabawsAnnotationInstance {
    private static String CALC_ID = "jalview.ws.jws2.RNAalifoldClient";

    @Override
    public String getCalcId() {
        return CALC_ID;
    }

    public static AlignAnalysisUIText getAlignAnalysisUIText() {
        return new AlignAnalysisUIText(Services.RNAalifoldWS.toString(), RNAalifoldClient.class, CALC_ID, true, false, true, true, false, 2, MessageManager.getString("label.rnalifold_calculations"), MessageManager.getString("tooltip.rnalifold_calculations"), MessageManager.getString("label.rnalifold_settings"), MessageManager.getString("tooltip.rnalifold_settings"));
    }

    public static String getServiceActionText() {
        return "Submitting RNA alignment for Secondary Structure prediction using RNAalifold Service";
    }

    public RNAalifoldClient(Jws2Instance handle) {
        super(handle);
    }

    @Override
    List<AlignmentAnnotation> annotationFromScoreManager(AlignmentI seqs, Map<String, FeatureColourI> featureColours, Map<String, FeatureMatcherSetI> featureFilters) {
        ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
        List structs = ((RNAStructScoreManager)this.scoremanager).getStructs();
        List data = ((RNAStructScoreManager)this.scoremanager).getData();
        Score fscore = (Score)((TreeSet)data.get(0)).first();
        boolean bpScores = fscore.getMethod().equals(RNAStructReader.AlifoldResult.contactProbabilities.toString());
        RNAalifoldClient.createAnnotationRowforScoreHolder(seqs, null, ourAnnot, this.getCalcId(), (String)structs.get(0), null, null);
        RNAalifoldClient.createAnnotationRowforScoreHolder(seqs, null, ourAnnot, this.getCalcId(), (String)structs.get(1), (TreeSet)data.get(1), null);
        int count = 2;
        if (bpScores) {
            RNAalifoldClient.createAnnotationRowforScoreHolder(seqs, null, ourAnnot, this.getCalcId(), (String)structs.get(2), (TreeSet)data.get(0), (TreeSet)data.get(2));
            ++count;
        }
        for (int i = count; i < structs.size(); ++i) {
            if (((Score)((TreeSet)data.get(i)).first()).getMethod().equals(RNAStructReader.AlifoldResult.ensembleValues.toString())) continue;
            RNAalifoldClient.createAnnotationRowforScoreHolder(seqs, null, ourAnnot, this.getCalcId(), (String)structs.get(i), (TreeSet)data.get(i), null);
        }
        return ourAnnot;
    }

    private static void createAnnotationRowforScoreHolder(AlignmentI alignment, boolean[] gapMap, List<AlignmentAnnotation> ourAnnot, String calcId, String struct, TreeSet<Score> data, TreeSet<Score> descriptionData) {
        if (data == null) {
            data = RNAStructReader.newEmptyScore((Enum)RNAStructReader.AlifoldResult.consensusAlignment);
        }
        if (descriptionData == null) {
            descriptionData = data;
        }
        String[] typenameAndDescription = RNAalifoldClient.constructTypenameAndDescription((Score)descriptionData.first());
        String typename = typenameAndDescription[0];
        String description = typenameAndDescription[1];
        AlignmentAnnotation annotation = alignment.findOrCreateAnnotation(typename, calcId, false, null, null);
        RNAalifoldClient.constructAnnotationFromScoreHolder(gapMap, annotation, struct, data);
        annotation.description = description;
        annotation.belowAlignment = false;
        annotation.validateRangeAndDisplay();
        ourAnnot.add(annotation);
    }

    private static AlignmentAnnotation constructAnnotationFromScoreHolder(boolean[] gapMap, AlignmentAnnotation annotation, String struct, TreeSet<Score> data) {
        Annotation[] anns = new Annotation[gapMap != null ? gapMap.length + 1 : struct.length()];
        if (data != null && data.size() > 1 && data.first().getMethod().equals(RNAStructReader.AlifoldResult.contactProbabilities.toString())) {
            LinkedHashMap<Range, Float> basePairs = new LinkedHashMap<Range, Float>();
            for (Score score : data) {
                basePairs.put((Range)score.getRanges().first(), Float.valueOf(((Float)score.getScores().get(0)).floatValue()));
            }
            int i = 0;
            int ri = 0;
            int iEnd = struct.length();
            while (i < iEnd) {
                if (gapMap != null) {
                    while (!gapMap[ri]) {
                        ++ri;
                    }
                }
                LinkedHashMap<Range, Float> contacts = RNAalifoldClient.isContact(basePairs, i + 1);
                Object description = "";
                float prob = 0.0f;
                if (contacts.size() == 0) {
                    description = "No Data";
                } else {
                    for (Range contact : contacts.keySet()) {
                        float t = contacts.get(contact).floatValue();
                        if (t > prob) {
                            prob = t;
                        }
                        description = (String)description + Integer.toString(contact.from) + "->" + Integer.toString(contact.to) + ": " + Float.toString(t) + "%  |  ";
                    }
                }
                anns[ri] = new Annotation(struct.substring(i, i + 1), (String)description, RNAalifoldClient.isSS(struct.charAt(i)), prob);
                ++i;
                ++ri;
            }
        } else if (data == null || data.size() == 1) {
            int i = 0;
            int ri = 0;
            int iEnd = struct.length();
            while (i < iEnd) {
                if (gapMap != null) {
                    while (!gapMap[ri] && ri < gapMap.length) {
                        ++ri;
                    }
                    if (ri == gapMap.length) break;
                }
                anns[ri] = new Annotation(struct.substring(i, i + 1), "", RNAalifoldClient.isSS(struct.charAt(i)), Float.NaN);
                ++i;
                ++ri;
            }
            annotation.graph = 0;
        }
        annotation.annotations = anns;
        return annotation;
    }

    private static String[] constructTypenameAndDescription(Score score) {
        String description = "";
        String typename = "";
        String datatype = score.getMethod();
        if (datatype.equals(RNAStructReader.AlifoldResult.mfeStructure.toString())) {
            description = MessageFormat.format("Minimum Free Energy Structure. Energy: {0} = {1} + {2}", score.getScores().get(0), score.getScores().get(1), score.getScores().get(2));
            typename = "MFE Structure";
        } else if (datatype.equals(RNAStructReader.AlifoldResult.contactProbabilityStructure.toString())) {
            description = MessageFormat.format("Base Pair Contact Probabilities. Energy of Ensemble: {0}  Frequency of Ensemble: {1}", score.getScores().get(0), score.getScores().get(1));
            typename = "Contact Probabilities";
        } else if (datatype.equals(RNAStructReader.AlifoldResult.centroidStructure.toString())) {
            description = MessageFormat.format("Centroid Structure. Energy: {0} = {1} + {2}", score.getScores().get(0), score.getScores().get(1), score.getScores().get(2));
            typename = "Centroid Structure";
        } else if (datatype.equals(RNAStructReader.AlifoldResult.stochBTStructure.toString())) {
            description = score.getScores().size() > 0 ? MessageFormat.format("Probability: {0}  Energy: {1}", score.getScores().get(0), score.getScores().get(1)) : "Stochastic Backtrack Structure";
        } else if (datatype.equals(RNAStructReader.AlifoldResult.MEAStucture.toString())) {
            description = MessageFormat.format("Maximum Expected Accuracy Values: '{' {0} MEA={1} '}", score.getScores().get(0), score.getScores().get(1));
            typename = "MEA Structure";
        } else if (datatype.equals(RNAStructReader.AlifoldResult.consensusAlignment.toString())) {
            typename = "RNAalifold Consensus";
            description = "Consensus Alignment Produced by RNAalifold";
        } else {
            description = typename = datatype;
        }
        return new String[]{typename, description};
    }

    private static LinkedHashMap<Range, Float> isContact(LinkedHashMap<Range, Float> basePairs, int i) {
        LinkedHashMap<Range, Float> contacts = new LinkedHashMap<Range, Float>();
        for (Range contact : basePairs.keySet()) {
            if (contact.from != i && contact.to != i) continue;
            contacts.put(contact, basePairs.get(contact));
        }
        return contacts;
    }

    private static char isSS(char chr) {
        String regex = "\\(|\\)|\\{|\\}|\\[|\\]";
        char ss = Pattern.matches(regex, Character.toString(chr)) ? (char)'S' : ' ';
        return ss;
    }
}

