/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.sequence.Score;
import compbio.ws.client.Services;
import jalview.api.FeatureColourI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.util.MessageManager;
import jalview.ws.jws2.jabaws2.JabawsAnnotationInstance;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AAConClient
extends JabawsAnnotationInstance {
    private static String CALC_ID = "jabaws2.AACon";

    public static String getServiceActionText() {
        return "calculating Amino acid consensus using AACon service";
    }

    public static AlignAnalysisUIText getAlignAnalysisUIText() {
        return new AlignAnalysisUIText(Services.AAConWS.toString(), AAConClient.class, CALC_ID, false, true, true, true, true, 2, MessageManager.getString("label.aacon_calculations"), MessageManager.getString("tooltip.aacon_calculations"), MessageManager.getString("label.aacon_settings"), MessageManager.getString("tooltip.aacon_settings"));
    }

    public AAConClient(Jws2Instance handle) {
        super(handle);
    }

    @Override
    List<AlignmentAnnotation> annotationFromScoreManager(AlignmentI seqs, Map<String, FeatureColourI> featureColours, Map<String, FeatureMatcherSetI> featureFilters) {
        return this.aacons_annotation(seqs.getWidth(), seqs, null);
    }

    private List<AlignmentAnnotation> aacons_annotation(int alWidth, AlignmentI alignViewport, boolean[] gapMap) {
        Map scoremap = this.scoremanager.asMap();
        ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
        for (String score : scoremap.keySet()) {
            Set scores = (Set)scoremap.get(score);
            for (Score scr : scores) {
                if (scr.getRanges() != null && scr.getRanges().size() > 0) continue;
                this.createAnnotationRowsForScores(alignViewport, null, ourAnnot, this.getCalcId(), scr.getScores().size(), scr);
            }
        }
        return ourAnnot;
    }
}

