/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.ws.client.Services;
import compbio.ws.client.WSTester;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.ServiceChangeListener;
import jalview.ws.WSDiscovererI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.api.UIinfo;
import jalview.ws.jws2.JabaWsServerQuery;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ParamDatastoreI;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;

public class Jws2Discoverer
implements WSDiscovererI,
Runnable,
ApplicationSingletonProvider.ApplicationSingletonI {
    public static final String COMPBIO_JABAWS = "http://www.compbio.dundee.ac.uk/jabaws";
    private static final String JWS2HOSTURLS = "JWS2HOSTURLS";
    private List<String> testUrls = null;
    private String preferredUrl;
    private Set<ServiceChangeListener> serviceListeners = new CopyOnWriteArraySet<ServiceChangeListener>();
    private Vector<String> invalidServiceUrls = null;
    private Vector<String> urlsWithoutServices = null;
    private Vector<String> validServiceUrls = null;
    private volatile boolean running = false;
    private volatile boolean aborted = false;
    private volatile Thread oldthread = null;
    protected Vector<Jws2Instance> services;

    public static Jws2Discoverer getInstance() {
        return ApplicationSingletonProvider.getInstance(Jws2Discoverer.class);
    }

    private Jws2Discoverer() {
    }

    @Override
    public void addServiceChangeListener(ServiceChangeListener listener) {
        this.serviceListeners.add(listener);
    }

    @Override
    public void removeServiceChangeListener(ServiceChangeListener listener) {
        this.serviceListeners.remove(listener);
    }

    private void notifyServiceListeners(List<? extends ServiceWithParameters> services) {
        if (services == null) {
            services = this.services;
        }
        for (ServiceChangeListener listener : this.serviceListeners) {
            listener.servicesChanged(this, services);
        }
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    @Override
    public void run() {
        if (this.running && this.oldthread != null && this.oldthread.isAlive()) {
            if (!this.aborted) {
                return;
            }
            while (this.running) {
                try {
                    Console.debug("Waiting around for old discovery thread to finish.");
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            this.aborted = false;
            Console.debug("Old discovery thread has finished.");
        }
        this.running = true;
        HashSet<String> ignoredServices = new HashSet<String>();
        for (String string : Cache.getDefault("IGNORED_JABAWS_SERVICETYPES", "").split("\\|")) {
            ignoredServices.add(string);
        }
        this.notifyServiceListeners(Collections.emptyList());
        this.oldthread = Thread.currentThread();
        try {
            this.getClass().getClassLoader().loadClass("compbio.ws.client.Jws2Client");
        }
        catch (ClassNotFoundException e) {
            Console.errPrintln("Not enabling JABA Webservices : client jar is not available.\nPlease check that your webstart JNLP file is up to date!");
            this.running = false;
            return;
        }
        if (this.services != null) {
            this.services.removeAllElements();
        }
        if (this.urlsWithoutServices != null) {
            this.urlsWithoutServices.removeAllElements();
        }
        if (this.invalidServiceUrls != null) {
            this.invalidServiceUrls.removeAllElements();
        }
        if (this.validServiceUrls != null) {
            this.validServiceUrls.removeAllElements();
        }
        ArrayList<String> svctypes = new ArrayList<String>();
        ArrayList<JabaWsServerQuery> qrys = new ArrayList<JabaWsServerQuery>();
        for (String string : this.getServiceUrls()) {
            JabaWsServerQuery squery = new JabaWsServerQuery(this, string);
            if (svctypes.size() == 0) {
                for (Services sv : squery.JABAWS2SERVERS) {
                    if (ignoredServices.contains(sv.toString())) continue;
                    svctypes.add(sv.toString());
                }
            }
            qrys.add(squery);
            new Thread(squery).start();
        }
        boolean finished = true;
        do {
            finished = true;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (JabaWsServerQuery squery : qrys) {
                if (!squery.isRunning()) continue;
                finished = false;
            }
            if (!this.aborted) continue;
            Console.debug("Aborting " + qrys.size() + " JABAWS discovery threads.");
            for (JabaWsServerQuery squery : qrys) {
                squery.setQuit(true);
            }
        } while (!this.aborted && !finished);
        if (!this.aborted && this.services != null && this.services.size() > 0) {
            Object[] objectArray = new Jws2Instance[this.services.size()];
            int[] spos = new int[this.services.size()];
            int ipos = 0;
            List<String> svcUrls = this.getServiceUrls();
            for (Jws2Instance svc : this.services) {
                objectArray[ipos] = svc;
                spos[ipos++] = 1000 * svcUrls.indexOf(svc.getHostURL()) + 1 + svctypes.indexOf(svc.getName());
            }
            QuickSort.sort(spos, objectArray);
            this.services = new Vector();
            for (Object svc : objectArray) {
                if (ignoredServices.contains(((UIinfo)svc).getName())) continue;
                this.services.add((Jws2Instance)svc);
            }
        }
        this.oldthread = null;
        this.running = false;
        this.notifyServiceListeners(this.services);
    }

    synchronized void addService(String jwsservers, Jws2Instance service) {
        if (this.services == null) {
            this.services = new Vector();
        }
        Console.info("Discovered service: " + jwsservers + " " + service.toString());
        this.services.add(service);
        ParamDatastoreI pds = service.getParamStore();
        if (pds != null) {
            pds.getPresets();
        }
        service.hasParameters();
        if (this.validServiceUrls == null) {
            this.validServiceUrls = new Vector();
        }
        this.validServiceUrls.add(jwsservers);
    }

    public static void main(String[] args) {
        Jws2Discoverer instance = Jws2Discoverer.getInstance();
        if (args.length > 0) {
            instance.testUrls = new ArrayList<String>();
            for (String url : args) {
                instance.testUrls.add(url);
            }
        }
        Jws2Discoverer discoverer = Jws2Discoverer.getInstance();
        discoverer.addServiceChangeListener((_discoverer, _services) -> {
            if (discoverer.services != null) {
                Console.outPrintln("Changesupport: There are now " + discoverer.services.size() + " services");
                int i = 1;
                for (ServiceWithParameters serviceWithParameters : discoverer.services) {
                    Console.outPrintln("Service " + i++ + " " + serviceWithParameters.getClass() + "@" + serviceWithParameters.getHostURL() + ": " + serviceWithParameters.getActionText());
                }
            }
        });
        try {
            discoverer.startDiscoverer().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasServices() {
        return !this.running && this.services != null && this.services.size() > 0;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setServiceUrls(List<String> wsUrls) {
        if (wsUrls != null && !wsUrls.isEmpty()) {
            StringBuilder urls = new StringBuilder(128);
            String sep = "";
            for (String url : wsUrls) {
                urls.append(sep);
                urls.append(url);
                sep = ",";
            }
            Cache.setProperty(JWS2HOSTURLS, urls.toString());
        } else {
            Cache.removeProperty(JWS2HOSTURLS);
        }
    }

    @Override
    public List<String> getServiceUrls() {
        if (this.testUrls != null) {
            return this.testUrls;
        }
        ArrayList<String> urls = new ArrayList<String>();
        if (this.preferredUrl != null) {
            urls.add(this.preferredUrl);
        }
        String surls = Cache.getDefault(JWS2HOSTURLS, COMPBIO_JABAWS);
        try {
            StringTokenizer st = new StringTokenizer(surls, ",");
            while (st.hasMoreElements()) {
                String url = null;
                try {
                    url = st.nextToken();
                    new URL(url);
                    if (!urls.contains(url)) {
                        urls.add(url);
                        continue;
                    }
                    Console.warn("Ignoring duplicate url " + url + " in JWS2HOSTURLS list");
                }
                catch (MalformedURLException ex) {
                    Console.warn("Problem whilst trying to make a URL from '" + (url != null ? url : "<null>") + "'");
                    Console.warn("This was probably due to a malformed comma separated list in the JWS2HOSTURLS entry of $(HOME)/.jalview_properties)");
                    Console.debug("Exception was ", ex);
                }
            }
        }
        catch (Exception ex) {
            Console.warn("Error parsing comma separated list of urls in JWS2HOSTURLS preference.", ex);
        }
        return urls;
    }

    public Vector<ServiceWithParameters> getServices() {
        return this.services == null ? new Vector<ServiceWithParameters>() : new Vector<Jws2Instance>(this.services);
    }

    @Override
    public boolean testServiceUrl(URL foo) {
        try {
            WSTester.main((String[])new String[]{"-h=" + foo.toString()});
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart() {
        Jws2Discoverer jws2Discoverer = this;
        synchronized (jws2Discoverer) {
            if (this.running) {
                this.aborted = true;
            } else {
                this.running = true;
            }
            return this.aborted;
        }
    }

    @Override
    public CompletableFuture<WSDiscovererI> startDiscoverer() {
        if (this.isRunning()) {
            this.setAborted(true);
        }
        CompletableFuture<WSDiscovererI> task = CompletableFuture.supplyAsync(() -> {
            this.run();
            return this;
        });
        return task;
    }

    public Vector<String> getInvalidServiceUrls() {
        return this.invalidServiceUrls;
    }

    public Vector<String> getUrlsWithoutServices() {
        return this.urlsWithoutServices;
    }

    public synchronized void addUrlwithnoservices(String jwsservers) {
        if (this.urlsWithoutServices == null) {
            this.urlsWithoutServices = new Vector();
        }
        if (!(this.invalidServiceUrls != null && this.invalidServiceUrls.contains(jwsservers) || this.urlsWithoutServices.contains(jwsservers))) {
            this.urlsWithoutServices.add(jwsservers);
        }
    }

    public synchronized void addInvalidServiceUrl(String jwsservers) {
        if (this.invalidServiceUrls == null) {
            this.invalidServiceUrls = new Vector();
        }
        if (!this.invalidServiceUrls.contains(jwsservers)) {
            this.invalidServiceUrls.add(jwsservers);
        }
    }

    @Override
    public String getErrorMessages() {
        if (!this.isRunning() && !this.isAborted()) {
            StringBuffer ermsg = new StringBuffer();
            boolean list = false;
            if (this.getInvalidServiceUrls() != null && this.getInvalidServiceUrls().size() > 0) {
                ermsg.append(MessageManager.getString("warn.urls_not_contacted") + ": \n");
                for (String svcurl : this.getInvalidServiceUrls()) {
                    if (list) {
                        ermsg.append(", ");
                    }
                    list = true;
                    ermsg.append(svcurl);
                }
                ermsg.append("\n\n");
            }
            list = false;
            if (this.getUrlsWithoutServices() != null && this.getUrlsWithoutServices().size() > 0) {
                ermsg.append(MessageManager.getString("warn.urls_no_jaba") + ": \n");
                for (String svcurl : this.getUrlsWithoutServices()) {
                    if (list) {
                        ermsg.append(", ");
                    }
                    list = true;
                    ermsg.append(svcurl);
                }
                ermsg.append("\n");
            }
            if (ermsg.length() > 1) {
                return ermsg.toString();
            }
        }
        return null;
    }

    @Override
    public int getServerStatusFor(String url) {
        if (this.validServiceUrls != null && this.validServiceUrls.contains(url)) {
            return 1;
        }
        if (this.urlsWithoutServices != null && this.urlsWithoutServices.contains(url)) {
            return 0;
        }
        if (this.invalidServiceUrls != null && this.invalidServiceUrls.contains(url)) {
            return -1;
        }
        return -2;
    }

    public void setPreferredUrl(String value) throws MalformedURLException {
        if (value != null && value.trim().length() > 0) {
            new URL(value);
            this.preferredUrl = value;
        }
    }
}

