/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.api.AlignCalcManagerI2;
import jalview.api.AlignCalcWorkerI;
import jalview.bin.Console;
import jalview.gui.AlignFrame;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.jws2.PreferredServiceRegistry;
import jalview.ws.jws2.SeqAnnotationServiceCalcWorker;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.AutoCalcSetting;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class Jws2ClientFactory {
    static boolean registerAAConWSInstance(JMenu wsmenu, ServiceWithParameters service, final AlignFrame alignFrame) {
        List<AlignCalcWorkerI> aaconClient;
        final AlignAnalysisUIText aaui = service.getAlignAnalysisUI();
        if (aaui == null) {
            return false;
        }
        JCheckBoxMenuItem _aaConEnabled = null;
        for (int i = 0; i < wsmenu.getItemCount(); ++i) {
            JMenuItem item = wsmenu.getItem(i);
            if (!(item instanceof JCheckBoxMenuItem) || !item.getText().equals(aaui.getAAconToggle())) continue;
            _aaConEnabled = (JCheckBoxMenuItem)item;
        }
        AlignCalcManagerI2 mger = alignFrame.getViewport().getCalcManager();
        if (mger != null && (aaconClient = mger.getWorkersOfClass(aaui.getClient())) != null && aaconClient.size() > 0) {
            SeqAnnotationServiceCalcWorker worker = (SeqAnnotationServiceCalcWorker)aaconClient.get(0);
            if (!worker.service.getHostURL().equals(service.getHostURL())) {
                Jws2ClientFactory.removeCurrentAAConWorkerFor(aaui, alignFrame);
                Jws2ClientFactory.buildCurrentAAConWorkerFor(aaui, alignFrame, service);
            }
        }
        if (_aaConEnabled == null) {
            final JCheckBoxMenuItem aaConEnabled = new JCheckBoxMenuItem(aaui.getAAconToggle());
            aaConEnabled.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAconToggleTooltip()));
            aaConEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getWorkersOfClass(SeqAnnotationServiceCalcWorker.class);
                    if (aaconClient != null) {
                        for (AlignCalcWorkerI worker : aaconClient) {
                            if (!((SeqAnnotationServiceCalcWorker)worker).getService().getClass().equals(aaui.getClient())) continue;
                            Jws2ClientFactory.removeCurrentAAConWorkerFor(aaui, alignFrame);
                            return;
                        }
                    }
                    Jws2ClientFactory.buildCurrentAAConWorkerFor(aaui, alignFrame);
                }
            });
            wsmenu.add(aaConEnabled);
            final JMenuItem modifyParams = new JMenuItem(aaui.getAAeditSettings());
            modifyParams.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAeditSettingsTooltip()));
            modifyParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Jws2ClientFactory.showAAConAnnotationSettingsFor(aaui, alignFrame);
                }
            });
            wsmenu.add(modifyParams);
            wsmenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent arg0) {
                    if (!(alignFrame.getViewport().getAlignment().isNucleotide() ? aaui.isNa() : aaui.isPr())) {
                        aaConEnabled.setEnabled(false);
                        modifyParams.setEnabled(false);
                        return;
                    }
                    aaConEnabled.setEnabled(true);
                    modifyParams.setEnabled(true);
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getWorkersOfClass(SeqAnnotationServiceCalcWorker.class);
                    boolean serviceEnabled = false;
                    if (aaconClient != null) {
                        for (AlignCalcWorkerI _worker : aaconClient) {
                            SeqAnnotationServiceCalcWorker worker = (SeqAnnotationServiceCalcWorker)_worker;
                            if (!worker.hasService() || !aaui.getClient().equals(worker.getService().getClass())) continue;
                            serviceEnabled = true;
                        }
                    }
                    aaConEnabled.setSelected(serviceEnabled);
                }

                @Override
                public void menuDeselected(MenuEvent arg0) {
                }

                @Override
                public void menuCanceled(MenuEvent arg0) {
                }
            });
        }
        return true;
    }

    private static void showAAConAnnotationSettingsFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        AutoCalcSetting fave = alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2ClientFactory.createDefaultAAConSettings(aaui);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, true);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        Jws2ClientFactory.buildCurrentAAConWorkerFor(aaui, alignFrame, null);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame, ServiceWithParameters service) {
        AutoCalcSetting fave = alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2ClientFactory.createDefaultAAConSettings(aaui, service);
        } else if (service != null && !fave.getService().getHostURL().equals(service.getHostURL())) {
            Console.debug("Changing AACon service to " + service.getHostURL() + " from " + fave.getService().getHostURL());
            fave.setService(service);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, false);
    }

    private static AutoCalcSetting createDefaultAAConSettings(AlignAnalysisUIText aaui) {
        return Jws2ClientFactory.createDefaultAAConSettings(aaui, null);
    }

    private static AutoCalcSetting createDefaultAAConSettings(AlignAnalysisUIText aaui, ServiceWithParameters service) {
        if (service != null && !PreferredServiceRegistry.getRegistry().contains(service)) {
            service = null;
        }
        if (service == null) {
            service = PreferredServiceRegistry.getRegistry().getPreferredServiceFor(null, aaui.getServiceType());
        }
        if (service == null) {
            throw new Error(MessageManager.getString("error.no_aacon_service_found"));
        }
        return service instanceof Jws2Instance ? new AAConSettings(true, service, null, null) : new AutoCalcSetting(service, null, null, true);
    }

    private static void removeCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        alignFrame.getViewport().getCalcManager().removeWorkersOfClass(aaui.getClient());
    }
}

