/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.gui;

import jalview.analysis.AlignSeq;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.SeqsetUtils;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.ws.gui.MsaWSThread;
import jalview.ws.gui.WsJob;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.params.ArgumentI;
import java.util.ArrayList;
import java.util.Vector;

class MsaWSJob
extends WsJob {
    private final MsaWSThread msaWSThread;
    long lastChunk = 0L;
    ArrayList<SequenceI> seqs = new ArrayList();
    AlignmentI alignment;
    private boolean returnInput = false;
    Vector<String[]> emptySeqs = new Vector();
    StringBuffer jobProgress = new StringBuffer();
    String alignmentProgram = null;

    public MsaWSJob(MsaWSThread msaWSThread, int jobNum, SequenceI[] inSeqs) {
        this.msaWSThread = msaWSThread;
        this.jobnum = jobNum;
        if (!this.prepareInput(inSeqs, 2)) {
            this.submitted = true;
            this.subjobComplete = true;
            this.returnInput = true;
        } else {
            this.validInput = true;
        }
    }

    private boolean prepareInput(SequenceI[] seqs, int minlen) {
        int nseqs = 0;
        if (minlen < 0) {
            throw new Error(MessageManager.getString("error.implementation_error_minlen_must_be_greater_zero"));
        }
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].getEnd() - seqs[i].getStart() <= minlen - 1) continue;
            ++nseqs;
        }
        boolean valid = nseqs > 1;
        boolean n = false;
        for (int i = 0; i < seqs.length; ++i) {
            String newname = SeqsetUtils.unique_name(i);
            this.SeqNames.put(newname, SeqsetUtils.SeqCharacterHash(seqs[i]));
            if (valid && seqs[i].getEnd() - seqs[i].getStart() > minlen - 1) {
                Sequence seq = new Sequence(newname, this.msaWSThread.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString()));
                this.seqs.add(seq);
                continue;
            }
            String empty = null;
            if (seqs[i].getEnd() >= seqs[i].getStart()) {
                empty = this.msaWSThread.submitGaps ? seqs[i].getSequenceAsString() : AlignSeq.extractGaps(Comparison.GapChars, seqs[i].getSequenceAsString());
            }
            this.emptySeqs.add(new String[]{newname, empty});
        }
        return valid;
    }

    @Override
    public boolean hasResults() {
        return this.subjobComplete && this.isFinished() && (this.alignment != null || this.emptySeqs != null && this.emptySeqs.size() > 0);
    }

    public Object[] getAlignment() {
        if (this.hasResults()) {
            SequenceI[] alseqs = null;
            char alseq_gapchar = '-';
            int alseq_l = 0;
            alseqs = new SequenceI[this.alignment.getSequences().size()];
            if (this.alignment.getSequences().size() > 0) {
                for (SequenceI seq : this.alignment.getSequences()) {
                    alseqs[alseq_l++] = new Sequence(seq);
                }
                alseq_gapchar = this.alignment.getGapCharacter();
            }
            if (this.emptySeqs.size() > 0) {
                int sw;
                int i;
                SequenceI[] t_alseqs = new SequenceI[alseq_l + this.emptySeqs.size()];
                int w = 0;
                if (alseq_l > 0) {
                    w = alseqs[0].getLength();
                    for (int i2 = 0; i2 < alseq_l; ++i2) {
                        if (w < alseqs[i2].getLength()) {
                            w = alseqs[i2].getLength();
                        }
                        t_alseqs[i2] = alseqs[i2];
                        alseqs[i2] = null;
                    }
                }
                int ow = w;
                int nw = w;
                w = this.emptySeqs.size();
                for (i = 0; i < w; ++i) {
                    String[] es = this.emptySeqs.get(i);
                    if (es == null || es[1] == null || nw >= (sw = es[1].length())) continue;
                    nw = sw;
                }
                StringBuffer insbuff = new StringBuffer(w);
                for (i = 0; i < nw; ++i) {
                    insbuff.append(alseq_gapchar);
                }
                if (ow < nw) {
                    for (i = 0; i < alseq_l; ++i) {
                        sw = t_alseqs[i].getLength();
                        if (nw <= sw) continue;
                        alseqs[i].setSequence(t_alseqs[i].getSequenceAsString() + insbuff.substring(0, sw - nw));
                    }
                }
                w = this.emptySeqs.size();
                for (i = 0; i < w; ++i) {
                    String[] es = this.emptySeqs.get(i);
                    t_alseqs[i + alseq_l] = es[1] == null ? new Sequence(es[0], insbuff.toString(), 1, 0) : (es[1].length() < nw ? new Sequence(es[0], es[1] + insbuff.substring(0, nw - es[1].length()), 1, 1 + es[1].length()) : new Sequence(es[0], es[1]));
                }
                alseqs = t_alseqs;
            }
            AlignmentOrder msaorder = new AlignmentOrder(alseqs);
            AlignmentSorter.recoverOrder(alseqs);
            SeqsetUtils.deuniquify(this.SeqNames, alseqs);
            return new Object[]{alseqs, msaorder};
        }
        return null;
    }

    void cancel() {
        this.cancelled = true;
        this.subjobComplete = true;
        this.alignment = null;
    }

    @Override
    public boolean hasValidInput() {
        return this.seqs != null && this.seqs.size() >= 2;
    }

    @Override
    public void setStatus(String string) {
        this.jobProgress.setLength(0);
        this.jobProgress.append(string);
    }

    @Override
    public String getStatus() {
        return this.jobProgress.toString();
    }

    @Override
    public boolean hasStatus() {
        return this.jobProgress != null;
    }

    public long getLastChunk() {
        return this.lastChunk;
    }

    public void setLastChunk(long lastChunk) {
        this.lastChunk = lastChunk;
    }

    public String getAlignmentProgram() {
        return this.alignmentProgram;
    }

    public boolean hasArguments() {
        return this.arguments != null && this.arguments.size() > 0 || this.preset != null && this.preset instanceof JabaWsParamSet;
    }

    public void addInitialStatus() {
        if (this.preset != null) {
            this.jobProgress.append("Using " + (this.preset.isModifiable() ? "Server" : "User") + "Preset: " + this.preset.getName());
            for (ArgumentI opt : this.preset.getArguments()) {
                this.jobProgress.append(opt.getName() + " " + opt.getValue() + "\n");
            }
        } else {
            if (this.arguments != null && this.arguments.size() > 0) {
                this.jobProgress.append("With custom parameters : \n");
                for (ArgumentI opt : this.arguments) {
                    this.jobProgress.append(opt.getName() + " " + opt.getValue() + "\n");
                }
            }
            this.jobProgress.append("\nJob Output:\n");
        }
    }
}

