/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.workers.AlignCalcWorker;

public class ConsensusThread
extends AlignCalcWorker {
    public ConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    public void run() {
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        AlignmentAnnotation gap = this.getGapAnnotation();
        if (consensus == null && gap == null) {
            return;
        }
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        AlignmentI alignment = this.alignViewport.getAlignment();
        int aWidth = -1;
        if (alignment == null || (aWidth = alignment.getWidth()) < 0) {
            return;
        }
        this.eraseConsensus(aWidth);
        this.computeConsensus(alignment);
        this.updateResultAnnotation(true);
        if (this.ap != null) {
            this.ap.paintAlignment(true, true);
        }
    }

    protected void eraseConsensus(int aWidth) {
        AlignmentAnnotation gap;
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        if (consensus != null) {
            consensus.annotations = new Annotation[aWidth];
        }
        if ((gap = this.getGapAnnotation()) != null) {
            gap.annotations = new Annotation[aWidth];
        }
    }

    protected void computeConsensus(AlignmentI alignment) {
        SequenceI[] aseqs = this.getSequences();
        int width = alignment.getWidth();
        ProfilesI hconsensus = AAFrequency.calculate(aseqs, width, 0, width, true);
        this.alignViewport.setSequenceConsensusHash(hconsensus);
        this.setColourSchemeConsensus(hconsensus);
    }

    protected SequenceI[] getSequences() {
        return this.alignViewport.getAlignment().getSequencesArray();
    }

    protected void setColourSchemeConsensus(ProfilesI hconsensus) {
        ResidueShaderI cs = this.alignViewport.getResidueShading();
        if (cs != null) {
            cs.setConsensus(hconsensus);
        }
    }

    protected AlignmentAnnotation getConsensusAnnotation() {
        return this.alignViewport.getAlignmentConsensusAnnotation();
    }

    protected AlignmentAnnotation getGapAnnotation() {
        return this.alignViewport.getAlignmentGapAnnotation();
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        AlignmentAnnotation consensus = this.getConsensusAnnotation();
        ProfilesI hconsensus = (ProfilesI)this.getViewportConsensus();
        if (immediate || !this.calcMan.isWorking(this) && consensus != null && hconsensus != null) {
            this.deriveConsensus(consensus, hconsensus);
            AlignmentAnnotation gap = this.getGapAnnotation();
            if (gap != null) {
                this.deriveGap(gap, hconsensus);
            }
        }
    }

    protected void deriveConsensus(AlignmentAnnotation consensusAnnotation, ProfilesI hconsensus) {
        long nseq = this.getSequences().length;
        consensusAnnotation.setNoOfSequencesIncluded(nseq);
        AAFrequency.completeConsensus(consensusAnnotation, hconsensus, hconsensus.getStartColumn(), hconsensus.getEndColumn() + 1, this.alignViewport.isIgnoreGapsConsensus(), this.alignViewport.isShowSequenceLogo(), nseq);
    }

    protected void deriveGap(AlignmentAnnotation gapAnnotation, ProfilesI hconsensus) {
        long nseq = this.getSequences().length;
        gapAnnotation.setNoOfSequencesIncluded(nseq);
        AAFrequency.completeGapAnnot(gapAnnotation, hconsensus, hconsensus.getStartColumn(), hconsensus.getEndColumn() + 1, nseq);
    }

    protected Object getViewportConsensus() {
        return this.alignViewport.getSequenceConsensusHash();
    }
}

