/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignCalcListener;
import jalview.api.AlignCalcManagerI2;
import jalview.api.AlignCalcWorkerI;
import jalview.api.PollableAlignCalcWorkerI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AlignCalcManager2
implements AlignCalcManagerI2 {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final Map<AlignCalcWorkerI, WorkerManager> registered = Collections.synchronizedMap(new HashMap());
    private final Map<AlignCalcWorkerI, WorkerManager> oneshot = Collections.synchronizedMap(new WeakHashMap());
    private final List<AlignCalcListener> listeners = new CopyOnWriteArrayList<AlignCalcListener>();

    private WorkerManager createManager(AlignCalcWorkerI worker) {
        if (worker instanceof PollableAlignCalcWorkerI) {
            return new PollableWorkerManager((PollableAlignCalcWorkerI)worker);
        }
        return new SimpleWorkerManager(worker);
    }

    @Override
    public void registerWorker(AlignCalcWorkerI worker) {
        Objects.requireNonNull(worker);
        WorkerManager manager = this.createManager(worker);
        this.registered.putIfAbsent(worker, manager);
        this.startWorker(worker);
    }

    @Override
    public List<AlignCalcWorkerI> getWorkers() {
        ArrayList<AlignCalcWorkerI> result = new ArrayList<AlignCalcWorkerI>(this.registered.size());
        result.addAll(this.registered.keySet());
        return result;
    }

    @Override
    public List<AlignCalcWorkerI> getWorkersOfClass(Class<? extends AlignCalcWorkerI> cls) {
        ArrayList<AlignCalcWorkerI> collected = new ArrayList<AlignCalcWorkerI>();
        for (AlignCalcWorkerI worker : this.getWorkers()) {
            if (!worker.getClass().equals(cls)) continue;
            collected.add(worker);
        }
        return Collections.unmodifiableList(collected);
    }

    @Override
    public void removeWorker(AlignCalcWorkerI worker) {
        if (worker.isDeletable()) {
            this.registered.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkerForAnnotation(AlignmentAnnotation annot) {
        Map<AlignCalcWorkerI, WorkerManager> map = this.registered;
        synchronized (map) {
            for (AlignCalcWorkerI worker : this.getWorkers()) {
                if (!worker.involves(annot)) continue;
                this.removeWorker(worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkersOfClass(Class<? extends AlignCalcWorkerI> cls) {
        Map<AlignCalcWorkerI, WorkerManager> map = this.registered;
        synchronized (map) {
            for (AlignCalcWorkerI worker : this.getWorkers()) {
                if (!worker.getClass().equals(cls)) continue;
                this.removeWorker(worker);
            }
        }
    }

    @Override
    public void disableWorker(AlignCalcWorkerI worker) {
        this.registered.get(worker).setEnabled(false);
    }

    @Override
    public void enableWorker(AlignCalcWorkerI worker) {
        this.registered.get(worker).setEnabled(true);
    }

    @Override
    public boolean isDisabled(AlignCalcWorkerI worker) {
        if (this.registered.containsKey(worker)) {
            return !this.registered.get(worker).isEnabled();
        }
        return false;
    }

    @Override
    public boolean isWorking(AlignCalcWorkerI worker) {
        WorkerManager manager = this.registered.get(worker);
        if (manager == null) {
            manager = this.oneshot.get(worker);
        }
        if (manager == null) {
            return false;
        }
        return manager.isWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWorkingWithAnnotation(AlignmentAnnotation annot) {
        Map<AlignCalcWorkerI, WorkerManager> map = this.registered;
        synchronized (map) {
            for (Map.Entry<AlignCalcWorkerI, WorkerManager> entry : this.registered.entrySet()) {
                if (!entry.getKey().involves(annot) || !entry.getValue().isWorking()) continue;
                return true;
            }
        }
        map = this.oneshot;
        synchronized (map) {
            for (Map.Entry<AlignCalcWorkerI, WorkerManager> entry : this.registered.entrySet()) {
                if (!entry.getKey().involves(annot) || !entry.getValue().isWorking()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWorking() {
        Map<AlignCalcWorkerI, WorkerManager> map = this.registered;
        synchronized (map) {
            for (WorkerManager manager : this.registered.values()) {
                if (!manager.isWorking()) continue;
                return true;
            }
        }
        map = this.oneshot;
        synchronized (map) {
            for (WorkerManager manager : this.oneshot.values()) {
                if (!manager.isWorking()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void startWorker(AlignCalcWorkerI worker) {
        Objects.requireNonNull(worker);
        WorkerManager manager = this.registered.get(worker);
        if (manager == null) {
            Console.warn("Starting unregistered worker " + worker);
            manager = this.createManager(worker);
            this.oneshot.put(worker, manager);
        }
        manager.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWorkers() {
        Map<AlignCalcWorkerI, WorkerManager> map = this.registered;
        synchronized (map) {
            for (WorkerManager manager : this.registered.values()) {
                manager.restart();
            }
        }
    }

    @Override
    public void cancelWorker(AlignCalcWorkerI worker) {
        Objects.requireNonNull(worker);
        WorkerManager manager = this.registered.get(worker);
        if (manager == null) {
            manager = this.oneshot.get(worker);
        }
        if (manager == null) {
            throw new NoSuchElementException();
        }
        manager.cancel();
    }

    private void notifyQueued(AlignCalcWorkerI worker) {
        for (AlignCalcListener listener : this.listeners) {
            listener.workerQueued(worker);
        }
    }

    private void notifyStarted(AlignCalcWorkerI worker) {
        for (AlignCalcListener listener : this.listeners) {
            listener.workerStarted(worker);
        }
    }

    private void notifyCompleted(AlignCalcWorkerI worker) {
        for (AlignCalcListener listener : this.listeners) {
            try {
                listener.workerCompleted(worker);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyCancelled(AlignCalcWorkerI worker) {
        for (AlignCalcListener listener : this.listeners) {
            try {
                listener.workerCancelled(worker);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyExceptional(AlignCalcWorkerI worker, Throwable throwable) {
        for (AlignCalcListener listener : this.listeners) {
            try {
                listener.workerExceptional(worker, throwable);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addAlignCalcListener(AlignCalcListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeAlignCalcListener(AlignCalcListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void shutdown() {
        this.executor.shutdownNow();
        this.listeners.clear();
        this.registered.clear();
    }

    private class PollableWorkerManager
    extends WorkerManager {
        private Future<?> task;

        PollableWorkerManager(PollableAlignCalcWorkerI worker) {
            super(worker);
            this.task = null;
        }

        @Override
        protected PollableAlignCalcWorkerI getWorker() {
            return (PollableAlignCalcWorkerI)super.getWorker();
        }

        @Override
        boolean isWorking() {
            return this.task != null && !this.task.isDone();
        }

        @Override
        protected void submit() {
            if (this.task != null && !this.task.isDone() && !this.task.isCancelled()) {
                throw new IllegalStateException("Cannot submit new task if the previous one is still running");
            }
            Console.debug(String.format("Worker %s queued", this.getWorker()));
            var runnable = new Runnable(){
                private boolean started = false;
                private boolean completed = false;
                Future<?> future = null;

                @Override
                public void run() {
                    try {
                        if (!this.started) {
                            Console.debug(String.format("Worker %s started", PollableWorkerManager.this.getWorker()));
                            PollableWorkerManager.this.getWorker().startUp();
                            this.started = true;
                        } else if (!this.completed) {
                            Console.debug(String.format("Polling worker %s", PollableWorkerManager.this.getWorker()));
                            if (PollableWorkerManager.this.getWorker().poll()) {
                                Console.debug(String.format("Worker %s finished", PollableWorkerManager.this.getWorker()));
                                this.completed = true;
                            }
                        }
                    }
                    catch (Throwable th) {
                        Console.debug(String.format("Worker %s failed", PollableWorkerManager.this.getWorker()), th);
                        this.completed = true;
                    }
                    if (this.completed) {
                        PollableAlignCalcWorkerI worker = PollableWorkerManager.this.getWorker();
                        if (!PollableWorkerManager.this.isRegistered()) {
                            PollableWorkerManager.this.worker = null;
                        }
                        Console.debug(String.format("Finalizing completed worker %s", worker));
                        worker.done();
                        this.future.cancel(false);
                    }
                }
            };
            this.task = AlignCalcManager2.this.executor.scheduleWithFixedDelay(runnable, 10L, 1000L, TimeUnit.MILLISECONDS);
            runnable.future = this.task;
        }

        @Override
        protected synchronized void cancel() {
            if (!this.isWorking()) {
                return;
            }
            Console.debug(String.format("Cancelling worker %s", this.getWorker()));
            this.task.cancel(false);
            AlignCalcManager2.this.executor.submit(() -> {
                PollableAlignCalcWorkerI worker = this.getWorker();
                if (!this.isRegistered()) {
                    this.worker = null;
                }
                if (worker != null) {
                    worker.cancel();
                    Console.debug(String.format("Finalizing cancelled worker %s", worker));
                    worker.done();
                }
            });
        }
    }

    private class SimpleWorkerManager
    extends WorkerManager {
        private Future<?> task;

        SimpleWorkerManager(AlignCalcWorkerI worker) {
            super(worker);
            this.task = null;
        }

        @Override
        boolean isWorking() {
            return this.task != null && !this.task.isDone();
        }

        @Override
        protected void submit() {
            if (this.task != null && !this.task.isDone() && !this.task.isCancelled()) {
                throw new IllegalStateException("Cannot submit new task if the prevoius one is still running");
            }
            Console.debug(String.format("Worker %s queued", this.getWorker()));
            this.task = AlignCalcManager2.this.executor.submit(() -> {
                try {
                    Console.debug(String.format("Worker %s started", this.getWorker()));
                    this.getWorker().run();
                    Console.debug(String.format("Worker %s finished", this.getWorker()));
                }
                catch (InterruptedException e) {
                    Console.debug(String.format("Worker %s interrupted", this.getWorker()));
                }
                catch (Throwable th) {
                    Console.debug(String.format("Worker %s failed", this.getWorker()), th);
                }
                finally {
                    if (!this.isRegistered()) {
                        this.worker = null;
                    }
                }
            });
        }

        @Override
        synchronized void cancel() {
            if (!this.isWorking()) {
                return;
            }
            Console.debug(String.format("Cancelling worker %s", this.getWorker()));
            this.task.cancel(true);
        }
    }

    private abstract class WorkerManager {
        protected volatile boolean enabled = true;
        protected AlignCalcWorkerI worker;

        WorkerManager(AlignCalcWorkerI worker) {
            this.worker = worker;
        }

        protected AlignCalcWorkerI getWorker() {
            return this.worker;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        synchronized void restart() {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.isRegistered()) {
                this.setEnabled(false);
            }
            if (this.isWorking()) {
                this.cancel();
            }
            this.submit();
        }

        protected boolean isRegistered() {
            return AlignCalcManager2.this.registered.containsKey(this.getWorker());
        }

        abstract boolean isWorking();

        protected abstract void submit();

        abstract void cancel();
    }
}

