/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.Arrays;
import java.util.Comparator;

public class QuickSort {
    public static void sort(int[] arr, Object[] s) {
        QuickSort.sort(arr, 0, arr.length - 1, s);
    }

    public static void sort(float[] arr, Object[] s) {
        QuickSort.sort(arr, 0, arr.length - 1, s);
    }

    public static void sort(double[] arr, Object[] s) {
        QuickSort.sort(arr, 0, arr.length - 1, s);
    }

    public static void sort(String[] arr, Object[] s) {
        QuickSort.stringSort(arr, 0, arr.length - 1, s);
    }

    static void stringSort(String[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.stringPartition(arr, p, r, s);
            QuickSort.stringSort(arr, p, q, s);
            QuickSort.stringSort(arr, q + 1, r, s);
        }
    }

    static void sort(float[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.partition(arr, p, r, s);
            QuickSort.sort(arr, p, q, s);
            QuickSort.sort(arr, q + 1, r, s);
        }
    }

    static void sort(double[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.partition(arr, p, r, s);
            QuickSort.sort(arr, p, q, s);
            QuickSort.sort(arr, q + 1, r, s);
        }
    }

    static void sort(int[] arr, int p, int r, Object[] s) {
        if (p < r) {
            int q = QuickSort.partition(arr, p, r, s);
            QuickSort.sort(arr, p, q, s);
            QuickSort.sort(arr, q + 1, r, s);
        }
    }

    static int partition(float[] arr, int p, int r, Object[] s) {
        float x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            float tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    static int partition(float[] arr, int p, int r, char[] s) {
        float x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            float tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            char tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    static int partition(int[] arr, int p, int r, Object[] s) {
        int x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            int tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    static int partition(double[] arr, int p, int r, Object[] s) {
        double x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j] > x) {
                continue;
            }
            while (arr[++i] < x) {
            }
            if (i >= j) break;
            double tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    static int stringPartition(String[] arr, int p, int r, Object[] s) {
        String x = arr[p];
        int i = p - 1;
        int j = r + 1;
        while (true) {
            if (arr[--j].compareTo(x) < 0) {
                continue;
            }
            while (arr[++i].compareTo(x) > 0) {
            }
            if (i >= j) break;
            String tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
            Object tmp2 = s[i];
            s[i] = s[j];
            s[j] = tmp2;
        }
        return j;
    }

    public static void sort(float[] arr, char[] s) {
        float[] f1 = new float[arr.length];
        char[] s1 = new char[s.length];
        int negativeCount = 0;
        int zerosCount = 0;
        int nextNonZeroValue = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            float val = arr[i];
            if (val != 0.0f) {
                f1[nextNonZeroValue] = val;
                s1[nextNonZeroValue] = s[i];
                --nextNonZeroValue;
                if (!(val < 0.0f)) continue;
                ++negativeCount;
                continue;
            }
            f1[zerosCount] = val;
            s1[zerosCount] = s[i];
            ++zerosCount;
        }
        int positiveCount = arr.length - zerosCount - negativeCount;
        if (zerosCount == arr.length) {
            return;
        }
        float[] nonZeroFloats = Arrays.copyOfRange(f1, zerosCount, f1.length);
        char[] nonZeroChars = Arrays.copyOfRange(s1, zerosCount, s1.length);
        QuickSort.charSortByFloat(nonZeroFloats, nonZeroChars, true);
        System.arraycopy(f1, 0, arr, negativeCount, zerosCount);
        System.arraycopy(s1, 0, s, negativeCount, zerosCount);
        System.arraycopy(nonZeroFloats, 0, arr, 0, negativeCount);
        System.arraycopy(nonZeroChars, 0, s, 0, negativeCount);
        System.arraycopy(nonZeroFloats, negativeCount, arr, negativeCount + zerosCount, positiveCount);
        System.arraycopy(nonZeroChars, negativeCount, s, negativeCount + zerosCount, positiveCount);
    }

    public static void charSortByFloat(float[] arr, char[] s, boolean ascending) {
        int length = arr.length;
        Integer[] indices = QuickSort.makeIndexArray(length);
        Arrays.sort(indices, new FloatComparator(arr, ascending));
        float[] sortedFloats = new float[length];
        char[] sortedChars = new char[s.length];
        for (int i = 0; i < length; ++i) {
            sortedFloats[i] = arr[indices[i]];
            sortedChars[i] = s[indices[i]];
        }
        System.arraycopy(sortedFloats, 0, arr, 0, length);
        System.arraycopy(sortedChars, 0, s, 0, s.length);
    }

    protected static Integer[] makeIndexArray(int length) {
        Integer[] indices = new Integer[length];
        for (int i = 0; i < length; ++i) {
            indices[i] = i;
        }
        return indices;
    }

    static void sort(float[] arr, int p, int r, char[] s) {
        if (p < r) {
            int q = QuickSort.partition(arr, p, r, s);
            QuickSort.sort(arr, p, q, s);
            QuickSort.sort(arr, q + 1, r, s);
        }
    }

    public static void sort(int[] arr, char[] s) {
        int[] f1 = new int[arr.length];
        char[] s1 = new char[s.length];
        int negativeCount = 0;
        int zerosCount = 0;
        int nextNonZeroValue = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            int val = arr[i];
            if ((float)val != 0.0f) {
                f1[nextNonZeroValue] = val;
                s1[nextNonZeroValue] = s[i];
                --nextNonZeroValue;
                if (val >= 0) continue;
                ++negativeCount;
                continue;
            }
            f1[zerosCount] = val;
            s1[zerosCount] = s[i];
            ++zerosCount;
        }
        int positiveCount = arr.length - zerosCount - negativeCount;
        if (zerosCount == arr.length) {
            return;
        }
        int[] nonZeroInts = Arrays.copyOfRange(f1, zerosCount, f1.length);
        char[] nonZeroChars = Arrays.copyOfRange(s1, zerosCount, s1.length);
        QuickSort.charSortByInt(nonZeroInts, nonZeroChars, true);
        System.arraycopy(f1, 0, arr, negativeCount, zerosCount);
        System.arraycopy(s1, 0, s, negativeCount, zerosCount);
        System.arraycopy(nonZeroInts, 0, arr, 0, negativeCount);
        System.arraycopy(nonZeroChars, 0, s, 0, negativeCount);
        System.arraycopy(nonZeroInts, negativeCount, arr, negativeCount + zerosCount, positiveCount);
        System.arraycopy(nonZeroChars, negativeCount, s, negativeCount + zerosCount, positiveCount);
    }

    public static void charSortByInt(int[] arr, char[] s, boolean ascending) {
        int length = arr.length;
        Integer[] indices = QuickSort.makeIndexArray(length);
        Arrays.sort(indices, new IntComparator(arr, ascending));
        int[] sortedInts = new int[length];
        char[] sortedChars = new char[s.length];
        for (int i = 0; i < length; ++i) {
            sortedInts[i] = arr[indices[i]];
            sortedChars[i] = s[indices[i]];
        }
        System.arraycopy(sortedInts, 0, arr, 0, length);
        System.arraycopy(sortedChars, 0, s, 0, s.length);
    }

    public static void sortByInt(int[] arr, Object[] s, boolean ascending) {
        int length = arr.length;
        Integer[] indices = QuickSort.makeIndexArray(length);
        Arrays.sort(indices, new IntComparator(arr, ascending));
        int[] sortedInts = new int[length];
        Object[] sortedObjects = new Object[s.length];
        for (int i = 0; i < length; ++i) {
            sortedInts[i] = arr[indices[i]];
            sortedObjects[i] = s[indices[i]];
        }
        System.arraycopy(sortedInts, 0, arr, 0, length);
        System.arraycopy(sortedObjects, 0, s, 0, s.length);
    }

    public static void sortByString(String[] arr, Object[] s, boolean ascending) {
        int length = arr.length;
        Integer[] indices = QuickSort.makeIndexArray(length);
        Arrays.sort(indices, new ExternalComparator((Comparable[])arr, ascending));
        String[] sortedStrings = new String[length];
        Object[] sortedObjects = new Object[s.length];
        for (int i = 0; i < length; ++i) {
            sortedStrings[i] = arr[indices[i]];
            sortedObjects[i] = s[indices[i]];
        }
        System.arraycopy(sortedStrings, 0, arr, 0, length);
        System.arraycopy(sortedObjects, 0, s, 0, s.length);
    }

    public static void sortByDouble(double[] arr, Object[] s, boolean ascending) {
        int length = arr.length;
        Integer[] indices = QuickSort.makeIndexArray(length);
        Arrays.sort(indices, new DoubleComparator(arr, ascending));
        double[] sortedDoubles = new double[length];
        Object[] sortedObjects = new Object[s.length];
        for (int i = 0; i < length; ++i) {
            sortedDoubles[i] = arr[indices[i]];
            sortedObjects[i] = s[indices[i]];
        }
        System.arraycopy(sortedDoubles, 0, arr, 0, length);
        System.arraycopy(sortedObjects, 0, s, 0, s.length);
    }

    static class ExternalComparator
    implements Comparator<Integer> {
        private final Comparable[] values;
        private boolean ascending;

        ExternalComparator(Comparable[] v, boolean asc) {
            this.values = v;
            this.ascending = asc;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return this.ascending ? this.values[o1].compareTo(this.values[o2]) : this.values[o2].compareTo(this.values[o1]);
        }
    }

    static class IntComparator
    implements Comparator<Integer> {
        private final int[] values;
        private boolean ascending;

        IntComparator(int[] v, boolean asc) {
            this.values = v;
            this.ascending = asc;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return this.ascending ? Integer.compare(this.values[o1], this.values[o2]) : Integer.compare(this.values[o2], this.values[o1]);
        }
    }

    static class DoubleComparator
    implements Comparator<Integer> {
        private final double[] values;
        private boolean ascending;

        DoubleComparator(double[] v, boolean asc) {
            this.values = v;
            this.ascending = asc;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.ascending) {
                return Double.compare(this.values[o1], this.values[o2]);
            }
            return Double.compare(this.values[o2], this.values[o1]);
        }
    }

    static class FloatComparator
    implements Comparator<Integer> {
        private final float[] values;
        private boolean ascending;

        FloatComparator(float[] v, boolean asc) {
            this.values = v;
            this.ascending = asc;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            return this.ascending ? Float.compare(this.values[o1], this.values[o2]) : Float.compare(this.values[o2], this.values[o1]);
        }
    }
}

