/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.analysis.AlignSeq;
import jalview.api.AlignmentViewPanel;
import jalview.api.StructureSelectionManagerProvider;
import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolParser;
import jalview.gui.IProgressIndicator;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structure.AlignmentViewPanelListener;
import jalview.structure.AtomSpec;
import jalview.structure.CommandListener;
import jalview.structure.SecondaryStructureListener;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.SequenceListener;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.VamsasListener;
import jalview.structure.VamsasSource;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.sifts.SiftsClient;
import jalview.ws.sifts.SiftsException;
import jalview.ws.sifts.SiftsSettings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mc_view.Atom;
import mc_view.PDBChain;
import mc_view.PDBfile;

public class StructureSelectionManager
implements ApplicationSingletonProvider.ApplicationSingletonI {
    public static final String NEWLINE = System.lineSeparator();
    private List<StructureMapping> mappings = new ArrayList<StructureMapping>();
    private boolean processSecondaryStructure = false;
    private boolean secStructServices = false;
    private boolean addTempFacAnnot = false;
    private List<AlignedCodonFrame> seqmappings = new ArrayList<AlignedCodonFrame>();
    private List<CommandListener> commandListeners = new ArrayList<CommandListener>();
    private List<SelectionListener> sel_listeners = new ArrayList<SelectionListener>();
    private IdentityHashMap<StructureSelectionManagerProvider, StructureSelectionManager> selectionManagers;
    Map<String, String> pdbIdFileName = new HashMap<String, String>();
    Map<String, String> pdbFileNameId = new HashMap<String, String>();
    boolean relaySeqMappings = true;
    Vector<Object> listeners = new Vector();
    boolean handlingVamsasMo = false;
    long lastmsg = 0L;
    Vector<AlignmentViewPanelListener> view_listeners = new Vector();

    private static StructureSelectionManager getInstance() {
        return ApplicationSingletonProvider.getInstance(StructureSelectionManager.class);
    }

    private StructureSelectionManager() {
        this.selectionManagers = new IdentityHashMap();
    }

    public static StructureSelectionManager getStructureSelectionManager(StructureSelectionManagerProvider context) {
        return StructureSelectionManager.getInstance().getInstanceForContext(context);
    }

    StructureSelectionManager getInstanceForContext(StructureSelectionManagerProvider context) {
        StructureSelectionManager instance = this.selectionManagers.get(context);
        if (instance == null) {
            instance = new StructureSelectionManager();
            this.selectionManagers.put(context, instance);
        }
        return instance;
    }

    public boolean isSecStructServices() {
        return this.secStructServices;
    }

    public void setSecStructServices(boolean secStructServices) {
        this.secStructServices = secStructServices;
    }

    public boolean isAddTempFacAnnot() {
        return this.addTempFacAnnot;
    }

    public void setAddTempFacAnnot(boolean addTempFacAnnot) {
        this.addTempFacAnnot = addTempFacAnnot;
    }

    public boolean isProcessSecondaryStructure() {
        return this.processSecondaryStructure;
    }

    public void setProcessSecondaryStructure(boolean enable) {
        this.processSecondaryStructure = enable;
    }

    public void reportMapping() {
        if (this.mappings.isEmpty()) {
            Console.errPrintln("reportMapping: No PDB/Sequence mappings.");
        } else {
            Console.errPrintln("reportMapping: There are " + this.mappings.size() + " mappings.");
            int i = 0;
            for (StructureMapping sm : this.mappings) {
                Console.errPrintln("mapping " + i++ + " : " + sm.pdbfile);
            }
        }
    }

    public void registerPDBFile(String idForFile, String absoluteFile) {
        this.pdbIdFileName.put(idForFile, absoluteFile);
        this.pdbFileNameId.put(absoluteFile, idForFile);
    }

    public String findIdForPDBFile(String idOrFile) {
        String id = this.pdbFileNameId.get(idOrFile);
        return id;
    }

    public String findFileForPDBId(String idOrFile) {
        String id = this.pdbIdFileName.get(idOrFile);
        return id;
    }

    public boolean isPDBFileRegistered(String idOrFile) {
        return this.pdbFileNameId.containsKey(idOrFile) || this.pdbIdFileName.containsKey(idOrFile);
    }

    public void setRelaySeqMappings(boolean relay) {
        this.relaySeqMappings = relay;
    }

    public boolean isRelaySeqMappingsEnabled() {
        return this.relaySeqMappings;
    }

    public void addStructureViewerListener(Object svl) {
        if (!this.listeners.contains(svl)) {
            this.listeners.addElement(svl);
        }
    }

    public String alreadyMappedToFile(String pdbid) {
        for (StructureMapping sm : this.mappings) {
            if (!sm.getPdbId().equalsIgnoreCase(pdbid)) continue;
            return sm.pdbfile;
        }
        return null;
    }

    public synchronized StructureFile setMapping(SequenceI[] sequence, String[] targetChains, String pdbFile, DataSourceType protocol, IProgressIndicator progress) {
        return this.computeMapping(true, sequence, targetChains, pdbFile, protocol, progress, null, null, true);
    }

    public synchronized StructureFile setMapping(boolean forStructureView, SequenceI[] sequenceArray, String[] targetChainIds, String pdbFile, DataSourceType sourceType, StructureImportSettings.TFType tft, String paeFilename) {
        return this.setMapping(forStructureView, sequenceArray, targetChainIds, pdbFile, sourceType, tft, paeFilename, true);
    }

    public synchronized StructureFile setMapping(boolean forStructureView, SequenceI[] sequenceArray, String[] targetChainIds, String pdbFile, DataSourceType sourceType, StructureImportSettings.TFType tft, String paeFilename, boolean doXferSettings) {
        return this.computeMapping(forStructureView, sequenceArray, targetChainIds, pdbFile, sourceType, null, tft, paeFilename, doXferSettings);
    }

    public synchronized StructureFile setMapping(boolean forStructureView, SequenceI[] sequenceArray, PDBEntry pdbEntry, String[] targetChainIds, IProgressIndicator progress) {
        String normalisedPdbEntryFilePath = pdbEntry.getFile();
        if (normalisedPdbEntryFilePath != null) {
            normalisedPdbEntryFilePath = normalisedPdbEntryFilePath.replace('\\', '/');
        }
        return this.computeMapping(forStructureView, sequenceArray, targetChainIds, normalisedPdbEntryFilePath, pdbEntry.getProtocol(), progress, pdbEntry.getTempFacTypeTFType(), pdbEntry.getPAEFile(), true);
    }

    public synchronized StructureFile setMapping(boolean forStructureView, SequenceI[] sequenceArray, PDBEntry pdbEntry, String[] targetChainIds) {
        return this.computeMapping(forStructureView, sequenceArray, targetChainIds, pdbEntry.getFile(), pdbEntry.getProtocol(), null, pdbEntry.getTempFacTypeTFType(), pdbEntry.getPAEFile(), true);
    }

    public synchronized StructureFile computeMapping(boolean forStructureView, SequenceI[] sequenceArray, String[] targetChainIds, String pdbFile, DataSourceType sourceType, IProgressIndicator progress, StructureImportSettings.TFType tft, String paeFilename, boolean doXferSettings) {
        long progressSessionId = System.currentTimeMillis() * 3L;
        boolean parseSecStr = this.processSecondaryStructure && !this.isStructureFileProcessed((String)pdbFile, sequenceArray);
        JmolParser pdb = null;
        boolean isMapUsingSIFTs = SiftsSettings.isMapWithSifts();
        try {
            sourceType = AppletFormatAdapter.checkProtocol(pdbFile);
            pdb = new JmolParser(false, pdbFile, sourceType);
            if (paeFilename != null) {
                pdb.setPAEMatrix(paeFilename);
            }
            pdb.setTemperatureFactorType(tft);
            pdb.addSettings(parseSecStr && this.processSecondaryStructure, parseSecStr && this.addTempFacAnnot, parseSecStr && this.secStructServices);
            boolean temp = pdb.getDoXferSettings();
            pdb.setDoXferSettings(doXferSettings);
            pdb.doParse();
            pdb.setDoXferSettings(temp);
            if (pdb.getId() != null && pdb.getId().trim().length() > 0 && DataSourceType.FILE == sourceType) {
                this.registerPDBFile(pdb.getId().trim(), (String)pdbFile);
            }
            boolean isProtein = false;
            for (SequenceI s : sequenceArray) {
                if (!s.isProtein()) continue;
                isProtein = true;
                break;
            }
            isMapUsingSIFTs = isMapUsingSIFTs && pdb.isPPDBIdAvailable() && !pdb.getId().startsWith("AF-") && isProtein;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        SiftsClient siftsClient = null;
        try {
            if (isMapUsingSIFTs) {
                siftsClient = new SiftsClient(pdb);
            }
        }
        catch (SiftsException e) {
            isMapUsingSIFTs = false;
            Console.error("SIFTS mapping failed", e);
            Console.error("Falling back on Needleman & Wunsch alignment");
            siftsClient = null;
        }
        for (int s = 0; s < sequenceArray.length; ++s) {
            String targetChainId;
            SequenceI seq;
            boolean infChain = true;
            SequenceI ds = seq = sequenceArray[s];
            while (ds.getDatasetSequence() != null) {
                ds = ds.getDatasetSequence();
            }
            if (targetChainIds != null && targetChainIds[s] != null) {
                infChain = false;
                targetChainId = targetChainIds[s];
            } else if (seq.getName().indexOf("|") > -1) {
                targetChainId = seq.getName().substring(seq.getName().lastIndexOf("|") + 1);
                if (targetChainId.length() > 1) {
                    targetChainId = targetChainId.trim().length() == 0 ? " " : "";
                }
            } else {
                targetChainId = "";
            }
            float max = -10.0f;
            AlignSeq maxAlignseq = null;
            String maxChainId = " ";
            PDBChain maxChain = null;
            boolean first = true;
            for (PDBChain chain : pdb.getChains()) {
                if (targetChainId.length() > 0 && !targetChainId.equals(chain.id) && !infChain) continue;
                String type = chain.isNa ? "dna" : "pep";
                AlignSeq as = AlignSeq.doGlobalNWAlignment(seq, chain.sequence, type);
                if (!first && !(as.maxscore > max) && (as.maxscore != max || !chain.id.equals(targetChainId))) continue;
                first = false;
                maxChain = chain;
                max = as.maxscore;
                maxAlignseq = as;
                maxChainId = chain.id;
            }
            if (maxChain == null) continue;
            if (sourceType == DataSourceType.PASTE) {
                pdbFile = "INLINE" + pdb.getId();
            }
            ArrayList<StructureMapping> seqToStrucMapping = new ArrayList<StructureMapping>();
            if (isMapUsingSIFTs && seq.isProtein()) {
                if (progress != null) {
                    progress.setProgressBar(MessageManager.getString("status.obtaining_mapping_with_sifts"), progressSessionId);
                }
                Mapping sqmpping = maxAlignseq.getMappingFromS1(false);
                if (targetChainId != null && !targetChainId.trim().isEmpty()) {
                    try {
                        StructureMapping siftsMapping = this.getStructureMapping(seq, (String)pdbFile, targetChainId, pdb, maxChain, sqmpping, maxAlignseq, siftsClient);
                        seqToStrucMapping.add(siftsMapping);
                        maxChain.makeExactMapping(siftsMapping, seq);
                        maxChain.transferRESNUMFeatures(seq, "IEA: SIFTS", pdb.getId().toLowerCase(Locale.ROOT));
                        maxChain.transferResidueAnnotation(siftsMapping, null);
                        ds.addPDBId(maxChain.sequence.getAllPDBEntries().get(0));
                    }
                    catch (SiftsException e) {
                        Console.error(e.getMessage());
                        StructureMapping nwMapping = this.getNWMappings(seq, (String)pdbFile, targetChainId, maxChain, pdb, maxAlignseq);
                        seqToStrucMapping.add(nwMapping);
                        maxChain.makeExactMapping(maxAlignseq, seq);
                        maxChain.transferRESNUMFeatures(seq, "IEA:Jalview", pdb.getId().toLowerCase(Locale.ROOT));
                        maxChain.transferResidueAnnotation(nwMapping, sqmpping);
                        ds.addPDBId(maxChain.sequence.getAllPDBEntries().get(0));
                    }
                } else {
                    ArrayList<StructureMapping> foundSiftsMappings = new ArrayList<StructureMapping>();
                    for (PDBChain chain : pdb.getChains()) {
                        StructureMapping siftsMapping = null;
                        try {
                            siftsMapping = this.getStructureMapping(seq, (String)pdbFile, chain.id, pdb, chain, sqmpping, maxAlignseq, siftsClient);
                            foundSiftsMappings.add(siftsMapping);
                            chain.makeExactMapping(siftsMapping, seq);
                            chain.transferRESNUMFeatures(seq, "IEA: SIFTS", pdb.getId().toLowerCase(Locale.ROOT));
                            chain.transferResidueAnnotation(siftsMapping, null);
                        }
                        catch (SiftsException e) {
                            Console.errPrintln(e.getMessage());
                        }
                        catch (Exception e) {
                            Console.errPrintln("Unexpected exception during SIFTS mapping - falling back to NW for this sequence/structure pair");
                            Console.errPrintln(e.getMessage());
                        }
                    }
                    if (!foundSiftsMappings.isEmpty()) {
                        seqToStrucMapping.addAll(foundSiftsMappings);
                        ds.addPDBId(sqmpping.getTo().getAllPDBEntries().get(0));
                    } else {
                        StructureMapping nwMapping = this.getNWMappings(seq, (String)pdbFile, maxChainId, maxChain, pdb, maxAlignseq);
                        seqToStrucMapping.add(nwMapping);
                        maxChain.transferRESNUMFeatures(seq, null, pdb.getId().toLowerCase(Locale.ROOT));
                        maxChain.transferResidueAnnotation(nwMapping, sqmpping);
                        ds.addPDBId(maxChain.sequence.getAllPDBEntries().get(0));
                    }
                }
            } else {
                if (progress != null) {
                    progress.setProgressBar(MessageManager.getString("status.obtaining_mapping_with_nw_alignment"), progressSessionId);
                }
                StructureMapping nwMapping = this.getNWMappings(seq, (String)pdbFile, maxChainId, maxChain, pdb, maxAlignseq);
                seqToStrucMapping.add(nwMapping);
                ds.addPDBId(maxChain.sequence.getAllPDBEntries().get(0));
            }
            this.saveAnnotationProvider(pdb, seq);
            if (forStructureView) {
                for (StructureMapping sm : seqToStrucMapping) {
                    this.addStructureMapping(sm);
                }
            }
            if (progress == null) continue;
            progress.setProgressBar(null, progressSessionId);
        }
        return pdb;
    }

    void saveAnnotationProvider(StructureFile pdb, SequenceI seq) {
        AlignmentAnnotation[] annotations;
        String pdbFilePath = pdb.getInFile();
        SequenceI datasetSeq = seq.getDatasetSequence();
        if (pdbFilePath == null || datasetSeq == null) {
            return;
        }
        String ssAnnotDescriptionInPDB = null;
        Vector<SequenceI> seqs = pdb.getSeqs();
        if (seqs != null && !seqs.isEmpty() && (annotations = ((SequenceI)seqs.get(0)).getAnnotation("Secondary Structure")) != null && annotations.length > 0) {
            ssAnnotDescriptionInPDB = annotations[0].description;
        }
        if (ssAnnotDescriptionInPDB == null) {
            return;
        }
        Vector<PDBEntry> pdbEntries = seq.getDatasetSequence().getAllPDBEntries();
        String provider = null;
        if (pdbEntries != null) {
            for (PDBEntry entry : pdbEntries) {
                String entryFile = entry.getFile();
                if (entryFile == null || !pdbFilePath.startsWith(entryFile)) continue;
                provider = entry.getProvider();
                break;
            }
        }
        if (provider == null) {
            return;
        }
        AlignmentAnnotation[] annotations2 = datasetSeq.getAnnotation("Secondary Structure");
        if (annotations2 == null) {
            return;
        }
        for (AlignmentAnnotation annot : annotations2) {
            if (annot.getProperty("SS_PROVIDER") != null || !ssAnnotDescriptionInPDB.equals(annot.description)) continue;
            annot.setProperty("SS_PROVIDER", provider);
        }
    }

    private boolean isStructureFileProcessed(String pdbFile, SequenceI[] sequenceArray) {
        boolean processed = false;
        if (this.isPDBFileRegistered(pdbFile)) {
            SequenceI[] sequenceIArray = sequenceArray;
            int n = sequenceIArray.length;
            for (int i = 0; i < n; ++i) {
                SequenceI sq;
                SequenceI ds = sq = sequenceIArray[i];
                while (ds.getDatasetSequence() != null) {
                    ds = ds.getDatasetSequence();
                }
                if (ds.getAnnotation() == null) continue;
                for (AlignmentAnnotation ala : ds.getAnnotation()) {
                    if (!PDBfile.isCalcIdForFile(ala, this.findIdForPDBFile(pdbFile))) continue;
                    processed = true;
                }
            }
        }
        return processed;
    }

    public void addStructureMapping(StructureMapping sm) {
        if (!this.mappings.contains(sm)) {
            this.mappings.add(sm);
        }
    }

    private StructureMapping getStructureMapping(SequenceI seq, String pdbFile, String targetChainId, StructureFile pdb, PDBChain maxChain, Mapping sqmpping, AlignSeq maxAlignseq, SiftsClient siftsClient) throws SiftsException {
        StructureMapping curChainMapping = siftsClient.getSiftsStructureMapping(seq, pdbFile, targetChainId);
        try {
            PDBChain chain = pdb.findChain(targetChainId);
            if (chain != null) {
                chain.transferResidueAnnotation(curChainMapping, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return curChainMapping;
    }

    private StructureMapping getNWMappings(SequenceI seq, String pdbFile, String maxChainId, PDBChain maxChain, StructureFile pdb, AlignSeq maxAlignseq) {
        final StringBuilder mappingDetails = new StringBuilder(128);
        mappingDetails.append(NEWLINE).append("Sequence \u27f7 Structure mapping details");
        mappingDetails.append(NEWLINE);
        mappingDetails.append("Method: inferred with Needleman & Wunsch alignment");
        mappingDetails.append(NEWLINE).append("PDB Sequence is :").append(NEWLINE).append("Sequence = ").append(maxChain.sequence.getSequenceAsString());
        mappingDetails.append(NEWLINE).append("No of residues = ").append(maxChain.residues.size()).append(NEWLINE).append(NEWLINE);
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void print(String x) {
                mappingDetails.append(x);
            }

            @Override
            public void println() {
                mappingDetails.append(NEWLINE);
            }
        };
        maxAlignseq.printAlignment(ps);
        mappingDetails.append(NEWLINE).append("PDB start/end ");
        mappingDetails.append(String.valueOf(maxAlignseq.seq2start)).append(" ");
        mappingDetails.append(String.valueOf(maxAlignseq.seq2end));
        mappingDetails.append(NEWLINE).append("SEQ start/end ");
        mappingDetails.append(String.valueOf(maxAlignseq.seq1start + (seq.getStart() - 1))).append(" ");
        mappingDetails.append(String.valueOf(maxAlignseq.seq1end + (seq.getStart() - 1)));
        mappingDetails.append(NEWLINE);
        maxChain.makeExactMapping(maxAlignseq, seq);
        Mapping sqmpping = maxAlignseq.getMappingFromS1(false);
        maxChain.transferRESNUMFeatures(seq, null, pdb.getId().toLowerCase(Locale.ROOT));
        HashMap<Integer, int[]> mapping = new HashMap<Integer, int[]>();
        int resNum = -10000;
        int index = 0;
        char insCode = ' ';
        do {
            Atom tmp = maxChain.atoms.elementAt(index);
            if (resNum == tmp.resNumber && insCode == tmp.insCode || tmp.alignmentMapping == -1) continue;
            resNum = tmp.resNumber;
            insCode = tmp.insCode;
            if (tmp.alignmentMapping < -1) continue;
            mapping.put(tmp.alignmentMapping + 1, new int[]{tmp.resNumber, tmp.atomIndex});
        } while (++index < maxChain.atoms.size());
        StructureMapping nwMapping = new StructureMapping(seq, pdbFile, pdb.getId(), maxChainId, mapping, mappingDetails.toString());
        maxChain.transferResidueAnnotation(nwMapping, sqmpping);
        return nwMapping;
    }

    public void removeStructureViewerListener(Object svl, String[] pdbfiles) {
        this.listeners.removeElement(svl);
        if (svl instanceof SequenceListener) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                if (!(this.listeners.elementAt(i) instanceof StructureListener)) continue;
                ((StructureListener)this.listeners.elementAt(i)).releaseReferences(svl);
            }
        }
        if (pdbfiles == null) {
            return;
        }
        ArrayList<String> pdbs = new ArrayList<String>(Arrays.asList(pdbfiles));
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!(this.listeners.elementAt(i) instanceof StructureListener)) continue;
            StructureListener sl = (StructureListener)this.listeners.elementAt(i);
            for (String pdbfile : sl.getStructureFiles()) {
                pdbs.remove(pdbfile);
            }
        }
        if (pdbs.size() > 0) {
            ArrayList<StructureMapping> tmp = new ArrayList<StructureMapping>();
            for (StructureMapping sm : this.mappings) {
                if (pdbs.contains(sm.pdbfile)) continue;
                tmp.add(sm);
            }
            this.mappings = tmp;
        }
    }

    public void highlightPositionsOn(SequenceI sequenceRef, int[][] is, Object source) {
        boolean hasSequenceListeners = this.handlingVamsasMo || !this.seqmappings.isEmpty();
        Object results = null;
        ArrayList<Integer> listOfPositions = new ArrayList<Integer>();
        for (int[] s_e : is) {
            int p = s_e[0];
            while (p <= s_e[1]) {
                listOfPositions.add(p++);
            }
        }
        int[] seqpos = new int[listOfPositions.size()];
        int i = 0;
        for (Integer p : listOfPositions) {
            seqpos[i++] = p;
        }
        for (i = 0; i < this.listeners.size(); ++i) {
            Object listener = this.listeners.elementAt(i);
            if (listener == source || !(listener instanceof StructureListener)) continue;
            this.highlightStructure((StructureListener)listener, sequenceRef, seqpos);
        }
    }

    public String mouseOverStructure(int pdbResNum, String chain, String pdbfile) {
        AtomSpec atomSpec = new AtomSpec(pdbfile, chain, pdbResNum, 0);
        List<AtomSpec> atoms = Collections.singletonList(atomSpec);
        return this.mouseOverStructure(atoms);
    }

    public String mouseOverStructure(List<AtomSpec> atoms) {
        if (this.listeners == null) {
            return null;
        }
        boolean hasSequenceListener = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!(this.listeners.elementAt(i) instanceof SequenceListener)) continue;
            hasSequenceListener = true;
        }
        if (!hasSequenceListener) {
            return null;
        }
        SearchResultsI results = this.findAlignmentPositionsForStructurePositions(atoms);
        String result = null;
        for (Object li : this.listeners) {
            String s;
            if (!(li instanceof SequenceListener) || (s = ((SequenceListener)li).highlightSequence(results)) == null) continue;
            result = s;
        }
        return result;
    }

    public SearchResultsI findAlignmentPositionsForStructurePositions(List<AtomSpec> atoms) {
        SearchResults results = new SearchResults();
        for (AtomSpec atom : atoms) {
            SequenceI lastseq = null;
            int lastipos = -1;
            for (StructureMapping sm : this.mappings) {
                int indexpos;
                if (!sm.pdbfile.equals(atom.getPdbFile()) || !sm.pdbchain.equals(atom.getChain()) || lastipos == (indexpos = sm.getSeqPos(atom.getPdbResNum())) && lastseq == sm.sequence) continue;
                results.appendResult(sm.sequence, indexpos, indexpos);
                lastipos = indexpos;
                lastseq = sm.sequence;
                for (AlignedCodonFrame acf : this.seqmappings) {
                    acf.markMappedRegion(sm.sequence, indexpos, results);
                }
            }
        }
        return results;
    }

    public void mouseOverSequence(SequenceI seq, int indexpos, int seqPos, VamsasSource source) {
        boolean hasSequenceListeners = this.handlingVamsasMo || !this.seqmappings.isEmpty();
        SearchResultsI results = null;
        if (seqPos == -1) {
            seqPos = seq.findPosition(indexpos);
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object listener = this.listeners.elementAt(i);
            if (listener == source) continue;
            if (listener instanceof StructureListener) {
                this.highlightStructure((StructureListener)listener, seq, seqPos);
                continue;
            }
            if (listener instanceof SequenceListener) {
                SequenceListener seqListener = (SequenceListener)listener;
                if (!hasSequenceListeners || seqListener.getVamsasSource() == source || !this.relaySeqMappings) continue;
                if (results == null) {
                    results = MappingUtils.buildSearchResults(seq, seqPos, this.seqmappings);
                }
                if (this.handlingVamsasMo) {
                    results.addResult(seq, seqPos, seqPos);
                }
                if (results.isEmpty()) continue;
                seqListener.highlightSequence(results);
                continue;
            }
            if (listener instanceof VamsasListener && !this.handlingVamsasMo) {
                ((VamsasListener)listener).mouseOverSequence(seq, indexpos, source);
                continue;
            }
            if (!(listener instanceof SecondaryStructureListener)) continue;
            ((SecondaryStructureListener)listener).mouseOverSequence(seq, indexpos, seqPos);
        }
    }

    public void highlightStructure(StructureListener sl, SequenceI seq, int ... positions) {
        if (!sl.isListeningFor(seq)) {
            return;
        }
        ArrayList<AtomSpec> atoms = new ArrayList<AtomSpec>();
        for (StructureMapping sm : this.mappings) {
            if (sm.sequence != seq && sm.sequence != seq.getDatasetSequence() && (sm.sequence.getDatasetSequence() == null || sm.sequence.getDatasetSequence() != seq.getDatasetSequence())) continue;
            for (int index : positions) {
                int atomNo = sm.getAtomNum(index);
                if (atomNo <= 0) continue;
                atoms.add(new AtomSpec(sm.pdbfile, sm.pdbchain, sm.getPDBResNum(index), atomNo));
            }
        }
        sl.highlightAtoms(atoms);
    }

    public void highlightStructureRegionsFor(StructureListener sl, SequenceI[] seqs, int ... columns) {
        ArrayList<SequenceI> to_highlight = new ArrayList<SequenceI>();
        for (SequenceI seq : seqs) {
            if (!sl.isListeningFor(seq)) continue;
            to_highlight.add(seq);
        }
        if (to_highlight.size() == 0) {
            return;
        }
        ArrayList<AtomSpec> atoms = new ArrayList<AtomSpec>();
        for (SequenceI seq : to_highlight) {
            for (StructureMapping sm : this.mappings) {
                if (sm.sequence != seq && sm.sequence != seq.getDatasetSequence() && (sm.sequence.getDatasetSequence() == null || sm.sequence.getDatasetSequence() != seq.getDatasetSequence())) continue;
                for (int i = 0; i < columns.length; i += 2) {
                    ContiguousI positions = seq.findPositions(columns[i] + 1, columns[i + 1] + 1);
                    if (positions == null) continue;
                    for (int index = positions.getBegin(); index <= positions.getEnd(); ++index) {
                        int atomNo = sm.getAtomNum(index);
                        if (atomNo <= 0) continue;
                        atoms.add(new AtomSpec(sm.pdbfile, sm.pdbchain, sm.getPDBResNum(index), atomNo));
                    }
                }
            }
            if (atoms.size() <= 0) continue;
            sl.highlightAtoms(atoms);
        }
    }

    public void mouseOverVamsasSequence(SequenceI sequenceI, int position, VamsasSource source) {
        this.handlingVamsasMo = true;
        long msg = sequenceI.hashCode() * (1 + position);
        if (this.lastmsg != msg) {
            this.lastmsg = msg;
            this.mouseOverSequence(sequenceI, position, -1, source);
        }
        this.handlingVamsasMo = false;
    }

    public Annotation[] colourSequenceFromStructure(SequenceI seq, String pdbid) {
        return null;
    }

    public void structureSelectionChanged() {
    }

    public void sequenceSelectionChanged() {
    }

    public void sequenceColoursChanged(Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!(this.listeners.elementAt(i) instanceof StructureListener)) continue;
            StructureListener sl = (StructureListener)this.listeners.elementAt(i);
            sl.updateColours(source);
        }
    }

    public StructureMapping[] getMapping(String pdbfile) {
        ArrayList<StructureMapping> tmp = new ArrayList<StructureMapping>();
        for (StructureMapping sm : this.mappings) {
            if (!sm.pdbfile.equals(pdbfile)) continue;
            tmp.add(sm);
        }
        return tmp.toArray(new StructureMapping[tmp.size()]);
    }

    public String printMappings(String pdbfile, List<SequenceI> seqs) {
        if (pdbfile == null || seqs == null || seqs.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        for (StructureMapping sm : this.mappings) {
            if (!Platform.pathEquals(sm.pdbfile, pdbfile) || !seqs.contains(sm.sequence)) continue;
            sb.append(sm.mappingDetails);
            sb.append(NEWLINE);
            sb.append("=====================");
            sb.append(NEWLINE);
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    public void deregisterMapping(AlignedCodonFrame acf) {
        boolean removed;
        if (acf != null && (removed = this.seqmappings.remove(acf)) && this.seqmappings.isEmpty()) {
            Console.outPrintln("All mappings removed");
        }
    }

    public void registerMappings(List<AlignedCodonFrame> mappings) {
        if (mappings != null) {
            for (AlignedCodonFrame acf : mappings) {
                this.registerMapping(acf);
            }
        }
    }

    public void registerMapping(AlignedCodonFrame acf) {
        if (acf != null && !this.seqmappings.contains(acf)) {
            this.seqmappings.add(acf);
        }
    }

    public void resetAll() {
        if (this.mappings != null) {
            this.mappings.clear();
        }
        if (this.seqmappings != null) {
            this.seqmappings.clear();
        }
        if (this.sel_listeners != null) {
            this.sel_listeners.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.commandListeners != null) {
            this.commandListeners.clear();
        }
        if (this.view_listeners != null) {
            this.view_listeners.clear();
        }
        if (this.pdbFileNameId != null) {
            this.pdbFileNameId.clear();
        }
        if (this.pdbIdFileName != null) {
            this.pdbIdFileName.clear();
        }
    }

    public List<SelectionListener> getListeners() {
        return this.sel_listeners;
    }

    public void addSelectionListener(SelectionListener selecter) {
        if (!this.sel_listeners.contains(selecter)) {
            this.sel_listeners.add(selecter);
        }
    }

    public void removeSelectionListener(SelectionListener toremove) {
        if (this.sel_listeners.contains(toremove)) {
            this.sel_listeners.remove(toremove);
        }
    }

    public synchronized void sendSelection(SequenceGroup selection, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        for (SelectionListener slis : this.sel_listeners) {
            if (slis == source) continue;
            slis.selection(selection, colsel, hidden, source);
        }
    }

    public synchronized void sendViewPosition(AlignmentViewPanel source, int startRes, int endRes, int startSeq, int endSeq) {
        if (this.view_listeners != null && this.view_listeners.size() > 0) {
            Enumeration<AlignmentViewPanelListener> listeners = this.view_listeners.elements();
            while (listeners.hasMoreElements()) {
                AlignmentViewPanelListener slis = listeners.nextElement();
                if (slis == source) continue;
                slis.viewPosition(startRes, endRes, startSeq, endSeq, source);
            }
        }
    }

    public static void release(StructureSelectionManagerProvider provider) {
        StructureSelectionManager.getInstance().selectionManagers.remove(provider);
    }

    public void registerPDBEntry(PDBEntry pdbentry) {
        if (pdbentry.getFile() != null && pdbentry.getFile().trim().length() > 0) {
            this.registerPDBFile(pdbentry.getId(), pdbentry.getFile());
        }
    }

    public void addCommandListener(CommandListener cl) {
        if (!this.commandListeners.contains(cl)) {
            this.commandListeners.add(cl);
        }
    }

    public boolean hasCommandListener(CommandListener cl) {
        return this.commandListeners.contains(cl);
    }

    public boolean removeCommandListener(CommandListener l) {
        return this.commandListeners.remove(l);
    }

    public void commandPerformed(CommandI command, boolean undo, VamsasSource source) {
        for (CommandListener listener : this.commandListeners) {
            listener.mirrorCommand(command, undo, this, source);
        }
    }

    public CommandI mapCommand(CommandI command, boolean undo, AlignmentI mapTo, char gapChar) {
        if (command instanceof EditCommand) {
            return MappingUtils.mapEditCommand((EditCommand)command, undo, mapTo, gapChar, this.seqmappings);
        }
        if (command instanceof OrderCommand) {
            return MappingUtils.mapOrderCommand((OrderCommand)command, undo, mapTo, this.seqmappings);
        }
        return null;
    }

    public List<AlignedCodonFrame> getSequenceMappings() {
        return this.seqmappings;
    }

    public void highlightPositionsOnMany(SequenceI[] sequencesArray, int[] is, Object source) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Object listener = this.listeners.elementAt(i);
            if (listener == source || !(listener instanceof StructureListener)) continue;
            this.highlightStructureRegionsFor((StructureListener)listener, sequencesArray, is);
        }
    }

    public Map<String, String> getPdbFileNameIdMap() {
        return this.pdbFileNameId;
    }

    public Map<String, String> getPdbIdFileNameMap() {
        return this.pdbIdFileName;
    }

    public static void doConfigureStructurePrefs(StructureSelectionManager ssm) {
        StructureSelectionManager.doConfigureStructurePrefs(ssm, Cache.getDefault("ADD_SS_ANN", true), Cache.getDefault("ADD_TEMPFACT_ANN", true), Cache.getDefault("STRUCT_FROM_PDB", true), Cache.getDefault("USE_RNAVIEW", false));
    }

    public static void doConfigureStructurePrefs(StructureSelectionManager ssm, boolean add_ss_ann, boolean add_tempfact_ann, boolean struct_from_pdb, boolean use_rnaview) {
        if (add_ss_ann) {
            ssm.setAddTempFacAnnot(add_tempfact_ann);
            ssm.setProcessSecondaryStructure(struct_from_pdb);
            ssm.setSecStructServices(use_rnaview);
        } else {
            ssm.setAddTempFacAnnot(false);
            ssm.setProcessSecondaryStructure(false);
            ssm.setSecStructServices(false);
        }
    }
}

