/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.util.Comparison;
import java.awt.Color;

public class Blosum62ColourScheme
extends ResidueColourScheme {
    private static final Color LIGHT_BLUE = new Color(204, 204, 255);
    private static final Color DARK_BLUE = new Color(154, 154, 255);

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new Blosum62ColourScheme();
    }

    @Override
    public Color findColour(char res, int j, SequenceI seq, String consensusResidue, float pid) {
        Color colour;
        ScoreMatrix sm = ScoreModels.getInstance().getBlosum62();
        if ('a' <= res && res <= 'z') {
            res = (char)(res - 32);
        }
        if (Comparison.isGap(res) || consensusResidue == null) {
            return Color.white;
        }
        if (consensusResidue.indexOf(res) > -1) {
            colour = DARK_BLUE;
        } else {
            float score = 0.0f;
            for (char consensus : consensusResidue.toCharArray()) {
                score += sm.getPairwiseScore(consensus, res);
            }
            colour = score > 0.0f ? LIGHT_BLUE : Color.white;
        }
        return colour;
    }

    @Override
    public boolean isPeptideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.Blosum62.toString();
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

