/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.renderer.AnnotationRenderer;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.FollowerColourScheme;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.IdentityHashMap;
import java.util.Map;

public class AnnotationColourGradient
extends FollowerColourScheme {
    boolean positionToTransparency = false;
    boolean perLineScore = false;
    public static final int NO_THRESHOLD = -1;
    public static final int BELOW_THRESHOLD = 0;
    public static final int ABOVE_THRESHOLD = 1;
    private final AlignmentAnnotation annotation;
    private final int aboveAnnotationThreshold;
    public boolean thresholdIsMinMax = false;
    private GraphLine annotationThreshold;
    private int redMin;
    private int greenMin;
    private int blueMin;
    private int redRange;
    private int greenRange;
    private int blueRange;
    private boolean predefinedColours = false;
    private boolean seqAssociated = false;
    private boolean noGradient = false;
    private IdentityHashMap<SequenceI, AlignmentAnnotation> seqannot = null;
    double aamin = 0.0;
    double aamax = 0.0;
    double plmin = Double.NaN;
    double plmax = Double.NaN;

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI sg) {
        AnnotationColourGradient acg = new AnnotationColourGradient(this.annotation, this.getColourScheme(), this.aboveAnnotationThreshold);
        acg.thresholdIsMinMax = this.thresholdIsMinMax;
        acg.annotationThreshold = this.annotationThreshold == null ? null : new GraphLine(this.annotationThreshold);
        acg.redMin = this.redMin;
        acg.greenMin = this.greenMin;
        acg.blueMin = this.blueMin;
        acg.redRange = this.redRange;
        acg.greenRange = this.greenRange;
        acg.blueRange = this.blueRange;
        acg.predefinedColours = this.predefinedColours;
        acg.seqAssociated = this.seqAssociated;
        acg.noGradient = this.noGradient;
        acg.positionToTransparency = this.positionToTransparency;
        acg.perLineScore = this.perLineScore;
        return acg;
    }

    public AnnotationColourGradient(AlignmentAnnotation annotation, ColourSchemeI originalColour, int aboveThreshold) {
        if (originalColour instanceof AnnotationColourGradient) {
            this.setColourScheme(((AnnotationColourGradient)originalColour).getColourScheme());
        } else {
            this.setColourScheme(originalColour);
        }
        this.annotation = annotation;
        this.aboveAnnotationThreshold = aboveThreshold;
        if (aboveThreshold != -1 && annotation.threshold != null) {
            this.annotationThreshold = annotation.threshold;
        }
        this.redMin = 254;
        this.greenMin = 254;
        this.blueMin = 254;
        this.redRange = 0;
        this.greenRange = 0;
        this.blueRange = 0;
        this.noGradient = true;
        this.checkLimits();
    }

    public AnnotationColourGradient(AlignmentAnnotation annotation, Color minColour, Color maxColour, int aboveThreshold) {
        this.annotation = annotation;
        this.aboveAnnotationThreshold = aboveThreshold;
        if (aboveThreshold != -1 && annotation.threshold != null) {
            this.annotationThreshold = annotation.threshold;
        }
        this.redMin = minColour.getRed();
        this.greenMin = minColour.getGreen();
        this.blueMin = minColour.getBlue();
        this.redRange = maxColour.getRed() - this.redMin;
        this.greenRange = maxColour.getGreen() - this.greenMin;
        this.blueRange = maxColour.getBlue() - this.blueMin;
        this.noGradient = false;
        this.checkLimits();
    }

    private void checkLimits() {
        this.aamax = this.annotation.graphMax;
        this.aamin = this.annotation.graphMin;
        if (this.annotation.isRNA()) {
            ColourSchemeProperty.resetRnaHelicesShading();
            ColourSchemeProperty.initRnaHelicesShading(1 + (int)this.aamax);
        }
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        super.alignmentChanged(alignment, hiddenReps);
        if (this.seqAssociated && this.annotation.getCalcId() != null) {
            if (this.seqannot != null) {
                this.seqannot.clear();
            } else {
                this.seqannot = new IdentityHashMap();
            }
            AnnotatedCollectionI alcontext = alignment instanceof AlignmentI ? alignment : alignment.getContext();
            boolean f = true;
            boolean sf = true;
            boolean rna = false;
            long plcount = 0L;
            long ancount = 0L;
            for (AlignmentAnnotation alan : alcontext.findAnnotation(this.annotation.getCalcId())) {
                if (alan.sequenceRef == null || alan.label == null || this.annotation == null || !alan.label.equals(this.annotation.label)) continue;
                ++ancount;
                if (!rna && alan.isRNA()) {
                    rna = true;
                }
                this.seqannot.put(alan.sequenceRef, alan);
                if (f || (double)alan.graphMax > this.aamax) {
                    this.aamax = alan.graphMax;
                }
                if (f || (double)alan.graphMin < this.aamin) {
                    this.aamin = alan.graphMin;
                }
                f = false;
                if (alan.score != alan.score) continue;
                if (sf || alan.score < this.plmin) {
                    this.plmin = alan.score;
                }
                if (sf || alan.score > this.plmax) {
                    this.plmax = alan.score;
                }
                sf = false;
                ++plcount;
            }
            if (plcount > 0L && plcount == ancount) {
                this.perLineScore = this.plmax != this.plmin;
                this.aamax = this.plmax;
            } else {
                this.perLineScore = false;
            }
            if (rna) {
                ColourSchemeProperty.initRnaHelicesShading(1 + (int)this.aamax);
            }
        }
    }

    public AlignmentAnnotation getAnnotation() {
        return this.annotation;
    }

    public int getAboveThreshold() {
        return this.aboveAnnotationThreshold;
    }

    public float getAnnotationThreshold() {
        if (this.annotationThreshold == null) {
            return 0.0f;
        }
        return this.annotationThreshold.value;
    }

    public Color getMinColour() {
        return new Color(this.redMin, this.greenMin, this.blueMin);
    }

    public Color getMaxColour() {
        return new Color(this.redMin + this.redRange, this.greenMin + this.greenRange, this.blueMin + this.blueRange);
    }

    @Override
    public Color findColour(char c) {
        return Color.red;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Color findColour(char c, int j, SequenceI seq) {
        AlignmentAnnotation ann = this.seqAssociated && this.seqannot != null ? this.seqannot.get(seq) : this.annotation;
        if (ann == null) return Color.white;
        if (ann.annotations == null) return Color.white;
        if (j >= ann.annotations.length) return Color.white;
        if (ann.annotations[j] == null) return Color.white;
        if (Comparison.isGap(c)) {
            return Color.white;
        }
        Annotation aj = ann.annotations[j];
        if (this.annotationThreshold != null) {
            if (this.aboveAnnotationThreshold == 1) {
                if (aj.value <= this.annotationThreshold.value) return Color.white;
            }
            if (this.aboveAnnotationThreshold == 0 && aj.value >= this.annotationThreshold.value) {
                return Color.white;
            }
        }
        if (this.predefinedColours && aj.colour != null && !aj.colour.equals(Color.black)) {
            return aj.colour;
        }
        Color result = Color.white;
        if (ann.hasIcons && ann.graph == 0) {
            if (aj.secondaryStructure <= ' ') return Color.white;
            if (aj.secondaryStructure == '.') return Color.white;
            if (aj.secondaryStructure == '-') return Color.white;
            if (this.getColourScheme() != null) {
                return this.getColourScheme().findColour(c, j, seq, null, 0.0f);
            }
            if (!ann.isRNA()) return ann.annotations[j].secondaryStructure == 'H' ? AnnotationRenderer.HELIX_COLOUR : (ann.annotations[j].secondaryStructure == 'E' ? AnnotationRenderer.SHEET_COLOUR : AnnotationRenderer.STEM_COLOUR);
            return ColourSchemeProperty.rnaHelices[(int)aj.value];
        }
        if (!this.noGradient) return this.shadeCalculation(ann, j);
        if (this.getColourScheme() != null) {
            return this.getColourScheme().findColour(c, j, seq, null, 0.0f);
        }
        if (aj.colour == null) return result;
        return aj.colour;
    }

    Color shadeCalculation(AlignmentAnnotation ann, int col) {
        float range = 1.0f;
        float value = ann.annotations[col].value;
        range = this.thresholdIsMinMax && ann.threshold != null && this.aboveAnnotationThreshold == 1 && value >= ann.threshold.value ? (ann.graphMax == ann.threshold.value ? 1.0f : (value - ann.threshold.value) / (ann.graphMax - ann.threshold.value)) : (this.thresholdIsMinMax && ann.threshold != null && this.aboveAnnotationThreshold == 0 && value <= ann.threshold.value ? (ann.graphMin == ann.threshold.value ? 0.0f : (value - ann.graphMin) / (ann.threshold.value - ann.graphMin)) : (ann.graphMax != ann.graphMin ? (value - ann.graphMin) / (ann.graphMax - ann.graphMin) : 0.0f));
        int trans = 0;
        int midtr = 239;
        if (this.perLineScore) {
            trans = (int)((1.0f - range) * (float)midtr);
            range = (float)((ann.score - this.plmin) / (this.plmax - this.aamin));
        }
        int dr = (int)((float)this.redRange * range + (float)this.redMin);
        int dg = (int)((float)this.greenRange * range + (float)this.greenMin);
        int db = (int)((float)this.blueRange * range + (float)this.blueMin);
        if (ann.score == ann.score && this.positionToTransparency) {
            return new Color(Math.min(dr + trans, midtr), Math.min(dg + trans, midtr), Math.min(db + trans, midtr));
        }
        return new Color(dr, dg, db);
    }

    public boolean isPredefinedColours() {
        return this.predefinedColours;
    }

    public void setPredefinedColours(boolean predefinedColours) {
        this.predefinedColours = predefinedColours;
    }

    public boolean isSeqAssociated() {
        return this.seqAssociated;
    }

    public void setSeqAssociated(boolean sassoc) {
        this.seqAssociated = sassoc;
    }

    public boolean isThresholdIsMinMax() {
        return this.thresholdIsMinMax;
    }

    public void setThresholdIsMinMax(boolean minMax) {
        this.thresholdIsMinMax = minMax;
    }

    @Override
    public String getSchemeName() {
        return "Annotation";
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    public boolean isPositionToTransparency() {
        return this.positionToTransparency;
    }

    public void setPositionToTransparency(boolean positionToTransparency) {
        this.positionToTransparency = positionToTransparency;
    }
}

